/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.Nullable;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Parcelable version of {@link RenderInput}.
 * @hide
 */
@DataClass(genAidl = false, genHiddenBuilder = true)
public final class RenderInputParcel implements Parcelable {
    /** The width of the slot. */
    private int mWidth = 0;

    /** The height of the slot. */
    private int mHeight = 0;

    /**
     * A {@link RenderingConfig} within an {@link ExecuteOutput} that was returned by
     * {@link IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}.
     */
    @Nullable RenderingConfig mRenderingConfig = null;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/RenderInputParcel.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ RenderInputParcel(
            int width,
            int height,
            @Nullable RenderingConfig renderingConfig) {
        this.mWidth = width;
        this.mHeight = height;
        this.mRenderingConfig = renderingConfig;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The width of the slot.
     */
    @DataClass.Generated.Member
    public int getWidth() {
        return mWidth;
    }

    /**
     * The height of the slot.
     */
    @DataClass.Generated.Member
    public int getHeight() {
        return mHeight;
    }

    /**
     * A {@link RenderingConfig} within an {@link ExecuteOutput} that was returned by
     * {@link IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}.
     */
    @DataClass.Generated.Member
    public @Nullable RenderingConfig getRenderingConfig() {
        return mRenderingConfig;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mRenderingConfig != null) flg |= 0x4;
        dest.writeByte(flg);
        dest.writeInt(mWidth);
        dest.writeInt(mHeight);
        if (mRenderingConfig != null) dest.writeTypedObject(mRenderingConfig, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ RenderInputParcel(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        int width = in.readInt();
        int height = in.readInt();
        RenderingConfig renderingConfig = (flg & 0x4) == 0 ? null : (RenderingConfig) in.readTypedObject(RenderingConfig.CREATOR);

        this.mWidth = width;
        this.mHeight = height;
        this.mRenderingConfig = renderingConfig;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<RenderInputParcel> CREATOR
            = new Parcelable.Creator<RenderInputParcel>() {
        @Override
        public RenderInputParcel[] newArray(int size) {
            return new RenderInputParcel[size];
        }

        @Override
        public RenderInputParcel createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new RenderInputParcel(in);
        }
    };

    /**
     * A builder for {@link RenderInputParcel}
     * @hide
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private int mWidth;
        private int mHeight;
        private @Nullable RenderingConfig mRenderingConfig;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * The width of the slot.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setWidth(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mWidth = value;
            return this;
        }

        /**
         * The height of the slot.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setHeight(int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mHeight = value;
            return this;
        }

        /**
         * A {@link RenderingConfig} within an {@link ExecuteOutput} that was returned by
         * {@link IsolatedWorker#onExecute(ExecuteInput, android.os.OutcomeReceiver)}.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setRenderingConfig(@android.annotation.NonNull RenderingConfig value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mRenderingConfig = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull RenderInputParcel build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mWidth = 0;
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mHeight = 0;
            }
            if ((mBuilderFieldsSet & 0x4) == 0) {
                mRenderingConfig = null;
            }
            RenderInputParcel o = new RenderInputParcel(
                    mWidth,
                    mHeight,
                    mRenderingConfig);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x8) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1704831939599L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/RenderInputParcel.java",
            inputSignatures = "private  int mWidth\nprivate  int mHeight\n @android.annotation.Nullable android.adservices.ondevicepersonalization.RenderingConfig mRenderingConfig\nclass RenderInputParcel extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genAidl=false, genHiddenBuilder=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
