/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.NonNull;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Values for OS versions.
*
* @hide
*/
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class OSVersion implements Parcelable {
    /** Major OS version. */
    @NonNull int mMajor;

    /** Minor OS version. */
    @NonNull int mMinor;

    /** Micro OS version. */
    @NonNull int mMicro;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/OSVersion.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ OSVersion(
            @NonNull int major,
            @NonNull int minor,
            @NonNull int micro) {
        this.mMajor = major;
        AnnotationValidations.validate(
                NonNull.class, null, mMajor);
        this.mMinor = minor;
        AnnotationValidations.validate(
                NonNull.class, null, mMinor);
        this.mMicro = micro;
        AnnotationValidations.validate(
                NonNull.class, null, mMicro);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Major OS version.
     */
    @DataClass.Generated.Member
    public @NonNull int getMajor() {
        return mMajor;
    }

    /**
     * Minor OS version.
     */
    @DataClass.Generated.Member
    public @NonNull int getMinor() {
        return mMinor;
    }

    /**
     * Micro OS version.
     */
    @DataClass.Generated.Member
    public @NonNull int getMicro() {
        return mMicro;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(OSVersion other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        OSVersion that = (OSVersion) o;
        //noinspection PointlessBooleanExpression
        return true
                && mMajor == that.mMajor
                && mMinor == that.mMinor
                && mMicro == that.mMicro;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mMajor;
        _hash = 31 * _hash + mMinor;
        _hash = 31 * _hash + mMicro;
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeInt(mMajor);
        dest.writeInt(mMinor);
        dest.writeInt(mMicro);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ OSVersion(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        int major = in.readInt();
        int minor = in.readInt();
        int micro = in.readInt();

        this.mMajor = major;
        AnnotationValidations.validate(
                NonNull.class, null, mMajor);
        this.mMinor = minor;
        AnnotationValidations.validate(
                NonNull.class, null, mMinor);
        this.mMicro = micro;
        AnnotationValidations.validate(
                NonNull.class, null, mMicro);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<OSVersion> CREATOR
            = new Parcelable.Creator<OSVersion>() {
        @Override
        public OSVersion[] newArray(int size) {
            return new OSVersion[size];
        }

        @Override
        public OSVersion createFromParcel(@NonNull android.os.Parcel in) {
            return new OSVersion(in);
        }
    };

    /**
     * A builder for {@link OSVersion}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull int mMajor;
        private @NonNull int mMinor;
        private @NonNull int mMicro;

        private long mBuilderFieldsSet = 0L;

        /**
         * Creates a new Builder.
         *
         * @param major
         *   Major OS version.
         * @param minor
         *   Minor OS version.
         * @param micro
         *   Micro OS version.
         */
        public Builder(
                @NonNull int major,
                @NonNull int minor,
                @NonNull int micro) {
            mMajor = major;
            AnnotationValidations.validate(
                    NonNull.class, null, mMajor);
            mMinor = minor;
            AnnotationValidations.validate(
                    NonNull.class, null, mMinor);
            mMicro = micro;
            AnnotationValidations.validate(
                    NonNull.class, null, mMicro);
        }

        public Builder() {
        }

        /**
         * Major OS version.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setMajor(@NonNull int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mMajor = value;
            return this;
        }

        /**
         * Minor OS version.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setMinor(@NonNull int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mMinor = value;
            return this;
        }

        /**
         * Micro OS version.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setMicro(@NonNull int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mMicro = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull OSVersion build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8; // Mark builder used

            OSVersion o = new OSVersion(
                    mMajor,
                    mMinor,
                    mMicro);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x8) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1692118390970L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/OSVersion.java",
            inputSignatures = " @android.annotation.NonNull int mMajor\n @android.annotation.NonNull int mMinor\n @android.annotation.NonNull int mMicro\nclass OSVersion extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
