/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.IntDef;
import android.annotation.NonNull;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/** @hide */
@DataClass(genAidl = false, genBuilder = true, genEqualsHashCode = true)
public final class ModelId implements Parcelable {

    public static final int TABLE_ID_REMOTE_DATA = 1;
    public static final int TABLE_ID_LOCAL_DATA = 2;

    @IntDef(
            prefix = "TABLE_ID_",
            value = {TABLE_ID_REMOTE_DATA, TABLE_ID_LOCAL_DATA})
    @Retention(RetentionPolicy.SOURCE)
    public @interface TABLE {}

    // The table name of the table where pre-trained model is stored. Only supports TFLite model
    // now.
    private @TABLE int mTableId;

    // The key of the table where the corresponding value stores a pre-trained model. Only supports
    // TFLite model now.
    @NonNull private String mKey;

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/ModelId.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @IntDef(
            prefix = "TABLE_ID_",
            value = {TABLE_ID_REMOTE_DATA, TABLE_ID_LOCAL_DATA})
    @Retention(RetentionPolicy.SOURCE)
    @DataClass.Generated.Member
    public @interface TableId {}

    @DataClass.Generated.Member
    public static String tableIdToString(@TableId int value) {
        switch (value) {
            case TABLE_ID_REMOTE_DATA:
                return "TABLE_ID_REMOTE_DATA";
            case TABLE_ID_LOCAL_DATA:
                return "TABLE_ID_LOCAL_DATA";
            default:
                return Integer.toHexString(value);
        }
    }

    @DataClass.Generated.Member
    /* package-private */ ModelId(@TABLE int tableId, @NonNull String key) {
        this.mTableId = tableId;
        AnnotationValidations.validate(TABLE.class, null, mTableId);
        this.mKey = key;
        AnnotationValidations.validate(NonNull.class, null, mKey);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public @TABLE int getTableId() {
        return mTableId;
    }

    @DataClass.Generated.Member
    public @NonNull String getKey() {
        return mKey;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(ModelId other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        ModelId that = (ModelId) o;
        //noinspection PointlessBooleanExpression
        return true && mTableId == that.mTableId && java.util.Objects.equals(mKey, that.mKey);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + mTableId;
        _hash = 31 * _hash + java.util.Objects.hashCode(mKey);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeInt(mTableId);
        dest.writeString(mKey);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() {
        return 0;
    }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ ModelId(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        int tableId = in.readInt();
        String key = in.readString();

        this.mTableId = tableId;
        AnnotationValidations.validate(TABLE.class, null, mTableId);
        this.mKey = key;
        AnnotationValidations.validate(NonNull.class, null, mKey);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<ModelId> CREATOR =
            new Parcelable.Creator<ModelId>() {
                @Override
                public ModelId[] newArray(int size) {
                    return new ModelId[size];
                }

                @Override
                public ModelId createFromParcel(@NonNull android.os.Parcel in) {
                    return new ModelId(in);
                }
            };

    /** A builder for {@link ModelId} */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @TABLE int mTableId;
        private @NonNull String mKey;

        private long mBuilderFieldsSet = 0L;

        public Builder() {}

        @DataClass.Generated.Member
        public @NonNull Builder setTableId(@TABLE int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mTableId = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setKey(@NonNull String value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mKey = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull ModelId build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            ModelId o = new ModelId(mTableId, mKey);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    // @formatter:on
    // End of generated code

}
