/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.IntRange;
import android.annotation.Nullable;
import android.content.ContentValues;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Input data to create example from. Represents a single joined log record.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public class JoinedLogRecord implements Parcelable {
    /** Time of the request in milliseconds */
    private final long mRequestTimeMillis;

    /** Time of the event in milliseconds */
    private final long mEventTimeMillis;

    /**
     * The service-assigned type that identifies the event data. Must be >0 and <128. If type is 0,
     * it is an Request-only row with no associated event.
     */
    @IntRange(from = 0, to = 127)
    private final int mType;

    /** Request data logged in a {@link RequestLogRecord} */
    @Nullable private ContentValues mRequestData = null;

    /** Event data logged in an {@link EventLogRecord} */
    @Nullable private ContentValues mEventData = null;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/JoinedLogRecord.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ JoinedLogRecord(
            long requestTimeMillis,
            long eventTimeMillis,
            @IntRange(from = 0, to = 127) int type,
            @Nullable ContentValues requestData,
            @Nullable ContentValues eventData) {
        this.mRequestTimeMillis = requestTimeMillis;
        this.mEventTimeMillis = eventTimeMillis;
        this.mType = type;
        AnnotationValidations.validate(
                IntRange.class, null, mType,
                "from", 0,
                "to", 127);
        this.mRequestData = requestData;
        this.mEventData = eventData;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Time of the request in milliseconds
     */
    @DataClass.Generated.Member
    public long getRequestTimeMillis() {
        return mRequestTimeMillis;
    }

    /**
     * Time of the event in milliseconds
     */
    @DataClass.Generated.Member
    public long getEventTimeMillis() {
        return mEventTimeMillis;
    }

    /**
     * The service-assigned type that identifies the event data. Must be >0 and <128. If type is 0,
     * it is an Request-only row with no associated event.
     */
    @DataClass.Generated.Member
    public @IntRange(from = 0, to = 127) int getType() {
        return mType;
    }

    /**
     * Request data logged in a {@link RequestLogRecord}
     */
    @DataClass.Generated.Member
    public @Nullable ContentValues getRequestData() {
        return mRequestData;
    }

    /**
     * Event data logged in an {@link EventLogRecord}
     */
    @DataClass.Generated.Member
    public @Nullable ContentValues getEventData() {
        return mEventData;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(JoinedLogRecord other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        JoinedLogRecord that = (JoinedLogRecord) o;
        //noinspection PointlessBooleanExpression
        return true
                && mRequestTimeMillis == that.mRequestTimeMillis
                && mEventTimeMillis == that.mEventTimeMillis
                && mType == that.mType
                && java.util.Objects.equals(mRequestData, that.mRequestData)
                && java.util.Objects.equals(mEventData, that.mEventData);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + Long.hashCode(mRequestTimeMillis);
        _hash = 31 * _hash + Long.hashCode(mEventTimeMillis);
        _hash = 31 * _hash + mType;
        _hash = 31 * _hash + java.util.Objects.hashCode(mRequestData);
        _hash = 31 * _hash + java.util.Objects.hashCode(mEventData);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mRequestData != null) flg |= 0x8;
        if (mEventData != null) flg |= 0x10;
        dest.writeByte(flg);
        dest.writeLong(mRequestTimeMillis);
        dest.writeLong(mEventTimeMillis);
        dest.writeInt(mType);
        if (mRequestData != null) dest.writeTypedObject(mRequestData, flags);
        if (mEventData != null) dest.writeTypedObject(mEventData, flags);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    protected JoinedLogRecord(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        long requestTimeMillis = in.readLong();
        long eventTimeMillis = in.readLong();
        int type = in.readInt();
        ContentValues requestData = (flg & 0x8) == 0 ? null : (ContentValues) in.readTypedObject(ContentValues.CREATOR);
        ContentValues eventData = (flg & 0x10) == 0 ? null : (ContentValues) in.readTypedObject(ContentValues.CREATOR);

        this.mRequestTimeMillis = requestTimeMillis;
        this.mEventTimeMillis = eventTimeMillis;
        this.mType = type;
        AnnotationValidations.validate(
                IntRange.class, null, mType,
                "from", 0,
                "to", 127);
        this.mRequestData = requestData;
        this.mEventData = eventData;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<JoinedLogRecord> CREATOR
            = new Parcelable.Creator<JoinedLogRecord>() {
        @Override
        public JoinedLogRecord[] newArray(int size) {
            return new JoinedLogRecord[size];
        }

        @Override
        public JoinedLogRecord createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new JoinedLogRecord(in);
        }
    };

    /**
     * A builder for {@link JoinedLogRecord}
     * @hide
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static class Builder {

        private long mRequestTimeMillis;
        private long mEventTimeMillis;
        private @IntRange(from = 0, to = 127) int mType;
        private @Nullable ContentValues mRequestData;
        private @Nullable ContentValues mEventData;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * Creates a new Builder.
         *
         * @param requestTimeMillis
         *   Time of the request in milliseconds
         * @param eventTimeMillis
         *   Time of the event in milliseconds
         * @param type
         *   The service-assigned type that identifies the event data. Must be >0 and <128. If type is 0,
         *   it is an Request-only row with no associated event.
         */
        public Builder(
                long requestTimeMillis,
                long eventTimeMillis,
                @IntRange(from = 0, to = 127) int type) {
            mRequestTimeMillis = requestTimeMillis;
            mEventTimeMillis = eventTimeMillis;
            mType = type;
            AnnotationValidations.validate(
                    IntRange.class, null, mType,
                    "from", 0,
                    "to", 127);
        }

        /**
         * Time of the request in milliseconds
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setRequestTimeMillis(long value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mRequestTimeMillis = value;
            return this;
        }

        /**
         * Time of the event in milliseconds
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setEventTimeMillis(long value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mEventTimeMillis = value;
            return this;
        }

        /**
         * The service-assigned type that identifies the event data. Must be >0 and <128. If type is 0,
         * it is an Request-only row with no associated event.
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setType(@IntRange(from = 0, to = 127) int value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mType = value;
            return this;
        }

        /**
         * Request data logged in a {@link RequestLogRecord}
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setRequestData(@android.annotation.NonNull ContentValues value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8;
            mRequestData = value;
            return this;
        }

        /**
         * Event data logged in an {@link EventLogRecord}
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setEventData(@android.annotation.NonNull ContentValues value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x10;
            mEventData = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull JoinedLogRecord build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x20; // Mark builder used

            if ((mBuilderFieldsSet & 0x8) == 0) {
                mRequestData = null;
            }
            if ((mBuilderFieldsSet & 0x10) == 0) {
                mEventData = null;
            }
            JoinedLogRecord o = new JoinedLogRecord(
                    mRequestTimeMillis,
                    mEventTimeMillis,
                    mType,
                    mRequestData,
                    mEventData);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x20) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1695413878624L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/JoinedLogRecord.java",
            inputSignatures = "private final  long mRequestTimeMillis\nprivate final  long mEventTimeMillis\nprivate final @android.annotation.IntRange int mType\nprivate @android.annotation.Nullable android.content.ContentValues mRequestData\nprivate @android.annotation.Nullable android.content.ContentValues mEventData\nclass JoinedLogRecord extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
