/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;

import com.android.adservices.ondevicepersonalization.flags.Flags;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

import java.util.Collections;
import java.util.Map;

/** The result returned by {@link ModelManager#run}. */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class InferenceOutput {
    /**
     * A map mapping output indices to multidimensional arrays of output.
     *
     * <p>For TFLite, this field is mapped to outputs of runForMultipleInputsOutputs:
     * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
     */
    @NonNull private Map<Integer, Object> mDataOutputs = Collections.emptyMap();

    /**
     * A byte array that holds input data. The inputs should be in the same order as inputs of the
     * model.
     *
     * <p>For LiteRT, this field is mapped to outputs of runForMultipleInputsOutputs:
     * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
     *
     * <p>For ExecuTorch model, this field is a serialized EValue array.
     *
     * @hide
     */
    @NonNull private byte[] mData = new byte[] {};

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/InferenceOutput.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @DataClass.Generated.Member
    /* package-private */ InferenceOutput(
            @NonNull Map<Integer, Object> dataOutputs, @NonNull byte[] data) {
        this.mDataOutputs = dataOutputs;
        AnnotationValidations.validate(NonNull.class, null, mDataOutputs);
        this.mData = data;
        AnnotationValidations.validate(NonNull.class, null, mData);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Note: use {@link InferenceOutput#getData()} instead.
     *
     * <p>A map mapping output indices to multidimensional arrays of output.
     *
     * <p>For TFLite, this field is mapped to outputs of runForMultipleInputsOutputs:
     * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
     */
    @DataClass.Generated.Member
    public @NonNull Map<Integer, Object> getDataOutputs() {
        return mDataOutputs;
    }

    /**
     * A byte array that holds input data. The inputs should be in the same order as inputs of the
     * model.
     *
     * <p>For LiteRT, this field is a serialized Map<Integer, Object> that is mapped to outputs of
     * runForMultipleInputsOutputs:
     * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
     *
     * <p>For ExecuTorch model, this field is a serialized EValue array.
     */
    @FlaggedApi(Flags.FLAG_EXECUTORCH_INFERENCE_API_ENABLED)
    @DataClass.Generated.Member
    public @NonNull byte[] getData() {
        return mData;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(InferenceOutput other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        InferenceOutput that = (InferenceOutput) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mDataOutputs, that.mDataOutputs)
                && java.util.Arrays.equals(mData, that.mData);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mDataOutputs);
        _hash = 31 * _hash + java.util.Arrays.hashCode(mData);
        return _hash;
    }

    /** A builder for {@link InferenceOutput} */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private @NonNull Map<Integer, Object> mDataOutputs;
        private @NonNull byte[] mData;

        private long mBuilderFieldsSet = 0L;

        public Builder() {}

        /**
         * Note: use {@link InferenceOutput.Builder#setData(byte[])} instead.
         *
         * <p>A map mapping output indices to multidimensional arrays of output.
         *
         * <p>For TFLite, this field is mapped to outputs of runForMultipleInputsOutputs:
         * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
         */
        @DataClass.Generated.Member
        public @NonNull Builder setDataOutputs(@NonNull Map<Integer, Object> value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mDataOutputs = value;
            return this;
        }

        /**
         * @see #setDataOutputs
         */
        @DataClass.Generated.Member
        public @NonNull Builder addDataOutput(int key, @NonNull Object value) {
            // You can refine this method's name by providing item's singular name, e.g.:
            // @DataClass.PluralOf("item")) mItems = ...

            if (mDataOutputs == null) setDataOutputs(new java.util.LinkedHashMap());
            mDataOutputs.put(key, value);
            return this;
        }

        /**
         * A byte array that holds input data. The inputs should be in the same order as inputs of
         * the model.
         *
         * <p>For LiteRT, this field is a serialized Map<Integer, Object> that is mapped to outputs
         * of runForMultipleInputsOutputs:
         * https://www.tensorflow.org/lite/api_docs/java/org/tensorflow/lite/InterpreterApi#parameters_9
         *
         * <p>For ExecuTorch model, this field is a serialized EValue array.
         */
        @FlaggedApi(Flags.FLAG_EXECUTORCH_INFERENCE_API_ENABLED)
        @DataClass.Generated.Member
        public @NonNull Builder setData(@NonNull byte[] value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mData = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull InferenceOutput build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mDataOutputs = Collections.emptyMap();
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mData = new byte[] {};
            }
            InferenceOutput o = new InferenceOutput(mDataOutputs, mData);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x4) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1730515027336L,
            codegenVersion = "1.0.23",
            sourceFile =
                    "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/InferenceOutput.java",
            inputSignatures =
                    "private static final  java.lang.String TAG\nprivate static final  com.android.ondevicepersonalization.internal.util.LoggerFactory.Logger sLogger\nprivate @android.annotation.NonNull java.util.Map<java.lang.Integer,java.lang.Object> mDataOutputs\nprivate @android.annotation.NonNull byte[] mData\nclass InferenceOutput extends java.lang.Object implements []\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}

    // @formatter:on
    // End of generated code

}
