/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;

import com.android.adservices.ondevicepersonalization.flags.Flags;
import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * The result returned by {@link FederatedComputeScheduler#schedule(FederatedComputeScheduleRequest,
 * java.util.concurrent.Executor, android.os.OutcomeReceiver)} when successful.
 */
@DataClass(genEqualsHashCode = true)
@FlaggedApi(Flags.FLAG_FCP_SCHEDULE_WITH_OUTCOME_RECEIVER_ENABLED)
public final class FederatedComputeScheduleResponse {

    @NonNull private FederatedComputeScheduleRequest mFederatedComputeScheduleRequest;

    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen
    // $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/FederatedComputeScheduleResponse.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    // @formatter:off

    @DataClass.Generated.Member
    public FederatedComputeScheduleResponse(
            @NonNull FederatedComputeScheduleRequest federatedComputeScheduleRequest) {
        this.mFederatedComputeScheduleRequest = federatedComputeScheduleRequest;
        AnnotationValidations.validate(NonNull.class, null, mFederatedComputeScheduleRequest);

        // onConstructed(); // You can define this method to get a callback
    }

    /** The request associated with this response. */
    @DataClass.Generated.Member
    public @NonNull FederatedComputeScheduleRequest getFederatedComputeScheduleRequest() {
        return mFederatedComputeScheduleRequest;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(FederatedComputeScheduleResponse other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        FederatedComputeScheduleResponse that = (FederatedComputeScheduleResponse) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(
                        mFederatedComputeScheduleRequest, that.mFederatedComputeScheduleRequest);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mFederatedComputeScheduleRequest);
        return _hash;
    }

    @DataClass.Generated(
            time = 1725476292347L,
            codegenVersion = "1.0.23",
            sourceFile =
                    "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/FederatedComputeScheduleResponse.java",
            inputSignatures =
                    "private @android.annotation.NonNull java.lang.String mPopulationName\n"
                        + "class FederatedComputeScheduleResponse extends java.lang.Object"
                        + " implements []\n"
                        + "@com.android.ondevicepersonalization.internal.util.DataClass(genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}

    // @formatter:on
    // End of generated code

}
