/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.Nullable;
import android.os.IBinder;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * The input sent to the {@link IsolatedService}.
 *
 * @hide
 */
@DataClass(genBuilder = true, genEqualsHashCode = true)
public class DownloadInputParcel implements Parcelable {
    /** DataAccessService binder for downloaded content */
    @Nullable
    IBinder mDataAccessServiceBinder = null;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/DownloadInputParcel.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ DownloadInputParcel(
            @Nullable IBinder dataAccessServiceBinder) {
        this.mDataAccessServiceBinder = dataAccessServiceBinder;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * DataAccessService binder for downloaded content
     */
    @DataClass.Generated.Member
    public @Nullable IBinder getDataAccessServiceBinder() {
        return mDataAccessServiceBinder;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(DownloadInputParcel other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        DownloadInputParcel that = (DownloadInputParcel) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mDataAccessServiceBinder, that.mDataAccessServiceBinder);
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mDataAccessServiceBinder);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mDataAccessServiceBinder != null) flg |= 0x1;
        dest.writeByte(flg);
        if (mDataAccessServiceBinder != null) dest.writeStrongBinder(mDataAccessServiceBinder);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    protected DownloadInputParcel(@android.annotation.NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        IBinder dataAccessServiceBinder = (flg & 0x1) == 0 ? null : (IBinder) in.readStrongBinder();

        this.mDataAccessServiceBinder = dataAccessServiceBinder;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @android.annotation.NonNull Parcelable.Creator<DownloadInputParcel> CREATOR
            = new Parcelable.Creator<DownloadInputParcel>() {
        @Override
        public DownloadInputParcel[] newArray(int size) {
            return new DownloadInputParcel[size];
        }

        @Override
        public DownloadInputParcel createFromParcel(@android.annotation.NonNull android.os.Parcel in) {
            return new DownloadInputParcel(in);
        }
    };

    /**
     * A builder for {@link DownloadInputParcel}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static class Builder {

        private @Nullable IBinder mDataAccessServiceBinder;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * DataAccessService binder for downloaded content
         */
        @DataClass.Generated.Member
        public @android.annotation.NonNull Builder setDataAccessServiceBinder(@android.annotation.NonNull IBinder value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mDataAccessServiceBinder = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @android.annotation.NonNull DownloadInputParcel build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mDataAccessServiceBinder = null;
            }
            DownloadInputParcel o = new DownloadInputParcel(
                    mDataAccessServiceBinder);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x2) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1705968510939L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/DownloadInputParcel.java",
            inputSignatures = " @android.annotation.Nullable android.adservices.ondevicepersonalization.IBinder mDataAccessServiceBinder\nclass DownloadInputParcel extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
