/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.NonNull;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.AnnotationValidations;
import com.android.ondevicepersonalization.internal.util.DataClass;

import java.util.Collections;
import java.util.List;

/**
 * Parcelable version of {@link DownloadCompletedOutput}.
 * @hide
 */
@DataClass(genAidl = false, genBuilder =  false)
public final class DownloadCompletedOutputParcel implements Parcelable {
    /**
     * The keys to be retained in the REMOTE_DATA table. Any existing keys that are not
     * present in this list are removed from the table.
     */
    @NonNull private List<String> mRetainedKeys = Collections.emptyList();

    /** @hide */
    public DownloadCompletedOutputParcel(@NonNull DownloadCompletedOutput value) {
        this(value.getRetainedKeys());
    }



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/DownloadCompletedOutputParcel.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new DownloadCompletedOutputParcel.
     *
     * @param retainedKeys
     *   The keys to be retained in the REMOTE_DATA table. Any existing keys that are not
     *   present in this list are removed from the table.
     */
    @DataClass.Generated.Member
    public DownloadCompletedOutputParcel(
            @NonNull List<String> retainedKeys) {
        this.mRetainedKeys = retainedKeys;
        AnnotationValidations.validate(
                NonNull.class, null, mRetainedKeys);

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The keys to be retained in the REMOTE_DATA table. Any existing keys that are not
     * present in this list are removed from the table.
     */
    @DataClass.Generated.Member
    public @NonNull List<String> getRetainedKeys() {
        return mRetainedKeys;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeStringList(mRetainedKeys);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ DownloadCompletedOutputParcel(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        List<String> retainedKeys = new java.util.ArrayList<>();
        in.readStringList(retainedKeys);

        this.mRetainedKeys = retainedKeys;
        AnnotationValidations.validate(
                NonNull.class, null, mRetainedKeys);

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<DownloadCompletedOutputParcel> CREATOR
            = new Parcelable.Creator<DownloadCompletedOutputParcel>() {
        @Override
        public DownloadCompletedOutputParcel[] newArray(int size) {
            return new DownloadCompletedOutputParcel[size];
        }

        @Override
        public DownloadCompletedOutputParcel createFromParcel(@NonNull android.os.Parcel in) {
            return new DownloadCompletedOutputParcel(in);
        }
    };

    @DataClass.Generated(
            time = 1698783477713L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/DownloadCompletedOutputParcel.java",
            inputSignatures = "private @android.annotation.NonNull java.util.List<java.lang.String> mRetainedKeys\nclass DownloadCompletedOutputParcel extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genAidl=false, genBuilder=false)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
