/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.adservices.ondevicepersonalization;

import android.annotation.NonNull;
import android.os.Parcelable;

import com.android.ondevicepersonalization.internal.util.DataClass;

/**
 * Wrapper class for additional information returned with IPC results.
*
* @hide
*/
@DataClass(genBuilder = true, genEqualsHashCode = true)
public final class CalleeMetadata implements Parcelable {
    /** Time elapsed in callee, as measured by callee. */
    private long mElapsedTimeMillis = 0;
    private long mServiceEntryTimeMillis = 0;
    private long mCallbackInvokeTimeMillis = 0;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/CalleeMetadata.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    @DataClass.Generated.Member
    /* package-private */ CalleeMetadata(
            long elapsedTimeMillis,
            long serviceEntryTimeMillis,
            long callbackInvokeTimeMillis) {
        this.mElapsedTimeMillis = elapsedTimeMillis;
        this.mServiceEntryTimeMillis = serviceEntryTimeMillis;
        this.mCallbackInvokeTimeMillis = callbackInvokeTimeMillis;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Time elapsed in callee, as measured by callee.
     */
    @DataClass.Generated.Member
    public long getElapsedTimeMillis() {
        return mElapsedTimeMillis;
    }

    @DataClass.Generated.Member
    public long getServiceEntryTimeMillis() {
        return mServiceEntryTimeMillis;
    }

    @DataClass.Generated.Member
    public long getCallbackInvokeTimeMillis() {
        return mCallbackInvokeTimeMillis;
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(CalleeMetadata other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        CalleeMetadata that = (CalleeMetadata) o;
        //noinspection PointlessBooleanExpression
        return true
                && mElapsedTimeMillis == that.mElapsedTimeMillis
                && mServiceEntryTimeMillis == that.mServiceEntryTimeMillis
                && mCallbackInvokeTimeMillis == that.mCallbackInvokeTimeMillis;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + Long.hashCode(mElapsedTimeMillis);
        _hash = 31 * _hash + Long.hashCode(mServiceEntryTimeMillis);
        _hash = 31 * _hash + Long.hashCode(mCallbackInvokeTimeMillis);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeLong(mElapsedTimeMillis);
        dest.writeLong(mServiceEntryTimeMillis);
        dest.writeLong(mCallbackInvokeTimeMillis);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ CalleeMetadata(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        long elapsedTimeMillis = in.readLong();
        long serviceEntryTimeMillis = in.readLong();
        long callbackInvokeTimeMillis = in.readLong();

        this.mElapsedTimeMillis = elapsedTimeMillis;
        this.mServiceEntryTimeMillis = serviceEntryTimeMillis;
        this.mCallbackInvokeTimeMillis = callbackInvokeTimeMillis;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<CalleeMetadata> CREATOR
            = new Parcelable.Creator<CalleeMetadata>() {
        @Override
        public CalleeMetadata[] newArray(int size) {
            return new CalleeMetadata[size];
        }

        @Override
        public CalleeMetadata createFromParcel(@NonNull android.os.Parcel in) {
            return new CalleeMetadata(in);
        }
    };

    /**
     * A builder for {@link CalleeMetadata}
     */
    @SuppressWarnings("WeakerAccess")
    @DataClass.Generated.Member
    public static final class Builder {

        private long mElapsedTimeMillis;
        private long mServiceEntryTimeMillis;
        private long mCallbackInvokeTimeMillis;

        private long mBuilderFieldsSet = 0L;

        public Builder() {
        }

        /**
         * Time elapsed in callee, as measured by callee.
         */
        @DataClass.Generated.Member
        public @NonNull Builder setElapsedTimeMillis(long value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x1;
            mElapsedTimeMillis = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setServiceEntryTimeMillis(long value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x2;
            mServiceEntryTimeMillis = value;
            return this;
        }

        @DataClass.Generated.Member
        public @NonNull Builder setCallbackInvokeTimeMillis(long value) {
            checkNotUsed();
            mBuilderFieldsSet |= 0x4;
            mCallbackInvokeTimeMillis = value;
            return this;
        }

        /** Builds the instance. This builder should not be touched after calling this! */
        public @NonNull CalleeMetadata build() {
            checkNotUsed();
            mBuilderFieldsSet |= 0x8; // Mark builder used

            if ((mBuilderFieldsSet & 0x1) == 0) {
                mElapsedTimeMillis = 0;
            }
            if ((mBuilderFieldsSet & 0x2) == 0) {
                mServiceEntryTimeMillis = 0;
            }
            if ((mBuilderFieldsSet & 0x4) == 0) {
                mCallbackInvokeTimeMillis = 0;
            }
            CalleeMetadata o = new CalleeMetadata(
                    mElapsedTimeMillis,
                    mServiceEntryTimeMillis,
                    mCallbackInvokeTimeMillis);
            return o;
        }

        private void checkNotUsed() {
            if ((mBuilderFieldsSet & 0x8) != 0) {
                throw new IllegalStateException(
                        "This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @DataClass.Generated(
            time = 1716227988090L,
            codegenVersion = "1.0.23",
            sourceFile = "packages/modules/OnDevicePersonalization/framework/java/android/adservices/ondevicepersonalization/CalleeMetadata.java",
            inputSignatures = "private  long mElapsedTimeMillis\nprivate  long mServiceEntryTimeMillis\nprivate  long mCallbackInvokeTimeMillis\nclass CalleeMetadata extends java.lang.Object implements [android.os.Parcelable]\n@com.android.ondevicepersonalization.internal.util.DataClass(genBuilder=true, genEqualsHashCode=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
