/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsDependenciesEnumerator;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;
import org.jetbrains.jps.model.module.JpsSdkDependency;

public abstract class JpsDependenciesEnumeratorBase<Self extends JpsDependenciesEnumerator>
implements JpsDependenciesEnumerator {
    private boolean myWithoutSdk;
    private boolean myWithoutLibraries;
    private boolean myWithoutDepModules;
    private boolean myWithoutModuleSourceEntries;
    protected boolean myRecursively;
    private final Set<JpsModule> myRootModules;
    private Condition<? super JpsDependencyElement> myCondition;

    protected JpsDependenciesEnumeratorBase(Collection<JpsModule> rootModules) {
        this.myRootModules = Collections.unmodifiableSet(rootModules instanceof Set ? (Set<Object>)rootModules : new LinkedHashSet<JpsModule>(rootModules));
    }

    @NotNull
    public Self withoutLibraries() {
        this.myWithoutLibraries = true;
        Self Self = this.self();
        if (Self == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(0);
        }
        return Self;
    }

    @NotNull
    public Self withoutDepModules() {
        this.myWithoutDepModules = true;
        Self Self = this.self();
        if (Self == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(1);
        }
        return Self;
    }

    @NotNull
    public Self withoutSdk() {
        this.myWithoutSdk = true;
        Self Self = this.self();
        if (Self == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(2);
        }
        return Self;
    }

    @NotNull
    public Self withoutModuleSourceEntries() {
        this.myWithoutModuleSourceEntries = true;
        Self Self = this.self();
        if (Self == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(3);
        }
        return Self;
    }

    @NotNull
    public Self satisfying(@NotNull Condition<? super JpsDependencyElement> condition) {
        if (condition == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(4);
        }
        this.myCondition = condition;
        Self Self = this.self();
        if (Self == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(5);
        }
        return Self;
    }

    @NotNull
    public Self recursively() {
        this.myRecursively = true;
        Self Self = this.self();
        if (Self == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(6);
        }
        return Self;
    }

    protected abstract Self self();

    @Override
    @NotNull
    public Set<JpsModule> getModules() {
        LinkedHashSet<JpsModule> result2 = new LinkedHashSet<JpsModule>();
        this.processModules(new CollectConsumer(result2));
        LinkedHashSet<JpsModule> linkedHashSet = result2;
        if (linkedHashSet == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @Override
    public void processModules(@NotNull Consumer<? super JpsModule> consumer2) {
        if (consumer2 == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(8);
        }
        this.processModuleAndLibraries(consumer2, EmptyConsumer.getInstance());
    }

    protected boolean shouldProcessDependenciesRecursively() {
        return true;
    }

    public boolean processDependencies(Processor<? super JpsDependencyElement> processor) {
        Set processed2 = CollectionFactory.createSmallMemoryFootprintSet();
        for (JpsModule module : this.myRootModules) {
            if (this.doProcessDependencies(module, processor, processed2)) continue;
            return false;
        }
        return true;
    }

    private boolean doProcessDependencies(JpsModule module, Processor<? super JpsDependencyElement> processor, Set<? super JpsModule> processed2) {
        if (!processed2.add(module)) {
            return true;
        }
        for (JpsDependencyElement element : module.getDependenciesList().getDependencies()) {
            if (this.myCondition != null && !this.myCondition.value(element) || this.myWithoutSdk && element instanceof JpsSdkDependency || this.myWithoutLibraries && element instanceof JpsLibraryDependency || this.myWithoutModuleSourceEntries && element instanceof JpsModuleSourceDependency || this.myWithoutDepModules && (!this.myRecursively && element instanceof JpsModuleDependency || element instanceof JpsModuleSourceDependency && !this.isEnumerationRootModule(module)) || !this.shouldProcess(module, element)) continue;
            if (element instanceof JpsModuleDependency) {
                JpsModule depModule;
                if (this.myRecursively && this.shouldProcessDependenciesRecursively() && (depModule = ((JpsModuleDependency)element).getModule()) != null) {
                    if (this.doProcessDependencies(depModule, processor, processed2)) continue;
                    return false;
                }
                if (this.myWithoutDepModules) continue;
            }
            if (processor.process(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldProcess(JpsModule module, JpsDependencyElement element) {
        return true;
    }

    public boolean isEnumerationRootModule(JpsModule module) {
        return this.myRootModules.contains(module);
    }

    @Override
    @NotNull
    public Set<JpsLibrary> getLibraries() {
        LinkedHashSet<JpsLibrary> libraries = new LinkedHashSet<JpsLibrary>();
        this.processLibraries(new CollectConsumer(libraries));
        LinkedHashSet<JpsLibrary> linkedHashSet = libraries;
        if (linkedHashSet == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @Override
    public void processLibraries(@NotNull Consumer<? super JpsLibrary> consumer2) {
        if (consumer2 == null) {
            JpsDependenciesEnumeratorBase.$$$reportNull$$$0(10);
        }
        this.processModuleAndLibraries(EmptyConsumer.getInstance(), consumer2);
    }

    @Override
    public void processModuleAndLibraries(@Nullable Consumer<? super JpsModule> moduleConsumer, @Nullable Consumer<? super JpsLibrary> libraryConsumer) {
        this.processDependencies(dependencyElement -> {
            JpsLibrary library;
            if (moduleConsumer != null) {
                JpsModule module;
                if (this.myRecursively && dependencyElement instanceof JpsModuleSourceDependency) {
                    moduleConsumer.consume(dependencyElement.getContainingModule());
                } else if (!(this.myRecursively && this.shouldProcessDependenciesRecursively() || !(dependencyElement instanceof JpsModuleDependency) || (module = ((JpsModuleDependency)dependencyElement).getModule()) == null)) {
                    moduleConsumer.consume(module);
                }
            }
            if (libraryConsumer != null && dependencyElement instanceof JpsLibraryDependency && (library = ((JpsLibraryDependency)dependencyElement).getLibrary()) != null) {
                libraryConsumer.consume(library);
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutLibraries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutDepModules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutSdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutModuleSourceEntries";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/module/impl/JpsDependenciesEnumeratorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "satisfying";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "recursively";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "satisfying";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processModules";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

