/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Function;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.CompletablePromise;
import org.jetbrains.concurrency.InternalPromiseUtilKt;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseValue;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\u0014\u0010\u000e\u001a\t\u0018\u00018\u0000\u00a2\u0006\u0002\b\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J \u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0010\u0010\u0019\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000\u001aH\u0016J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0010\u0010\u001c\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000\u0002H\u0016J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0010\u0010\u0019\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00000\u001aH\u0016J \u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0010\u0010\u0019\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001f0\u001aH\u0016J2\u0010 \u001a\b\u0012\u0004\u0012\u0002H!0\u0002\"\n\b\u0001\u0010!*\u0004\u0018\u00010\"2\u0016\u0010#\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H!0$H\u0016J8\u0010%\u001a\b\u0012\u0004\u0012\u0002H!0\u0002\"\n\b\u0001\u0010!*\u0004\u0018\u00010\"2\u001c\u0010#\u001a\u0018\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H!0\u00020$H\u0016J\u001f\u0010&\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010)J\b\u0010\u0016\u001a\u00020*H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/concurrency/DonePromise;", "T", "Lorg/jetbrains/concurrency/Promise;", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/concurrency/CancellablePromise;", "value", "Lorg/jetbrains/concurrency/PromiseValue;", "<init>", "(Lorg/jetbrains/concurrency/PromiseValue;)V", "isDone", "", "getState", "Lorg/jetbrains/concurrency/Promise$State;", "isCancelled", "get", "Lorg/jetbrains/annotations/Nullable;", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "cancel", "mayInterruptIfRunning", "onSuccess", "handler", "Ljava/util/function/Consumer;", "processed", "child", "onProcessed", "onError", "", "then", "SUB_RESULT", "", "done", "Lcom/intellij/util/Function;", "thenAsync", "blockingGet", "", "timeUnit", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "", "intellij.platform.concurrency"})
final class DonePromise<T>
implements Promise<T>,
Future<T>,
CancellablePromise<T> {
    @NotNull
    private final PromiseValue<T> value;

    public DonePromise(@NotNull PromiseValue<T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.value = value;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    @NotNull
    public Promise.State getState() {
        return this.value.getState();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    @Nullable
    public T get() {
        return this.blockingGet(-1);
    }

    @Override
    @Nullable
    public T get(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.blockingGet((int)timeout, unit);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.getState() == Promise.State.PENDING) {
            this.cancel();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public CancellablePromise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.value.getError() != null) {
            return this;
        }
        if (!InternalPromiseUtilKt.isHandlerObsolete(handler)) {
            handler.accept(this.value.getResult());
        }
        return this;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        if (child instanceof CompletablePromise) {
            if (this.value.getError() != null) {
                ((CompletablePromise)child).setError(this.value.getError());
            } else {
                ((CompletablePromise)child).setResult(this.value.getResult());
            }
        }
        return this;
    }

    @Override
    @NotNull
    public CancellablePromise<T> onProcessed(@NotNull Consumer<? super T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.value.getError() == null) {
            this.onSuccess(handler);
        } else if (!InternalPromiseUtilKt.isHandlerObsolete(handler)) {
            handler.accept(null);
        }
        return this;
    }

    @Override
    @NotNull
    public CancellablePromise<T> onError(@NotNull Consumer<? super Throwable> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.value.getError() != null && !InternalPromiseUtilKt.isHandlerObsolete(handler)) {
            handler.accept(this.value.getError());
        }
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        Promise promise;
        Intrinsics.checkNotNullParameter(done2, (String)"done");
        if (this.value.getError() != null) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<SUB_RESULT of org.jetbrains.concurrency.DonePromise.then>");
            promise = this;
        } else {
            promise = InternalPromiseUtilKt.isHandlerObsolete(done2) ? Promises.cancelledPromise() : (Promise)new DonePromise<SUB_RESULT>(PromiseValue.Companion.createFulfilled(done2.fun(this.value.getResult())));
        }
        return promise;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, ? extends Promise<SUB_RESULT>> done2) {
        Intrinsics.checkNotNullParameter(done2, (String)"done");
        if (this.value.getError() == null) {
            Promise<SUB_RESULT> promise = done2.fun(this.value.getResult());
            Intrinsics.checkNotNullExpressionValue(promise, (String)"fun(...)");
            return promise;
        }
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<SUB_RESULT of org.jetbrains.concurrency.DonePromise.thenAsync>");
        return this;
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        return this.value.getResultOrThrowError();
    }

    @Override
    public void cancel() {
    }
}

