/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.serializers.ImmutableSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;

public class RecordSerializer<T>
extends ImmutableSerializer<T> {
    private static final Method IS_RECORD;
    private static final Method GET_RECORD_COMPONENTS;
    private static final Method GET_NAME;
    private static final Method GET_TYPE;
    private static final ClassValue<Constructor<?>> CONSTRUCTOR;
    private static final ClassValue<RecordComponent[]> RECORD_COMPONENTS;
    private boolean fixedFieldTypes = false;

    @Deprecated(forRemoval=true)
    public RecordSerializer() {
    }

    public RecordSerializer(Class<T> clazz) {
        if (!this.isRecord(clazz)) {
            throw new KryoException(clazz + " is not a record");
        }
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        for (RecordComponent rc : RECORD_COMPONENTS.get(object.getClass())) {
            Class<?> type = rc.type();
            String name = rc.name();
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write property: " + name + " (" + type.getName() + ")");
                }
                if (type.isPrimitive()) {
                    kryo.writeObject(output, rc.getValue(object));
                    continue;
                }
                if (this.fixedFieldTypes || kryo.isFinal(type)) {
                    kryo.writeObjectOrNull(output, rc.getValue(object), type);
                    continue;
                }
                kryo.writeClassAndObject(output, rc.getValue(object));
            }
            catch (KryoException ex) {
                ex.addTrace(name + " (" + type.getName() + ")");
                throw ex;
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(name + " (" + type.getName() + ")");
                throw ex;
            }
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        RecordComponent[] components2 = RECORD_COMPONENTS.get(type);
        Object[] values2 = new Object[components2.length];
        for (int i = 0; i < components2.length; ++i) {
            RecordComponent rc = components2[i];
            String name = rc.name();
            Class<?> rcType = rc.type();
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Read property: " + name + " (" + type.getName() + ")");
                }
                if (rcType.isPrimitive()) {
                    values2[rc.index()] = kryo.readObject(input, rcType);
                    continue;
                }
                if (this.fixedFieldTypes || kryo.isFinal(rcType)) {
                    values2[rc.index()] = kryo.readObjectOrNull(input, rcType);
                    continue;
                }
                values2[rc.index()] = kryo.readClassAndObject(input);
                continue;
            }
            catch (KryoException ex) {
                ex.addTrace(name + " (" + type.getName() + ")");
                throw ex;
            }
            catch (Throwable t) {
                KryoException ex = new KryoException(t);
                ex.addTrace(name + " (" + type.getName() + ")");
                throw ex;
            }
        }
        return this.invokeCanonicalConstructor(type, values2);
    }

    private boolean isRecord(Class<?> type) {
        try {
            return (Boolean)IS_RECORD.invoke(type, new Object[0]);
        }
        catch (Throwable t) {
            throw new KryoException("Could not determine type (" + type + ")");
        }
    }

    private static <T> RecordComponent[] recordComponents(Class<T> type, Comparator<RecordComponent> comparator) {
        try {
            Object[] rawComponents = (Object[])GET_RECORD_COMPONENTS.invoke(type, new Object[0]);
            RecordComponent[] recordComponents = new RecordComponent[rawComponents.length];
            for (int i = 0; i < rawComponents.length; ++i) {
                Object comp = rawComponents[i];
                recordComponents[i] = new RecordComponent(type, (String)GET_NAME.invoke(comp, new Object[0]), (Class)GET_TYPE.invoke(comp, new Object[0]), i);
            }
            if (comparator != null) {
                Arrays.sort(recordComponents, comparator);
            }
            return recordComponents;
        }
        catch (Throwable t) {
            KryoException ex = new KryoException(t);
            ex.addTrace("Could not retrieve record components (" + type.getName() + ")");
            throw ex;
        }
    }

    private T invokeCanonicalConstructor(Class<? extends T> recordType, Object[] args) {
        try {
            return (T)CONSTRUCTOR.get(recordType).newInstance(args);
        }
        catch (Throwable t) {
            KryoException ex = new KryoException(t);
            ex.addTrace("Could not construct type (" + recordType.getName() + ")");
            throw ex;
        }
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> recordType, RecordComponent[] recordComponents) {
        try {
            Class[] paramTypes = (Class[])Arrays.stream(recordComponents).map(RecordComponent::type).toArray(Class[]::new);
            return RecordSerializer.getCanonicalConstructor(recordType, paramTypes);
        }
        catch (Throwable t) {
            KryoException ex = new KryoException(t);
            ex.addTrace("Could not retrieve record canonical constructor (" + recordType.getName() + ")");
            throw ex;
        }
    }

    private static <T> Constructor<T> getCanonicalConstructor(Class<T> recordType, Class<?>[] paramTypes) throws NoSuchMethodException {
        Constructor<T> canonicalConstructor;
        try {
            canonicalConstructor = recordType.getConstructor(paramTypes);
            if (!canonicalConstructor.canAccess(null)) {
                canonicalConstructor.setAccessible(true);
            }
        }
        catch (Exception e) {
            canonicalConstructor = recordType.getDeclaredConstructor(paramTypes);
            canonicalConstructor.setAccessible(true);
        }
        return canonicalConstructor;
    }

    public void setFixedFieldTypes(boolean fixedFieldTypes) {
        this.fixedFieldTypes = fixedFieldTypes;
    }

    static {
        Method getType;
        Method getName;
        Method getRecordComponents;
        Method isRecord;
        try {
            Class<?> c = Class.forName("java.lang.reflect.RecordComponent");
            isRecord = Class.class.getDeclaredMethod("isRecord", new Class[0]);
            getRecordComponents = Class.class.getMethod("getRecordComponents", new Class[0]);
            getName = c.getMethod("getName", new Class[0]);
            getType = c.getMethod("getType", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            isRecord = null;
            getRecordComponents = null;
            getName = null;
            getType = null;
        }
        IS_RECORD = isRecord;
        GET_RECORD_COMPONENTS = getRecordComponents;
        GET_NAME = getName;
        GET_TYPE = getType;
        CONSTRUCTOR = new ClassValue<Constructor<?>>(){

            @Override
            protected Constructor<?> computeValue(Class<?> clazz) {
                RecordComponent[] components2 = RecordSerializer.recordComponents(clazz, Comparator.comparing(RecordComponent::index));
                return RecordSerializer.getCanonicalConstructor(clazz, components2);
            }
        };
        RECORD_COMPONENTS = new ClassValue<RecordComponent[]>(){

            @Override
            protected RecordComponent[] computeValue(Class<?> type) {
                return RecordSerializer.recordComponents(type, Comparator.comparing(RecordComponent::name));
            }
        };
    }

    static final class RecordComponent {
        private final Class<?> recordType;
        private final String name;
        private final Class<?> type;
        private final int index;
        private final Method getter;

        RecordComponent(Class<?> recordType, String name, Class<?> type, int index) {
            this.recordType = recordType;
            this.name = name;
            this.type = type;
            this.index = index;
            try {
                this.getter = recordType.getDeclaredMethod(name, new Class[0]);
                if (!this.getter.isAccessible()) {
                    this.getter.setAccessible(true);
                }
            }
            catch (Exception t) {
                KryoException ex = new KryoException(t);
                ex.addTrace("Could not retrieve record component getter (" + recordType.getName() + ")");
                throw ex;
            }
        }

        String name() {
            return this.name;
        }

        Class<?> type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        Object getValue(Object recordObject) {
            try {
                return this.getter.invoke(recordObject, new Object[0]);
            }
            catch (Exception t) {
                KryoException ex = new KryoException(t);
                ex.addTrace("Could not retrieve record component value (" + this.recordType.getName() + ")");
                throw ex;
            }
        }
    }
}

