/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Main;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.ReporterKt;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.ApplicableVariants;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u000eJ&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H\u0016J\u001c\u0010&\u001a\u00020\u001e2\n\u0010'\u001a\u00060(j\u0002`)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+H\u0002J\u001e\u0010-\u001a\u00020\u001e2\n\u0010.\u001a\u00060(j\u0002`)2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u000e\u00101\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/lint/TextReporter;", "Lcom/android/tools/lint/Reporter;", "client", "Lcom/android/tools/lint/LintCliClient;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "file", "Ljava/io/File;", "writer", "Ljava/io/Writer;", "close", "", "<init>", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/LintCliFlags;Ljava/io/File;Ljava/io/Writer;Z)V", "(Lcom/android/tools/lint/LintCliClient;Lcom/android/tools/lint/LintCliFlags;Ljava/io/Writer;Z)V", "format", "Lcom/android/tools/lint/detector/api/TextFormat;", "getFormat", "()Lcom/android/tools/lint/detector/api/TextFormat;", "setFormat", "(Lcom/android/tools/lint/detector/api/TextFormat;)V", "isForwardSlashPaths", "()Z", "setForwardSlashPaths", "(Z)V", "includeSecondaryLineContent", "getIncludeSecondaryLineContent", "setIncludeSecondaryLineContent", "writeStats", "write", "", "stats", "Lcom/android/tools/lint/LintStats;", "issues", "", "Lcom/android/tools/lint/detector/api/Incident;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "appendPath", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "path", "", "convertPath", "explainIssue", "output", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "setWriteStats", "lint-cli"})
public final class TextReporter
extends Reporter {
    @NotNull
    private final LintCliFlags flags;
    @NotNull
    private final Writer writer;
    private final boolean close;
    @NotNull
    private TextFormat format;
    private boolean isForwardSlashPaths;
    private boolean includeSecondaryLineContent;
    private boolean writeStats;

    public TextReporter(@NotNull LintCliClient client, @NotNull LintCliFlags flags, @Nullable File file, @NotNull Writer writer, boolean close) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(client, file);
        this.flags = flags;
        this.writer = writer;
        this.close = close;
        this.format = TextFormat.TEXT;
        this.writeStats = true;
    }

    @NotNull
    public final TextFormat getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull TextFormat textFormat) {
        Intrinsics.checkNotNullParameter((Object)textFormat, (String)"<set-?>");
        this.format = textFormat;
    }

    public final boolean isForwardSlashPaths() {
        return this.isForwardSlashPaths;
    }

    public final void setForwardSlashPaths(boolean bl) {
        this.isForwardSlashPaths = bl;
    }

    public final boolean getIncludeSecondaryLineContent() {
        return this.includeSecondaryLineContent;
    }

    public final void setIncludeSecondaryLineContent(boolean bl) {
        this.includeSecondaryLineContent = bl;
    }

    public TextReporter(@NotNull LintCliClient client, @NotNull LintCliFlags flags, @NotNull Writer writer, boolean close) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this(client, flags, null, writer, close);
    }

    @Override
    public void write(@NotNull LintStats stats, @NotNull List<Incident> issues, @NotNull IssueRegistry registry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        boolean abbreviate = !this.flags.isShowEverything();
        StringBuilder output = new StringBuilder(issues.size() * 200);
        if (issues.isEmpty()) {
            if (this.isDisplayEmpty() && this.writeStats) {
                this.writer.write("No issues found");
                if (stats.getBaselineErrorCount() > 0 || stats.getBaselineWarningCount() > 0) {
                    File file = this.flags.getBaselineFile();
                    Intrinsics.checkNotNull((Object)file);
                    File baselineFile = file;
                    String counts = Lint.describeCounts((int)stats.getBaselineErrorCount(), (int)stats.getBaselineWarningCount(), (boolean)true, (boolean)true);
                    this.writer.write(" (" + counts + " filtered by baseline " + baselineFile.getName() + ")");
                }
                this.writer.write(46);
                this.writer.write(10);
                this.writer.flush();
            }
        } else {
            Issue lastIssue = null;
            for (Incident incident : issues) {
                List list2;
                ApplicableVariants applicableVariants;
                Vendor from;
                Object object;
                Severity severity;
                Issue issue = incident.getIssue();
                if (issue != lastIssue) {
                    this.explainIssue(output, lastIssue);
                    lastIssue = issue;
                }
                int startLength = output.length();
                String displayPath = ReporterKt.getPath$default(incident, this.client, null, 2, null);
                this.appendPath(output, displayPath);
                output.append(':');
                if (incident.getLine() >= 0) {
                    output.append(String.valueOf(incident.getLine() + 1));
                    output.append(':');
                }
                if (startLength < output.length()) {
                    output.append(' ');
                }
                if ((severity = incident.getSeverity()) == Severity.FATAL) {
                    severity = Severity.ERROR;
                }
                output.append(severity.getDescription());
                output.append(':');
                output.append(' ');
                output.append(TextFormat.RAW.convertTo(incident.getMessage(), this.format));
                output.append(' ').append('[');
                output.append(issue.getId());
                Object object2 = issue.getVendor();
                if (object2 == null) {
                    IssueRegistry issueRegistry = issue.getRegistry();
                    object2 = issueRegistry != null ? issueRegistry.getVendor() : null;
                }
                if ((object = (from = object2)) != null && (object = object.getIdentifier()) != null) {
                    Object identifier = object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)from, (Object)IssueRegistry.Companion.getAOSP_VENDOR()) && !StringsKt.isBlank((CharSequence)((CharSequence)identifier))) {
                        output.append(" from ");
                        output.append(TextFormat.RAW.convertTo((String)identifier, this.format));
                    }
                }
                output.append(']');
                output.append('\n');
                if (incident.getWasAutoFixed()) {
                    output.append("This issue has been automatically fixed.\n");
                }
                if (this.flags.isShowSourceLines()) {
                    if (ReporterKt.getErrorLines(incident, (Function1<? super File, ? extends CharSequence>)((Function1)new Function1<File, CharSequence>(this){
                        final /* synthetic */ TextReporter this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final CharSequence invoke(File it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.this$0.client.getSourceText(it);
                        }
                    })) != null) {
                        String it;
                        boolean bl = false;
                        if (((CharSequence)it).length() > 0) {
                            output.append(it);
                        }
                    }
                }
                if (incident.getLocation().getSecondary() != null) {
                    Location location;
                    boolean omitted = false;
                    for (location = incident.getLocation().getSecondary(); location != null; location = location.getSecondary()) {
                        String it;
                        String locationMessage = location.getMessage();
                        if (locationMessage != null && ((CharSequence)locationMessage).length() > 0) {
                            int line2;
                            output.append("    ");
                            String path = ReporterKt.getPath(incident, this.client, location.getFile());
                            this.appendPath(output, path);
                            Position start = location.getStart();
                            if (start != null && (line2 = start.getLine()) >= 0) {
                                output.append(':');
                                output.append(String.valueOf(line2 + 1));
                            }
                            output.append(':');
                            output.append(' ');
                            output.append(TextFormat.RAW.convertTo(locationMessage, this.format));
                            output.append('\n');
                        } else {
                            omitted = true;
                        }
                        if (!this.flags.isShowSourceLines() || !this.includeSecondaryLineContent) continue;
                        if (ReporterKt.getErrorLines(location, (Function1<? super File, ? extends CharSequence>)((Function1)new Function1<File, CharSequence>(this){
                            final /* synthetic */ TextReporter this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final CharSequence invoke(File it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return this.this$0.client.getSourceText(it);
                            }
                        })) == null) continue;
                        boolean bl = false;
                        if (!(((CharSequence)it).length() > 0)) continue;
                        output.append(it);
                    }
                    if (!abbreviate && omitted) {
                        StringBuilder sb = new StringBuilder(100);
                        sb.append("Also affects: ");
                        int begin = sb.length();
                        for (location = incident.getLocation().getSecondary(); location != null; location = location.getSecondary()) {
                            int line3;
                            String locationMessage = location.getMessage();
                            if (locationMessage != null && !(((CharSequence)locationMessage).length() == 0)) continue;
                            if (sb.length() > begin) {
                                sb.append(", ");
                            }
                            String path = ReporterKt.getPath(incident, this.client, location.getFile());
                            this.appendPath(sb, path);
                            Position start = location.getStart();
                            if (start == null || (line3 = start.getLine()) < 0) continue;
                            sb.append(':');
                            sb.append(String.valueOf(line3 + 1));
                        }
                        String wrapped = Main.wrap(sb.toString(), 78, "     ");
                        output.append(wrapped);
                    }
                }
                if ((applicableVariants = incident.getApplicableVariants()) == null || !applicableVariants.getVariantSpecific()) continue;
                if (applicableVariants.includesMoreThanExcludes()) {
                    output.append("Applies to variants: ");
                    list2 = applicableVariants.getIncludedVariantNames();
                } else {
                    output.append("Does not apply to variants: ");
                    list2 = applicableVariants.getExcludedVariantNames();
                }
                List names = list2;
                output.append(Joiner.on((String)", ").join((Iterable)names));
                output.append('\n');
            }
            this.explainIssue(output, lastIssue);
            this.writer.write(output.toString());
            if (this.writeStats) {
                this.writer.write(stats.getErrorCount() + " errors, " + stats.getWarningCount() + " warnings");
                if (stats.getBaselineErrorCount() > 0 || stats.getBaselineWarningCount() > 0) {
                    File file = this.flags.getBaselineFile();
                    Intrinsics.checkNotNull((Object)file);
                    File baselineFile = file;
                    String counts = Lint.describeCounts((int)stats.getBaselineErrorCount(), (int)stats.getBaselineWarningCount(), (boolean)true, (boolean)true);
                    this.writer.write(" (" + counts + " filtered by baseline " + baselineFile.getName() + ")");
                }
            }
            this.writer.write(10);
            this.writer.flush();
        }
        if (this.close) {
            this.writer.close();
            if (!this.client.getFlags().isQuiet() && this.getOutput() != null) {
                String string = this.getOutput().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                String path = this.convertPath(string);
                System.out.println((Object)("Wrote text report to " + path));
            }
        }
    }

    private final void appendPath(StringBuilder sb, String path) {
        sb.append(this.convertPath(path));
    }

    private final String convertPath(String path) {
        return this.isForwardSlashPaths ? (File.separatorChar == '/' ? path : StringsKt.replace$default((String)path, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null)) : path;
    }

    private final void explainIssue(StringBuilder output, Issue issue) {
        block10: {
            Vendor issueVendor;
            Object object;
            List options;
            if (issue == null || !this.flags.isExplainIssues() || issue == IssueRegistry.LINT_ERROR || issue == IssueRegistry.LINT_WARNING || issue == IssueRegistry.BASELINE_USED) {
                return;
            }
            String explanation = issue.getExplanation(this.format);
            if (StringsKt.isBlank((CharSequence)explanation)) {
                return;
            }
            String indent = "   ";
            String formatted = SdkUtils.wrap((String)explanation, (int)(78 - indent.length()), null);
            output.append('\n');
            output.append(indent);
            output.append("Explanation for issues of type \"").append(issue.getId()).append("\":\n");
            for (Object line2 : Splitter.on((char)'\n').split((CharSequence)formatted)) {
                Intrinsics.checkNotNull((Object)line2);
                if (((CharSequence)line2).length() > 0) {
                    output.append(indent);
                    output.append((String)line2);
                }
                output.append('\n');
            }
            List moreInfo = issue.getMoreInfo();
            if (!((Collection)moreInfo).isEmpty()) {
                for (Object url : moreInfo) {
                    Intrinsics.checkNotNull((Object)formatted);
                    if (StringsKt.contains$default((CharSequence)formatted, (CharSequence)((CharSequence)url), (boolean)false, (int)2, null)) continue;
                    output.append(indent);
                    output.append((String)url);
                    output.append('\n');
                }
                output.append('\n');
            }
            if (!((Collection)(options = issue.getOptions())).isEmpty()) {
                for (String line3 : StringsKt.lines((CharSequence)Option.Companion.describe$default((Option.Companion)Option.Companion, (List)options, null, (boolean)false, (int)6, null))) {
                    StringBuilder stringBuilder = StringsKt.isBlank((CharSequence)line3) ? output.append("\n") : output.append(indent).append(line3).append('\n');
                }
            }
            if ((object = issue.getVendor()) == null) {
                IssueRegistry issueRegistry = issue.getRegistry();
                object = issueRegistry != null ? issueRegistry.getVendor() : null;
            }
            Vendor vendor = issueVendor = object;
            if (vendor == null) break block10;
            Vendor vendor2 = vendor;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)vendor2, (Object)IssueRegistry.Companion.getAOSP_VENDOR())) {
                vendor2.describeInto(output, this.format, indent);
                output.append('\n');
            }
        }
    }

    public final void setWriteStats(boolean writeStats) {
        this.writeStats = writeStats;
    }
}

