/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001#B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/PreferenceActivityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "filterIncident", "", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "applicableSuperClasses", "", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "findManifestElement", "className", "overridesIsValidFragment", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "resolvedClass", "Lcom/intellij/psi/PsiClass;", "Companion", "lint-checks"})
public final class PreferenceActivityDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    @NotNull
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    @NotNull
    private static final String KEY_OVERRIDES = "overrides";
    @NotNull
    private static final String KEY_IMPLICIT = "implicit";

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"activity");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        boolean implicitlyExportedPreS;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Boolean explicitlyDecided = SecurityDetector.getExplicitExported(element);
        boolean bl = implicitlyExportedPreS = explicitlyDecided == null && SecurityDetector.isImplicitlyExportedPreS(element);
        if (implicitlyExportedPreS || Intrinsics.areEqual((Object)explicitlyDecided, (Object)true)) {
            Project project = context.getProject();
            String className = Lint.resolveManifestName((Element)element, (Project)project);
            if (Intrinsics.areEqual((Object)className, (Object)PREFERENCE_ACTIVITY)) {
                String message2 = "`PreferenceActivity` should not be exported";
                Incident incident = new Incident(ISSUE, (Object)element, context.getLocation((Node)element), message2);
                if (implicitlyExportedPreS) {
                    context.report(incident, Constraints.targetSdkLessThan((int)31));
                } else {
                    context.report(incident);
                }
            } else {
                UastParser parser = context.getClient().getUastParser(project);
                JavaEvaluator evaluator = parser.getEvaluator();
                PsiClass declaration = evaluator.findClass(StringsKt.replace$default((String)className, (char)'$', (char)'.', (boolean)false, (int)4, null));
                if (declaration != null && evaluator.extendsClass(declaration, PREFERENCE_ACTIVITY, true)) {
                    boolean overrides = this.overridesIsValidFragment(evaluator, declaration);
                    String message3 = "`PreferenceActivity` subclass " + className + " should not be exported";
                    Location location = context.getLocation((Node)element);
                    if (context.getDriver().isIsolated()) {
                        location.setSecondary(Context.getLocation$default((Context)((Context)context), (Object)declaration, null, (int)2, null));
                    }
                    Incident incident = new Incident(ISSUE, (Object)element, location, message3);
                    context.report(incident, this.map().put(KEY_OVERRIDES, overrides).put(KEY_IMPLICIT, implicitlyExportedPreS));
                }
            }
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().getTargetSdk() < 19) {
            return true;
        }
        if (Intrinsics.areEqual((Object)map.getBoolean(KEY_IMPLICIT, Boolean.valueOf(false)), (Object)true) && context.getMainProject().getTargetSdk() >= 31) {
            return true;
        }
        return Intrinsics.areEqual((Object)map.getBoolean(KEY_OVERRIDES, Boolean.valueOf(false)), (Object)false);
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)PREFERENCE_ACTIVITY);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        boolean implicitlyExportedPreS;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!context.getProject().getReportIssues() || !context.getDriver().isIsolated()) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.extendsClass((PsiClass)declaration, PREFERENCE_ACTIVITY, false)) {
            return;
        }
        String string = declaration.getQualifiedName();
        if (string == null) {
            return;
        }
        String className = string;
        Element element = this.findManifestElement(context, className);
        if (element == null) {
            return;
        }
        Element element2 = element;
        Boolean explicitlyDecided = SecurityDetector.getExplicitExported(element2);
        boolean bl = implicitlyExportedPreS = explicitlyDecided == null && SecurityDetector.isImplicitlyExportedPreS(element2);
        if (implicitlyExportedPreS || Intrinsics.areEqual((Object)explicitlyDecided, (Object)true)) {
            boolean overrides = this.overridesIsValidFragment(evaluator, (PsiClass)declaration);
            String message2 = "`PreferenceActivity` subclass " + className + " should not be exported in the manifest";
            Location location = context.getNameLocation(declaration);
            Incident incident = new Incident(ISSUE, (Object)declaration, location, message2);
            context.report(incident, this.map().put(KEY_OVERRIDES, overrides).put(KEY_IMPLICIT, implicitlyExportedPreS));
        }
    }

    private final Element findManifestElement(JavaContext context, String className) {
        Project project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        Document document = project.getMergedManifest();
        if (document == null) {
            return null;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return null;
        }
        Element manifest = element;
        Element element2 = DomExtensions.subtag((Element)manifest, (String)"application");
        if (element2 == null) {
            return null;
        }
        Element application = element2;
        Iterator iterator = DomExtensions.subtags((Element)application, (String)"activity");
        while (iterator.hasNext()) {
            String fqn;
            Element element3 = (Element)iterator.next();
            String name = element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            Intrinsics.checkNotNull((Object)name);
            if (!StringsKt.endsWith$default((String)className, (String)name, (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)(fqn = Lint.resolveManifestName((Element)element3, (Project)project)), (Object)className)) continue;
            return element3;
        }
        return null;
    }

    private final boolean overridesIsValidFragment(JavaEvaluator evaluator, PsiClass resolvedClass) {
        for (PsiMethod method : resolvedClass.findMethodsByName(IS_VALID_FRAGMENT, false)) {
            Intrinsics.checkNotNull((Object)method);
            String[] stringArray = new String[]{"java.lang.String"};
            if (!evaluator.parametersMatch(method, stringArray)) continue;
            return true;
        }
        return false;
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(PreferenceActivityDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"ExportedPreferenceActivity", (String)"PreferenceActivity should not be exported", (String)"\n                Fragment injection gives anyone who can send your `PreferenceActivity` an intent \\\n                the ability to load any fragment, with any arguments, in your process.", (Implementation)implementation, (String)"http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection", (Category)category, (int)8, (Severity)severity, (boolean)false, null, null, null, (int)3840, null).addMoreInfo("https://goo.gle/ExportedPreferenceActivity");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/PreferenceActivityDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "PREFERENCE_ACTIVITY", "", "IS_VALID_FRAGMENT", "KEY_OVERRIDES", "KEY_IMPLICIT", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

