/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8wrappers;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.ArchiveProgramResourceProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8wrappers.D8Wrapper;
import com.android.tools.r8wrappers.R8Wrapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class D8PackageBasedWrapper
extends D8Wrapper {
    private Set<String> packageDexPath = new HashSet<String>();
    private Set<String> modPackageDexPath = new HashSet<String>();
    private String basePackageDirectory;
    private static final int MAX_PACKAGES_PER_SHARD = 20;
    private static final int MAX_CONCURRENT_D8_THREADS = 8;
    private static final String FILE_PATH_REGEX = "'([^']*)'|(\\S+)";

    private static List<String> extractAndRemoveArguments(String[] remainingArgs, String argument) {
        ArrayList<String> result = new ArrayList<String>();
        String nextValue = D8PackageBasedWrapper.extractAndMaybeRemoveArgument(remainingArgs, argument, true, false);
        while (nextValue != null) {
            result.add(nextValue);
            nextValue = D8PackageBasedWrapper.extractAndMaybeRemoveArgument(remainingArgs, argument, true, false);
        }
        return result;
    }

    private static String extractAndMaybeRemoveArgument(String[] remainingArgs, String argument, boolean remove, boolean throwIfNotFound) {
        String base = null;
        for (int i15 = 0; i15 < remainingArgs.length; ++i15) {
            if (!remainingArgs[i15].equals(argument)) continue;
            base = remainingArgs[i15 + 1];
            if (!remove) break;
            remainingArgs[i15] = "";
            remainingArgs[i15 + 1] = "";
            break;
        }
        if (base == null && throwIfNotFound) {
            throw new RuntimeException("Can't do sharded compilation without argument: " + argument);
        }
        return base;
    }

    @Override
    public void run(String[] remainingArgs) throws CompilationFailedException, ExecutionException, InterruptedException, IOException {
        String baseOutputDir = D8PackageBasedWrapper.extractAndMaybeRemoveArgument(remainingArgs, "--output", true, true);
        List<String> libraries = D8PackageBasedWrapper.extractAndRemoveArguments(remainingArgs, "--lib");
        int minApi = Integer.parseInt(D8PackageBasedWrapper.extractAndMaybeRemoveArgument(remainingArgs, "--min-api", false, true));
        int dexMergeShardCount = (int)Math.ceil((double)this.packageDexPath.size() / 20.0);
        ExecutorService executorService = Executors.newWorkStealingPool(8);
        HashSet<String> packagesRecompiled = new HashSet<String>(this.modPackageDexPath);
        this.compileIndividualPackages(remainingArgs, this.basePackageDirectory, executorService, packagesRecompiled, libraries);
        this.mergeChangedShards(baseOutputDir, this.basePackageDirectory, executorService, packagesRecompiled, dexMergeShardCount, minApi);
    }

    @Override
    public String[] parseWrapperArguments(String[] args) {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        block10: for (int i15 = 0; i15 < args.length; ++i15) {
            String arg;
            switch (arg = args[i15]) {
                case "--packages": {
                    if (++i15 >= args.length) {
                        throw new RuntimeException("Missing argument to --packages");
                    }
                    this.packageDexPath = this.readPackages(Path.of(args[i15], new String[0]));
                    continue block10;
                }
                case "--mod-packages": {
                    if (++i15 >= args.length) {
                        throw new RuntimeException("Missing argument to --mod-packages");
                    }
                    this.modPackageDexPath = this.readPackages(Path.of(args[i15], new String[0]));
                    continue block10;
                }
                case "--package-output": {
                    if (++i15 >= args.length) {
                        throw new RuntimeException("Missing argument to --package-output");
                    }
                    this.basePackageDirectory = args[i15];
                    continue block10;
                }
                default: {
                    remainingArgs.add(arg);
                }
            }
        }
        return super.parseWrapperArguments(remainingArgs.toArray(new String[0]));
    }

    private Set<String> readPackages(Path srcRspFile) {
        HashSet<String> packageDexPath = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(srcRspFile.toFile()));){
            String line;
            while ((line = reader.readLine()) != null) {
                ArrayList<String> files = new ArrayList<String>();
                Pattern pattern = Pattern.compile(FILE_PATH_REGEX);
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    if (matcher.group(1) != null) {
                        files.add(matcher.group(1));
                        continue;
                    }
                    files.add(matcher.group(2));
                }
                packageDexPath.addAll(files);
            }
        }
        catch (IOException e15) {
            throw new RuntimeException("Error reading rsp file at: " + srcRspFile, e15);
        }
        return packageDexPath;
    }

    private void compileIndividualPackages(String[] remainingArgs, String basePackageDirectory, ExecutorService executorService, Set<String> packagesRecompiled, List<String> libraries) throws ExecutionException, InterruptedException, IOException {
        Set<ProgramResource> programResources = this.getProgramResources(packagesRecompiled);
        SynchronizedClassFileProvider libraryProvider = new SynchronizedClassFileProvider(libraries.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
        SynchronizedClassFileProvider classpathProvider = new SynchronizedClassFileProvider(this.noDexArchives);
        ArrayList futures = new ArrayList();
        for (String pack : packagesRecompiled) {
            futures.add(executorService.submit(() -> {
                D8Command.Builder builder = D8Command.parse(remainingArgs, CLI_ORIGIN, this.diagnosticsHandler);
                this.applyWrapperArguments(builder, pack, programResources, basePackageDirectory, libraryProvider, classpathProvider);
                R8Wrapper.applyCommonCompilerArguments(builder);
                try {
                    D8Command command = (D8Command)builder.build();
                    D8.run(command);
                }
                catch (CompilationFailedException e15) {
                    throw new RuntimeException(e15);
                }
            }));
        }
        D8PackageBasedWrapper.awaitFutures(futures);
    }

    private void applyWrapperArguments(D8Command.Builder builder, String currentPackage, Collection<ProgramResource> programResources, String basePackageDirectory, ClassFileResourceProvider libraryProvider, SynchronizedClassFileProvider classpathProvider) {
        this.diagnosticsHandler.setWarnOnUnsupportedMainDexList(true);
        this.diagnosticsHandler.setPrintInfoDiagnostics(this.printInfoDiagnostics);
        String packageOutputDir = basePackageDirectory + "/" + currentPackage;
        D8PackageBasedWrapper.flushDirFiles(packageOutputDir);
        builder.setOutput(Paths.get(packageOutputDir, new String[0]), OutputMode.DexIndexed);
        builder.addProgramResourceProvider(() -> {
            Predicate<ProgramResource> programResourcePredicate = r15 -> {
                String str = (String)r15.getClassDescriptors().stream().findFirst().get();
                int lastIdx = str.lastIndexOf(47);
                String classPackage = lastIdx == -1 ? "." : str.substring(1, lastIdx);
                return currentPackage.equals(classPackage);
            };
            return programResources.stream().filter(programResourcePredicate).collect(Collectors.toSet());
        });
        builder.addLibraryResourceProvider(libraryProvider);
        builder.addClasspathResourceProvider(classpathProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ProgramResource> getProgramResources(Set<String> packagesRecompiled) {
        Predicate<String> shouldReadEntry = className -> {
            if (!ArchiveProgramResourceProvider.includeClassFileEntries(className)) {
                return false;
            }
            int lastIdx = className.lastIndexOf(47);
            String classPackage = lastIdx == -1 ? "." : className.substring(0, lastIdx);
            return packagesRecompiled.contains(classPackage);
        };
        HashSet<ProgramResource> programResources = new HashSet<ProgramResource>();
        for (Path noDexArchive : this.noDexArchives) {
            try {
                ArchiveProgramResourceProvider archiveProgramResourceProvider = ArchiveProgramResourceProvider.fromArchive(noDexArchive, shouldReadEntry);
                try {
                    programResources.addAll(archiveProgramResourceProvider.getProgramResources());
                }
                finally {
                    archiveProgramResourceProvider.finished(this.diagnosticsHandler);
                }
            }
            catch (ResourceException | IOException e15) {
                throw new RuntimeException(e15);
            }
        }
        return programResources;
    }

    private void mergeChangedShards(String baseOutputDir, String basePackageDirectory, ExecutorService executorService, Set<String> packagesRecompiled, int dexMergeShardCount, int minApi) throws ExecutionException, InterruptedException {
        Map<Integer, Set<String>> mapping = D8PackageBasedWrapper.getInitialMapping(packagesRecompiled, dexMergeShardCount);
        D8PackageBasedWrapper.fillExistingPackagesIfNeeded(mapping, this.packageDexPath, dexMergeShardCount);
        ArrayList mergeFutures = new ArrayList();
        for (Map.Entry<Integer, Set<String>> entry : mapping.entrySet()) {
            D8Command.Builder builder = D8Command.builder();
            String shardOutput = baseOutputDir + "/shard" + entry.getKey();
            D8PackageBasedWrapper.createDir(shardOutput);
            D8PackageBasedWrapper.flushDirFiles(shardOutput);
            builder.setOutput(Paths.get(shardOutput, new String[0]), OutputMode.DexIndexed);
            builder.setDisableDesugaring(true);
            builder.setMinApiLevel(minApi);
            entry.getValue().forEach(pack -> {
                try {
                    builder.addProgramFiles(D8PackageBasedWrapper.getDexFilesInDirectory(basePackageDirectory + "/" + pack));
                }
                catch (IOException e15) {
                    throw new RuntimeException(e15);
                }
            });
            mergeFutures.add(executorService.submit(() -> {
                try {
                    D8.run((D8Command)builder.build());
                }
                catch (CompilationFailedException e15) {
                    throw new RuntimeException(e15);
                }
            }));
        }
        D8PackageBasedWrapper.awaitFutures(mergeFutures);
        D8PackageBasedWrapper.copyAndRenameDexFiles(dexMergeShardCount, baseOutputDir);
    }

    public static List<Path> getDexFilesInDirectory(String path) throws IOException {
        Path dir = Paths.get(path, new String[0]);
        try (Stream<Path> stream = Files.list(dir);){
            List<Path> list = stream.filter(p15 -> p15.toString().toLowerCase().endsWith(".dex")).collect(Collectors.toList());
            return list;
        }
    }

    private static void awaitFutures(List<Future<?>> futures) throws ExecutionException, InterruptedException {
        for (Future<?> future : futures) {
            future.get();
        }
    }

    private static void copyAndRenameDexFiles(int dexMergeShardCount, String baseOutputDir) {
        int dexCounter = 0;
        Path outputDirPath = Paths.get(baseOutputDir, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(outputDirPath, "classes*.dex");){
            for (Path entry : stream) {
                Files.delete(entry);
            }
        }
        catch (IOException e15) {
            throw new RuntimeException(e15);
        }
        for (int i15 = 0; i15 < dexMergeShardCount; ++i15) {
            String sourcePathStr = baseOutputDir + "/shard" + i15;
            Path sourcePath = Paths.get(sourcePathStr, new String[0]);
            ArrayList<String> dexEntriesToProcess = new ArrayList<String>();
            if (!Files.isDirectory(sourcePath, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(sourcePath, "classes*.dex");){
                for (Path entry : stream) {
                    dexEntriesToProcess.add(entry.getFileName().toString());
                }
            }
            catch (IOException e16) {
                throw new RuntimeException(e16);
            }
            Collections.sort(dexEntriesToProcess);
            for (String dexFileName : dexEntriesToProcess) {
                Path sourceDexFile = sourcePath.resolve(dexFileName);
                String destFileName = dexCounter == 0 ? "classes.dex" : "classes" + (dexCounter + 1) + ".dex";
                Path destDexFile = outputDirPath.resolve(destFileName);
                try {
                    Files.copy(sourceDexFile, destDexFile, StandardCopyOption.REPLACE_EXISTING);
                    ++dexCounter;
                }
                catch (IOException e17) {
                    throw new RuntimeException(e17);
                }
            }
        }
    }

    private static Map<Integer, Set<String>> getInitialMapping(Set<String> packs, int count) {
        HashMap<Integer, Set<String>> initialMapping = new HashMap<Integer, Set<String>>();
        for (String pack : packs) {
            int bucket = D8PackageBasedWrapper.getBucket(count, pack);
            initialMapping.computeIfAbsent(bucket, ignored -> new HashSet()).add(pack);
        }
        return initialMapping;
    }

    private static int getBucket(int count, String pack) {
        int i15 = pack.hashCode() % count;
        return i15 < 0 ? -i15 : i15;
    }

    private static void fillExistingPackagesIfNeeded(Map<Integer, Set<String>> mapping, Set<String> packs, int count) {
        for (String pack : packs) {
            int bucket = D8PackageBasedWrapper.getBucket(count, pack);
            Set<String> packSet = mapping.get(bucket);
            if (packSet == null) continue;
            packSet.add(pack);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void flushDirFiles(String flushDir) {
        Path dir = Paths.get(flushDir, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path entry : stream) {
                try {
                    if (!Files.isRegularFile(entry, new LinkOption[0])) continue;
                    Files.delete(entry);
                }
                catch (IOException | SecurityException e15) {
                    throw new RuntimeException("Failed to delete: " + entry.getFileName() + " - " + e15.getMessage(), e15);
                    return;
                }
            }
        }
        catch (IOException | SecurityException e16) {
            throw new RuntimeException("Error reading directory: " + dir + " - " + e16.getMessage(), e16);
        }
    }

    private static void createDir(String newDir) {
        Path dirPath = Paths.get(newDir, new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            String dirPerms = "rwxr-xr-x";
            try {
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString(dirPerms);
                Files.createDirectories(dirPath, PosixFilePermissions.asFileAttribute(perms));
            }
            catch (IOException | UnsupportedOperationException e15) {
                throw new RuntimeException("Error recreating directory " + dirPath + ": " + e15.getMessage(), e15);
            }
        }
    }

    public static class SynchronizedClassFileProvider
    implements ClassFileResourceProvider {
        private Set<String> availableDescriptors = new HashSet<String>();
        private Map<String, ProgramResource> cachedResources = new ConcurrentHashMap<String, ProgramResource>();
        private List<ClassFileResourceProvider> providers = new ArrayList<ClassFileResourceProvider>();

        public SynchronizedClassFileProvider(List<Path> paths) throws IOException {
            for (Path path : paths) {
                ArchiveClassFileProvider classFileProvider = new ArchiveClassFileProvider(path);
                this.availableDescriptors.addAll(classFileProvider.getClassDescriptors());
                this.providers.add(classFileProvider);
            }
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.availableDescriptors;
        }

        @Override
        public ProgramResource getProgramResource(String descriptor) {
            return this.cachedResources.computeIfAbsent(descriptor, newDescriptor -> {
                if (!this.availableDescriptors.contains(newDescriptor)) {
                    return null;
                }
                for (ClassFileResourceProvider provider : this.providers) {
                    ProgramResource programResource = provider.getProgramResource((String)newDescriptor);
                    if (programResource == null) continue;
                    return programResource;
                }
                return null;
            });
        }
    }
}

