/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeRef;
import org.conscrypt.OpenSSLBaseDHKeyAgreement;
import org.conscrypt.OpenSSLKey;

public final class OpenSSLECDHKeyAgreement
extends OpenSSLBaseDHKeyAgreement<OpenSSLKey> {
    @Override
    protected OpenSSLKey convertPublicKey(PublicKey key) throws InvalidKeyException {
        return OpenSSLKey.fromPublicKey(key);
    }

    @Override
    protected OpenSSLKey convertPrivateKey(PrivateKey key) throws InvalidKeyException {
        return OpenSSLKey.fromPrivateKey(key);
    }

    @Override
    protected int computeKey(byte[] buffer, OpenSSLKey theirPublicKey, OpenSSLKey ourPrivateKey) throws InvalidKeyException {
        return NativeCrypto.ECDH_compute_key(buffer, 0, theirPublicKey.getNativeRef(), ourPrivateKey.getNativeRef());
    }

    @Override
    protected int getOutputSize(OpenSSLKey openSslKey) {
        int fieldSizeBits = NativeCrypto.EC_GROUP_get_degree(new NativeRef.EC_GROUP(NativeCrypto.EC_KEY_get1_group(openSslKey.getNativeRef())));
        return (fieldSizeBits + 7) / 8;
    }
}

