/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.jack.google.common.io.ByteStreams;
import com.android.sched.util.config.MessageDigestFactory;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.vfs.BadVFSFormatException;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WrongFileFormatException;
import com.android.sched.vfs.WrongVFSTypeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.attribute.FileTime;
import java.security.DigestOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class MessageDigestFS
extends BaseVFS<MessageDigestVDir, MessageDigestVFile>
implements VFS {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private static final String DIGEST_FILE_NAME = "digest";
    @Nonnull
    private final BaseVFS<BaseVDir, BaseVFile> vfs;
    @Nonnull
    private final MessageDigestFactory mdFactory;
    @Nonnull
    private final Map<VPath, String> digests = new HashMap<VPath, String>();
    @CheckForNull
    private String digest = null;
    @Nonnull
    private final Set<Capabilities> capabilities;
    @Nonnull
    public MessageDigestVDir rootDir;
    @Nonnull
    private static final byte[] code = "0123456789ABCDEF".getBytes();

    public MessageDigestFS(@Nonnull VFS vfs, @Nonnull MessageDigestFactory factory) throws BadVFSFormatException, WrongVFSTypeException {
        this.vfs = (BaseVFS)vfs;
        this.mdFactory = factory;
        EnumSet<Capabilities> capabilities = EnumSet.copyOf(vfs.getCapabilities());
        capabilities.add(Capabilities.DIGEST);
        this.capabilities = Collections.unmodifiableSet(capabilities);
        this.rootDir = new MessageDigestVDir(this, (BaseVDir)this.vfs.getRootDir());
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws BadVFSFormatException, WrongVFSTypeException {
        BaseVFile digestFile;
        try {
            digestFile = ((BaseVDir)this.vfs.getRootDir()).getVFile(DIGEST_FILE_NAME);
        }
        catch (NotFileException e) {
            throw new BadVFSFormatException(this, this.vfs.getLocation(), e);
        }
        catch (NoSuchFileException e) {
            if (!((BaseVDir)this.vfs.getRootDir()).isEmpty()) {
                throw new WrongVFSTypeException(this.vfs, this.vfs.getLocation(), this.getDescription(), e);
            }
            return;
        }
        BufferedReader in = null;
        try {
            try {
                in = new LineNumberReader(new InputStreamReader(digestFile.getInputStream()));
            }
            catch (WrongPermissionException e) {
                throw new BadVFSFormatException(this, this.vfs.getLocation(), e);
            }
            try {
                String line;
                while ((line = ((LineNumberReader)in).readLine()) != null) {
                    int index = line.indexOf(58);
                    if (index < 1) {
                        throw new BadVFSFormatException(this, this.vfs.getLocation(), new WrongFileFormatException(new ColumnAndLineLocation(digestFile.getLocation(), ((LineNumberReader)in).getLineNumber())));
                    }
                    String path = line.substring(index + 1);
                    String digest = line.substring(0, index);
                    if (!path.equals(DIGEST_FILE_NAME)) {
                        this.digests.put(new VPath(path, '/'), digest);
                        continue;
                    }
                    this.digest = digest;
                }
            }
            catch (IOException e) {
                throw new BadVFSFormatException(this, this.vfs.getLocation(), new CannotReadException(digestFile));
            }
        }
        finally {
            if (in != null) {
                assert (digestFile != null);
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Cannot close {0}", digestFile.getLocation().getDescription());
                }
            }
        }
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.capabilities;
    }

    @Nonnull
    private String getDigestString(@Nonnull byte[] digestBytes) {
        return this.mdFactory.getService().getAlgorithm() + '-' + String.valueOf(MessageDigestFS.encode(digestBytes));
    }

    @Nonnull
    private static char[] encode(@Nonnull byte[] bytes) {
        char[] array = new char[bytes.length * 2];
        for (int idx = 0; idx < bytes.length; ++idx) {
            array[idx << 1] = (char)code[(bytes[idx] & 0xF0) >> 4];
            array[(idx << 1) + 1] = (char)code[bytes[idx] & 0xF];
        }
        return array;
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.vfs.getLocation();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Override
    @Nonnull
    public synchronized String getDigest() {
        if (this.digest == null) {
            this.printDigest(ByteStreams.nullOutputStream());
            assert (this.digest != null);
        }
        return this.digest;
    }

    @Override
    @Nonnull
    FileTime getLastModified(@Nonnull MessageDigestVFile file) throws CannotGetModificationTimeException {
        return this.vfs.getLastModified(file.getWrappedFile());
    }

    @Override
    public synchronized void close() throws CannotCloseException {
        if (!this.closed) {
            if (this.vfs.getCapabilities().contains((Object)Capabilities.WRITE)) {
                try {
                    this.printDigest(((BaseVDir)this.vfs.getRootDir()).createVFile(DIGEST_FILE_NAME).getOutputStream());
                }
                catch (CannotCreateFileException | WrongPermissionException e) {
                    throw new CannotCloseException((HasLocation)this, (Exception)e);
                }
            }
            this.vfs.close();
            this.closed = true;
        }
    }

    @SuppressFBWarnings(value={"DMI_ENTRY_SETS_MAY_REUSE_ENTRY_OBJECTS"})
    private void printDigest(@Nonnull OutputStream out) {
        DigestOutputStream os = new DigestOutputStream(out, this.mdFactory.create());
        PrintStream printer = new PrintStream(os);
        Set<Map.Entry<VPath, String>> entrySet = this.digests.entrySet();
        ArrayList<Map.Entry<VPath, String>> entryList = new ArrayList<Map.Entry<VPath, String>>(entrySet.size());
        entryList.addAll(entrySet);
        Collections.sort(entryList, new Comparator<Map.Entry<VPath, String>>(){

            @Override
            public int compare(Map.Entry<VPath, String> o1, Map.Entry<VPath, String> o2) {
                return o1.getKey().getPathAsString('/').compareTo(o2.getKey().getPathAsString('/'));
            }
        });
        for (Map.Entry entry : entryList) {
            String digest = (String)entry.getValue();
            if (digest == null) continue;
            printer.print(digest);
            printer.print(':');
            printer.print(((VPath)entry.getKey()).getPathAsString('/'));
            printer.println();
        }
        printer.flush();
        this.digest = this.getDigestString(os.getMessageDigest().digest());
        printer.print(this.digest);
        printer.print(":digest");
        printer.println();
        printer.close();
    }

    @Override
    @Nonnull
    public MessageDigestVDir getRootDir() {
        return this.rootDir;
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull MessageDigestVFile file) throws WrongPermissionException {
        return this.vfs.openRead(file.getWrappedFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    OutputStream openWrite(final @Nonnull MessageDigestVFile file) throws WrongPermissionException {
        MessageDigestFS messageDigestFS = this;
        synchronized (messageDigestFS) {
            this.digests.remove(file.getPath());
            this.digest = null;
        }
        return new DigestOutputStream(this.vfs.openWrite(file.getWrappedFile()), this.mdFactory.create()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                super.close();
                MessageDigestFS messageDigestFS = MessageDigestFS.this;
                synchronized (messageDigestFS) {
                    MessageDigestFS.this.digests.put(file.getPath(), MessageDigestFS.this.getDigestString(this.getMessageDigest().digest()));
                    this.digest = null;
                }
            }
        };
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull MessageDigestVFile file, boolean append) throws WrongPermissionException {
        if (append) {
            throw new UnsupportedOperationException();
        }
        return this.openWrite(file);
    }

    @Override
    @Nonnull
    synchronized void delete(@Nonnull MessageDigestVFile file) throws CannotDeleteFileException {
        file.getWrappedFile().delete();
        this.digests.remove(file.getPath());
        this.digest = null;
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull MessageDigestVDir dir) {
        Collection<? extends BaseVElement> elements = dir.getWrappedDir().list();
        ArrayList<MessageDigestVDir> newElements = new ArrayList<MessageDigestVDir>(elements.size());
        for (BaseVElement baseVElement : elements) {
            if (dir == this.rootDir && baseVElement.getName().equals(DIGEST_FILE_NAME)) continue;
            BaseVElement newElement = baseVElement.isVDir() ? new MessageDigestVDir(this, (BaseVDir)baseVElement) : new MessageDigestVFile(this, (BaseVFile)baseVElement);
            newElements.add((MessageDigestVDir)newElement);
        }
        return newElements;
    }

    @Override
    boolean isEmpty(@Nonnull MessageDigestVDir dir) {
        return this.vfs.isEmpty(dir.getWrappedDir());
    }

    @Override
    @Nonnull
    MessageDigestVFile createVFile(@Nonnull MessageDigestVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return new MessageDigestVFile(this, parent.getWrappedDir().createVFile(name));
    }

    @Override
    @Nonnull
    MessageDigestVDir createVDir(@Nonnull MessageDigestVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return new MessageDigestVDir(this, parent.getWrappedDir().createVDir(name));
    }

    @Override
    @Nonnull
    MessageDigestVDir getVDir(@Nonnull MessageDigestVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        return new MessageDigestVDir(this, parent.getWrappedDir().getVDir(name));
    }

    @Override
    @Nonnull
    MessageDigestVFile getVFile(@Nonnull MessageDigestVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        return new MessageDigestVFile(this, parent.getWrappedDir().getVFile(name));
    }

    @Override
    public boolean needsSequentialWriting() {
        return this.vfs.needsSequentialWriting();
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "message digest wrapper";
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull MessageDigestVFile file) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull MessageDigestVDir parent, @Nonnull String name) {
        return this.vfs.getVFileLocation(parent.getWrappedDir(), name);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull MessageDigestVDir parent, @Nonnull VPath path) {
        return this.vfs.getVFileLocation(parent.getWrappedDir(), path);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull MessageDigestVDir dir) {
        return this.vfs.getVDirLocation(dir.getWrappedDir());
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull MessageDigestVDir parent, @Nonnull String name) {
        return this.vfs.getVDirLocation(parent.getWrappedDir(), name);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull MessageDigestVDir parent, @Nonnull VPath path) {
        return this.vfs.getVDirLocation(parent.getWrappedDir(), path);
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull MessageDigestVDir parent, @Nonnull MessageDigestVFile file) {
        return this.vfs.getPathFromDir(parent.getWrappedDir(), file.getWrappedFile());
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull MessageDigestVFile file) {
        return this.vfs.getPathFromRoot(file.getWrappedFile());
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.vfs.getInfoString();
    }

    public String toString() {
        return "digestFS >> " + this.vfs.toString();
    }

    static class MessageDigestVDir
    extends BaseVDir {
        @Nonnull
        private final BaseVDir wrappedFile;

        public MessageDigestVDir(@Nonnull BaseVFS<MessageDigestVDir, MessageDigestVFile> vfs, @Nonnull BaseVDir wrappedFile) {
            super(vfs, wrappedFile.getName());
            this.wrappedFile = wrappedFile;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.wrappedFile.getLocation();
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return this.wrappedFile.getPath();
        }

        @Nonnull
        public BaseVDir getWrappedDir() {
            return this.wrappedFile;
        }
    }

    class MessageDigestVFile
    extends BaseVFile {
        @Nonnull
        private final BaseVFile wrappedFile;

        public MessageDigestVFile(@Nonnull BaseVFS<MessageDigestVDir, MessageDigestVFile> vfs, BaseVFile wrappedFile) {
            super(vfs, wrappedFile.getName());
            this.wrappedFile = wrappedFile;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.wrappedFile.getLocation();
        }

        @Override
        @Nonnull
        public VPath getPath() {
            return this.wrappedFile.getPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CheckForNull
        public String getDigest() {
            MessageDigestFS messageDigestFS = MessageDigestFS.this;
            synchronized (messageDigestFS) {
                return (String)MessageDigestFS.this.digests.get(this.getPath());
            }
        }

        @Nonnull
        public BaseVFile getWrappedFile() {
            return this.wrappedFile;
        }

        @Override
        @Nonnull
        public InputStream getInputStream() throws WrongPermissionException {
            return this.vfs.openRead(this);
        }

        @Override
        @Nonnull
        public OutputStream getOutputStream() throws WrongPermissionException {
            return this.vfs.openWrite(this);
        }

        @Override
        @Nonnull
        public OutputStream getOutputStream(boolean append) throws WrongPermissionException {
            if (append) {
                throw new UnsupportedOperationException();
            }
            return this.getOutputStream();
        }
    }
}

