/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.sched.util.codec.EnumCodec;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import javax.annotation.Nonnull;

public class EnumPropertyId<T extends Enum<T>>
extends PropertyId<T> {
    @Nonnull
    public static <T extends Enum<T>> EnumPropertyId<T> create(@Nonnull String name, @Nonnull String description, @Nonnull Class<T> type) {
        return new EnumPropertyId<T>(name, description, new EnumCodec<T>(type));
    }

    protected EnumPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull EnumCodec<T> parser) {
        super(name, description, parser);
    }

    @Override
    @Nonnull
    public EnumPropertyId<T> addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public EnumPropertyId<T> addDefaultValue(@Nonnull T defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public EnumPropertyId<T> requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Override
    @Nonnull
    public EnumCodec<T> getCodec() {
        return (EnumCodec)super.getCodec();
    }

    @Nonnull
    public EnumPropertyId<T> ignoreCase() {
        ((EnumCodec)this.getCodec()).ignoreCase();
        return this;
    }

    @Nonnull
    public EnumPropertyId<T> sorted() {
        ((EnumCodec)this.getCodec()).sorted();
        return this;
    }

    @Override
    @Nonnull
    public EnumPropertyId<T> addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public EnumPropertyId<T> addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    @Nonnull
    public BooleanExpression is(@Nonnull T enumValue) {
        return new BooleanExpression((Enum)enumValue){
            final /* synthetic */ Enum val$enumValue;
            {
                this.val$enumValue = enum_;
            }

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!EnumPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(EnumPropertyId.this);
                }
                return checker.parse(EnumPropertyId.this) == this.val$enumValue;
            }

            @Override
            @Nonnull
            public String getDescription() {
                return EnumPropertyId.this.format(this.formatPropertyName(EnumPropertyId.this), true, ((EnumCodec)EnumPropertyId.this.getCodec()).formatValue(this.val$enumValue));
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return EnumPropertyId.this.format(this.formatPropertyName(checker, EnumPropertyId.this), this.eval(checker), ((EnumCodec)EnumPropertyId.this.getCodec()).formatValue((Enum)checker.parse(EnumPropertyId.this)));
                }
                catch (MissingPropertyException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    private String format(@Nonnull String left, boolean set, @Nonnull String right) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        sb.append(" is ");
        if (!set) {
            sb.append("not ");
        }
        sb.append("set to '");
        sb.append(right);
        sb.append('\'');
        return sb.toString();
    }
}

