/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.sched.util.codec.DoubleCodec;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.DoubleExpression;
import com.android.sched.util.config.id.PropertyId;
import javax.annotation.Nonnull;

public class DoublePropertyId
extends PropertyId<Double> {
    @Nonnull
    public static DoublePropertyId create(@Nonnull String name, @Nonnull String description) {
        return new DoublePropertyId(name, description, new DoubleCodec());
    }

    protected DoublePropertyId(@Nonnull String name, @Nonnull String description, @Nonnull DoubleCodec parser) {
        super(name, description, parser);
    }

    @Nonnull
    public DoublePropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public DoublePropertyId addDefaultValue(@Nonnull Double defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public DoublePropertyId addDefaultValue(@Nonnull double defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public DoublePropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public DoubleCodec getCodec() {
        return (DoubleCodec)super.getCodec();
    }

    @Nonnull
    public DoublePropertyId withMin(double min) {
        this.getCodec().setMin(min);
        return this;
    }

    @Nonnull
    public DoublePropertyId withMax(double max) {
        this.getCodec().setMax(max);
        return this;
    }

    @Nonnull
    public DoubleExpression getValue() {
        return new DoubleExpression(){

            @Override
            public double eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!DoublePropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(DoublePropertyId.this);
                }
                return checker.parse(DoublePropertyId.this);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return this.formatPropertyName(DoublePropertyId.this);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return this.formatPropertyName(checker, DoublePropertyId.this);
            }
        };
    }

    @Nonnull
    public DoublePropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public DoublePropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }
}

