/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.sched.util.config.ChainedException;
import com.android.sched.util.config.ConfigurationException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class VariableConfigurationException
extends ConfigurationException {
    private static final long serialVersionUID = 1L;
    @Nonnegative
    private final String variable;

    public VariableConfigurationException(@Nonnull String variable, @Nonnull String message) {
        super(message);
        this.variable = variable;
    }

    public VariableConfigurationException(@Nonnull String variable, @Nonnull ChainedException causes) {
        this(variable, (Throwable)causes);
        ChainedException nextCause = causes.getNextException();
        if (nextCause != null) {
            new VariableConfigurationException(variable, nextCause).putAsLastExceptionOf(this);
        }
    }

    public VariableConfigurationException(@Nonnull String variable, @Nonnull Throwable cause) {
        super("Environment variable '" + variable + "': " + cause.getMessage(), cause);
        this.variable = variable;
    }

    public VariableConfigurationException(@Nonnull String variable, @Nonnull String message, @Nonnull ChainedException causes) {
        this(variable, (Throwable)causes);
        ChainedException nextCause = causes.getNextException();
        if (nextCause != null) {
            new VariableConfigurationException(variable, message, nextCause).putAsLastExceptionOf(this);
        }
    }

    public VariableConfigurationException(@Nonnull String variable, @Nonnull String message, @Nonnull Throwable cause) {
        super(message, cause);
        this.variable = variable;
    }

    @Nonnull
    public String getVariableName() {
        return this.variable;
    }
}

