/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.EnumName;
import com.android.sched.util.codec.KeyValueCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.codec.VariableName;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class EnumCodec<T extends Enum<T>>
implements StringCodec<T> {
    @Nonnull
    private final KeyValueCodec<T> parser;

    public EnumCodec(@Nonnull Class<T> type) {
        Field[] fields = type.getDeclaredFields();
        ArrayList<KeyValueCodec.Entry<T>> entries = new ArrayList<KeyValueCodec.Entry<T>>(fields.length);
        for (Field field : fields) {
            EnumName meta;
            if (!field.isEnumConstant() || (meta = field.getAnnotation(EnumName.class)) == null) continue;
            entries.add(new KeyValueCodec.Entry<T>(meta.name(), Enum.valueOf(type, field.getName()), meta.description(), meta.hide()));
        }
        VariableName variableName = type.getAnnotation(VariableName.class);
        if (variableName == null || variableName.value() == null) {
            throw new AssertionError((Object)(type.getCanonicalName() + " has no or a wrong @" + VariableName.class.getSimpleName()));
        }
        this.parser = new KeyValueCodec(variableName.value(), entries.toArray(new KeyValueCodec.Entry[entries.size()]));
    }

    @Nonnull
    public EnumCodec<T> ignoreCase() {
        this.parser.ignoreCase();
        return this;
    }

    @Nonnull
    public EnumCodec<T> sorted() {
        this.parser.sorted();
        return this;
    }

    @Override
    @Nonnull
    public T parseString(@Nonnull CodecContext context, @Nonnull String string) {
        return (T)((Enum)this.parser.parseString(context, string));
    }

    @Override
    @Nonnull
    public T checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        return (T)((Enum)this.parser.checkString(context, string));
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull T value) throws CheckingException {
        this.parser.checkValue(context, value);
    }

    @Override
    @Nonnull
    public String getUsage() {
        return this.parser.getUsage();
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return this.parser.getValueDescriptions();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull T value) {
        return this.parser.formatValue(value);
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return this.parser.getVariableName();
    }

    public boolean hasPublicEntries() {
        return this.parser.hasPublicEntries();
    }
}

