/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.filter.ComponentFilterManager;
import com.android.sched.filter.ManagedComponentFilter;
import com.android.sched.item.Component;
import com.android.sched.item.Item;
import com.android.sched.item.ManagedItem;
import com.android.sched.schedulable.AdapterSchedulable;
import com.android.sched.schedulable.ComponentFilter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Schedulable;
import com.android.sched.schedulable.SchedulerVisitable;
import com.android.sched.schedulable.VisitorSchedulable;
import com.android.sched.scheduler.AdapterProcessException;
import com.android.sched.scheduler.ComponentFilterSet;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.PlanStep;
import com.android.sched.scheduler.ProcessException;
import com.android.sched.scheduler.RunnerProcessException;
import com.android.sched.scheduler.SchedulableManager;
import com.android.sched.scheduler.Scheduler;
import com.android.sched.scheduler.TagOrMarkerOrComponentSet;
import com.android.sched.scheduler.VisitorProcessException;
import com.android.sched.transform.TransformRequest;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ReflectFactory;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.LongPropertyId;
import com.android.sched.util.config.id.ReflectFactoryPropertyId;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.SchedEventType;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@HasKeyId
@VariableName(value="runner")
public abstract class ScheduleInstance<T extends Component> {
    @Nonnull
    public static final ReflectFactoryPropertyId<ScheduleInstance> DEFAULT_RUNNER = ((ReflectFactoryPropertyId)ReflectFactoryPropertyId.create("sched.runner", "Kind of runner for runnable", ScheduleInstance.class).addArgType(Plan.class).addDefaultValue("multi-threaded")).bypassAccessibility();
    @Nonnull
    public static final BooleanPropertyId SKIP_ADAPTER = BooleanPropertyId.create("sched.filter.skip-adapters", "Skip adapters as soon as possible").addDefaultValue(true);
    public boolean skipAdapter = ThreadConfig.get(SKIP_ADAPTER);
    @Nonnull
    public static final LongPropertyId DEFAULT_STACK_SIZE = LongPropertyId.create("sched.runner.stack-size", "Size of Worker stack in bytes").withMin(0L).addDefaultValue(0x200000L);
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    protected final Scheduler scheduler;
    @Nonnull
    protected final SchedStep<T>[] steps;
    @Nonnull
    private final FeatureSet features;
    @Nonnull
    private final FilterInstance<T>[] filterInstances;
    @CheckForNull
    private ScheduleInstance<?> parent;
    @Nonnull
    private ComponentFilterSet filtersNeeded;
    private static final ThreadLocal<Stack<ElementStack>> tlsVisitStack = new ThreadLocal<Stack<ElementStack>>(){

        @Override
        protected Stack<ElementStack> initialValue() {
            return new Stack<ElementStack>();
        }
    };

    public static <T extends Component> ScheduleInstance<T> createScheduleInstance(Plan<T> plan) {
        ScheduleInstance schedInstance = (ScheduleInstance)((ReflectFactory)((Object)ThreadConfig.get(DEFAULT_RUNNER))).create(plan);
        if (ThreadConfig.get(SKIP_ADAPTER).booleanValue()) {
            TagOrMarkerOrComponentSet components = plan.getScheduler().createTagOrMarkerOrComponentSet();
            components.add(plan.getRunOn());
            for (SchedStep<T> step : schedInstance.steps) {
                step.makeAdaptersSkippable(components);
            }
        }
        return schedInstance;
    }

    protected ScheduleInstance(@Nonnull Plan<T> plan) throws Exception {
        this.scheduler = plan.getScheduler();
        this.features = plan.getFeatures();
        try (Event eventGlobal = this.tracer.open(SchedEventType.INSTANCIER);){
            this.steps = new SchedStep[plan.size()];
            int idx = 0;
            this.filtersNeeded = this.scheduler.createComponentFilterSet();
            for (PlanStep step : plan) {
                SchedStep instance = null;
                try (Event event = this.tracer.open(SchedEventType.INSTANCIER);){
                    if (step.isVisitor()) {
                        ScheduleInstance<? extends Component> subInstance = step.getSubPlan().getScheduleInstance();
                        subInstance.parent = this;
                        instance = new AdapterSchedStep((ManagedVisitor)step.getManagedSchedulable(), subInstance);
                    } else {
                        instance = new RunnableSchedStep((ManagedRunnable)step.getManagedSchedulable());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Cannot instantiate schedulable '" + step.getManagedSchedulable().getName() + "'", e);
                    throw e;
                }
                this.filtersNeeded.addAll(instance.runnableFilters);
                this.steps[idx++] = instance;
            }
            ArrayList tmp = new ArrayList(this.filtersNeeded.getSize());
            Iterator<ManagedItem> iter = this.filtersNeeded.managedIterator();
            idx = 0;
            while (iter.hasNext()) {
                ManagedComponentFilter mcf = (ManagedComponentFilter)iter.next();
                Class<? extends Item> filter = mcf.getItem();
                if (mcf.getFilterOn().isAssignableFrom(plan.getRunOn())) {
                    tmp.add(new FilterInstance(filter, mcf));
                    continue;
                }
                this.filtersNeeded.remove(mcf);
            }
            this.filterInstances = tmp.toArray(new FilterInstance[tmp.size()]);
        }
    }

    public abstract <X extends VisitorSchedulable<T>, U extends Component> void process(@Nonnull T var1) throws ProcessException;

    protected <U extends Component> void runWithLog(@Nonnull RunnableSchedulable<U> runner, @Nonnull U data) throws RunnerProcessException {
        ManagedSchedulable managedSchedulable = this.scheduler.getSchedulableManager().getManagedSchedulable(runner.getClass());
        Stack<ElementStack> visitStack = tlsVisitStack.get();
        visitStack.push(new ElementStack(this.features, managedSchedulable));
        try (Event event = this.logAndTraceSchedulable(runner, data);){
            try {
                runner.run(data);
            }
            catch (Throwable e) {
                throw new RunnerProcessException(runner, managedSchedulable, data, e);
            }
        }
        visitStack.pop();
    }

    protected <X extends VisitorSchedulable<T>, U extends Component> void visitWithLog(@Nonnull VisitorSchedulable<U> visitor, @Nonnull U data) throws VisitorProcessException {
        ManagedSchedulable managedSchedulable = this.scheduler.getSchedulableManager().getManagedSchedulable(visitor.getClass());
        Stack<ElementStack> visitStack = tlsVisitStack.get();
        visitStack.push(new ElementStack(this.features, managedSchedulable));
        try (Event event = this.logAndTraceSchedulable(visitor, data);){
            assert (data instanceof SchedulerVisitable);
            try {
                ((SchedulerVisitable)((Object)data)).visit(visitor, new TransformRequest());
            }
            catch (Throwable e) {
                throw new VisitorProcessException(visitor, managedSchedulable, data, e);
            }
        }
        visitStack.pop();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected <DST extends Component> Iterator<DST> adaptWithLog(@Nonnull AdapterSchedulable<T, DST> adapter, @Nonnull T data) throws AdapterProcessException {
        try (Event event = this.logAndTraceSchedulable(adapter, (Component)data);){
            Iterator<DST> iterator = adapter.adapt(data);
            return iterator;
        }
        catch (Throwable e) {
            ManagedSchedulable managedSchedulable = this.scheduler.getSchedulableManager().getManagedSchedulable(adapter.getClass());
            throw new AdapterProcessException(adapter, managedSchedulable, data, e);
        }
    }

    @Nonnull
    private <U extends Component> Event logAndTraceSchedulable(@Nonnull Schedulable schedulable, @Nonnull U data) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Run {0} ''{1}'' on ''{2}''", new Object[]{schedulable instanceof AdapterSchedulable ? "adapter" : "runner", this.getSchedulableName(schedulable.getClass()), data});
        }
        if (this.tracer.isTracing()) {
            return this.tracer.open(this.getSchedulableName(schedulable.getClass()));
        }
        return this.tracer.open("<no-name>");
    }

    @CheckForNull
    public static ManagedSchedulable getCurrentSchedulable() throws EmptyStackException {
        return tlsVisitStack.get().peek().schedulable;
    }

    @CheckForNull
    public static FeatureSet getCurrentFeatures() throws EmptyStackException {
        return tlsVisitStack.get().peek().features;
    }

    @Nonnull
    protected String getSchedulableName(@Nonnull Class<? extends Schedulable> schedulable) {
        SchedulableManager manager = this.scheduler.getSchedulableManager();
        ManagedSchedulable managed = manager.getManagedSchedulable(schedulable);
        String name = managed != null ? managed.getName() : "<" + schedulable.getSimpleName() + ">";
        return name;
    }

    @Nonnull
    private String getComponentFilerName(@Nonnull Class<? extends ComponentFilter<T>> filter) {
        ComponentFilterManager manager = this.scheduler.getFilterManager();
        ManagedComponentFilter managed = manager.getManagedComponentFilter(filter);
        String name = managed != null ? managed.getName() : "<" + filter.getClass().getSimpleName() + ">";
        return name;
    }

    @Nonnull
    protected ComponentFilterSet applyFilters(@Nonnull ComponentFilterSet parentFilters, @Nonnull T component) {
        ComponentFilterSet currentFilters = parentFilters.clone();
        for (FilterInstance<T> configFilter : this.filterInstances) {
            if (this.parent != null && this.parent.filtersNeeded.contains(configFilter.filterItem)) {
                if (!currentFilters.contains(configFilter.filterItem) || this.filterWithLog(configFilter.filter, component)) continue;
                currentFilters.remove(configFilter.filterItem);
                continue;
            }
            if (!this.filterWithLog(configFilter.filter, component)) continue;
            currentFilters.add(configFilter.filterItem);
        }
        return currentFilters;
    }

    private boolean filterWithLog(@Nonnull ComponentFilter<T> filter, @Nonnull T component) {
        try (Event event = this.logAndTraceFilter(filter, component);){
            boolean bl = filter.accept(component);
            return bl;
        }
    }

    private Event logAndTraceFilter(@Nonnull ComponentFilter<T> filter, @Nonnull T component) {
        Class<?> filterClass;
        if (logger.isLoggable(Level.FINEST)) {
            filterClass = filter.getClass();
            logger.log(Level.FINEST, "Run filter ''{0}'' on ''{1}''", new Object[]{this.getComponentFilerName(filterClass), component});
        }
        if (this.tracer.isTracing()) {
            filterClass = filter.getClass();
            return this.tracer.open(this.getComponentFilerName(filterClass));
        }
        return this.tracer.open("<no-name>");
    }

    private static class FilterInstance<T extends Component> {
        @Nonnull
        public final ComponentFilter<T> filter;
        @Nonnull
        public final ManagedComponentFilter filterItem;

        public FilterInstance(@Nonnull Class<? extends ComponentFilter<T>> cl, @Nonnull ManagedComponentFilter item) {
            try {
                this.filter = cl.newInstance();
            }
            catch (InstantiationException e) {
                throw new AssertionError();
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
            this.filterItem = item;
        }

        public final boolean equals(@CheckForNull Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FilterInstance)) {
                return false;
            }
            FilterInstance other = (FilterInstance)obj;
            return this.filterItem.equals(other.filterItem);
        }

        public final int hashCode() {
            return this.filterItem.hashCode();
        }
    }

    private static class ElementStack {
        @CheckForNull
        private final FeatureSet features;
        @CheckForNull
        private final ManagedSchedulable schedulable;

        ElementStack(@CheckForNull FeatureSet features, @CheckForNull ManagedSchedulable schedulable) {
            this.features = features;
            this.schedulable = schedulable;
        }
    }

    protected class AdapterSchedStep<T>
    extends SchedStep<T> {
        @Nonnull
        private final ManagedVisitor managed;
        @Nonnull
        private final ScheduleInstance<? extends Component> subSchedInstance;
        @Nonnull
        protected ComponentFilterSet adapterFilters;
        private boolean canBeSkipped;

        protected AdapterSchedStep(@Nonnull ManagedVisitor managed, ScheduleInstance<? extends Component> subSchedInstance) throws Exception {
            super(managed);
            this.canBeSkipped = false;
            this.managed = managed;
            this.subSchedInstance = subSchedInstance;
            this.adapterFilters = ScheduleInstance.this.scheduler.createComponentFilterSet();
            for (SchedStep step : subSchedInstance.steps) {
                this.runnableFilters.addAll(step.runnableFilters);
            }
        }

        @Override
        protected void makeAdaptersSkippable(@Nonnull TagOrMarkerOrComponentSet components) {
            this.canBeSkipped = true;
            this.adapterFilters.clear();
            Iterator<ManagedItem> iter = this.runnableFilters.managedIterator();
            while (iter.hasNext()) {
                ManagedComponentFilter mcf = (ManagedComponentFilter)iter.next();
                for (Class component : components) {
                    if (!mcf.getFilterOn().isAssignableFrom(component)) continue;
                    this.adapterFilters.add(mcf.getComponentFilter());
                    break;
                }
                if (this.adapterFilters.contains(mcf.getComponentFilter())) continue;
                this.canBeSkipped = false;
                this.adapterFilters.clear();
                break;
            }
            TagOrMarkerOrComponentSet nextComponents = components.clone();
            nextComponents.add(this.managed.getRunOnAfter());
            for (SchedStep step : this.subSchedInstance.steps) {
                step.makeAdaptersSkippable(nextComponents);
            }
            if (!this.canBeSkipped) {
                logger.log(Level.FINER, "Adapter ''{0}'' cannot be skipped", this.getName());
            } else {
                logger.log(Level.FINER, "Adapter ''{0}'' is skippable if no filter {1}", new Object[]{this.getName(), this.runnableFilters});
            }
        }

        @Nonnull
        public ScheduleInstance<? extends Component> getSubSchedInstance() {
            return this.subSchedInstance;
        }

        @Override
        public boolean isSkippable(@Nonnull ComponentFilterSet current) {
            return this.canBeSkipped && !current.containsOne(this.adapterFilters);
        }

        @Override
        @Nonnull
        public ComponentFilterSet getRequiredFilters() {
            return this.runnableFilters.clone();
        }
    }

    protected class RunnableSchedStep<T>
    extends SchedStep<T> {
        protected RunnableSchedStep(ManagedRunnable managed) throws Exception {
            super(managed);
            this.runnableFilters.addAll(managed.getFilters(ScheduleInstance.this.features));
            logger.log(Level.FINEST, "Runner filters for runner ''{0}'' are {1} ", new Object[]{this.getName(), this.runnableFilters});
        }

        @Override
        public boolean isSkippable(@Nonnull ComponentFilterSet current) {
            return !current.containsAll(this.runnableFilters);
        }

        @Override
        @Nonnull
        public ComponentFilterSet getRequiredFilters() {
            return this.runnableFilters.clone();
        }

        @Override
        protected void makeAdaptersSkippable(@Nonnull TagOrMarkerOrComponentSet components) {
        }
    }

    protected abstract class SchedStep<T> {
        @Nonnull
        private Schedulable instance;
        @Nonnull
        protected final ComponentFilterSet runnableFilters;

        protected SchedStep(ManagedSchedulable managed) throws Exception {
            try {
                this.instance = managed.getSchedulable().newInstance();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot instantiate schedulable '" + managed.getName() + "'", e);
                throw e;
            }
            this.runnableFilters = ScheduleInstance.this.scheduler.createComponentFilterSet();
        }

        @Nonnull
        public Schedulable getInstance() {
            return this.instance;
        }

        public abstract boolean isSkippable(@Nonnull ComponentFilterSet var1);

        @Nonnull
        public abstract ComponentFilterSet getRequiredFilters();

        protected abstract void makeAdaptersSkippable(@Nonnull TagOrMarkerOrComponentSet var1);

        @Nonnull
        public String getName() {
            return ScheduleInstance.this.getSchedulableName(this.instance.getClass());
        }
    }
}

