/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util.collect;

import com.android.jack.Jack;
import com.android.sched.util.SubReleaseKind;
import com.android.sched.util.codec.DefaultFactorySelector;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.config.DefaultFactory;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.category.Private;
import com.android.sched.util.config.id.PropertyId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@HasKeyId
@VariableName(value="policy")
public interface UnmodifiableCollections {
    @Nonnull
    public static final PropertyId<DefaultFactory<UnmodifiableCollections>> UNMODIFIABLE_COLLECTION = PropertyId.create("jack.collections.unmodifiable", "Policy when using an unmodifiable collection", new DefaultFactorySelector<UnmodifiableCollections>(UnmodifiableCollections.class)).addDefaultValue((UnmodifiableCollections)((Object)(Jack.getVersion().getSubReleaseKind() == SubReleaseKind.ENGINEERING ? "always-check" : "never-check"))).addCategory(Private.class);

    @Nonnull
    public <T> List<T> getUnmodifiableList(@Nonnull List<T> var1);

    @Nonnull
    public <T> Set<T> getUnmodifiableSet(@Nonnull Set<T> var1);

    @Nonnull
    public <T> Collection<T> getUnmodifiableCollection(@Nonnull Collection<T> var1);

    @ImplementationName(iface=UnmodifiableCollections.class, name="never-check")
    public static class ChecksdisabledUnmodifiableCollection
    implements UnmodifiableCollections {
        @Override
        @Nonnull
        public <T> List<T> getUnmodifiableList(@Nonnull List<T> list) {
            return list;
        }

        @Override
        @Nonnull
        public <T> Set<T> getUnmodifiableSet(@Nonnull Set<T> set) {
            return set;
        }

        @Override
        @Nonnull
        public <T> Collection<T> getUnmodifiableCollection(@Nonnull Collection<T> collection) {
            return collection;
        }
    }

    @ImplementationName(iface=UnmodifiableCollections.class, name="always-check")
    public static class ChecksEnabledUnmodifiableCollection
    implements UnmodifiableCollections {
        @Override
        @Nonnull
        public <T> List<T> getUnmodifiableList(@Nonnull List<T> list) {
            return Collections.unmodifiableList(list);
        }

        @Override
        @Nonnull
        public <T> Set<T> getUnmodifiableSet(@Nonnull Set<T> set) {
            return Collections.unmodifiableSet(set);
        }

        @Override
        @Nonnull
        public <T> Collection<T> getUnmodifiableCollection(@Nonnull Collection<T> collection) {
            return Collections.unmodifiableCollection(collection);
        }
    }
}

