/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util.args4j;

import com.android.jack.google.common.base.Joiner;
import com.android.jack.kohsuke.args4j.CmdLineException;
import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.OptionDef;
import com.android.jack.kohsuke.args4j.spi.EnumOptionHandler;
import com.android.jack.kohsuke.args4j.spi.OptionHandler;
import com.android.jack.kohsuke.args4j.spi.Parameters;
import com.android.jack.kohsuke.args4j.spi.Setter;
import com.android.sched.util.log.LoggerFactory;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JackEnumOptionHandler<T extends Enum<T>>
extends OptionHandler<T> {
    @Nonnull
    private final Class<T> enumType;
    @Nonnull
    private final EnumOptionHandler<T> delegate;

    public JackEnumOptionHandler(@Nonnull CmdLineParser parser, @Nonnull OptionDef option, @Nonnull Setter<? super T> setter) {
        super(parser, option, setter);
        this.enumType = setter.getType();
        this.delegate = new EnumOptionHandler<T>(parser, option, setter, this.enumType);
    }

    @Override
    public int parseArguments(@Nonnull Parameters params) throws CmdLineException {
        return this.delegate.parseArguments(params);
    }

    @Override
    @CheckForNull
    public String getDefaultMetaVariable() {
        Enum[] enumConstants = (Enum[])this.enumType.getEnumConstants();
        ArrayList<String> items = new ArrayList<String>(enumConstants.length);
        for (Enum item : enumConstants) {
            try {
                if (this.enumType.getField(item.name()).getAnnotation(Deprecated.class) != null) continue;
                items.add(item.name().toLowerCase());
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError();
            }
            catch (SecurityException e) {
                items.add(item.name());
                LoggerFactory.getLogger().info("A SecurityException occured while getting field '" + item.name() + "' from enum '" + this.enumType.getName() + "': " + e.getMessage());
            }
        }
        return '[' + Joiner.on(" | ").join(items) + ']';
    }
}

