/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JBreakStatement;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JContinueStatement;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JLoop;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.transformations.finallyblock.InlinedFinallyMarker;
import com.android.jack.transformations.request.AddJLocalInMethodBody;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.CloneExpressionVisitor;
import com.android.sched.marker.Marker;
import com.android.sched.schedulable.Constraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(no={JLoop.class, JBreakStatement.class, JContinueStatement.class, JFieldInitializer.class})
public class CloneStatementVisitor
extends CloneExpressionVisitor {
    @CheckForNull
    protected JStatement statement;
    @Nonnull
    private Map<JLabeledStatement, JLabeledStatement> clonedLabeledStmts = Collections.emptyMap();
    @Nonnull
    private Map<JLocal, JLocal> clonedLocals = Collections.emptyMap();
    @Nonnull
    private Map<JCatchBlock, JCatchBlock> clonedCatchBlocks = Collections.emptyMap();
    @Nonnull
    private List<JGoto> clonedGotos = Collections.emptyList();
    @Nonnull
    private final TransformationRequest trRequest;
    @Nonnull
    private Map<JStatement, JStatement> clonedStmts = Collections.emptyMap();
    @Nonnull
    private List<Marker> clonedMarkers = Collections.emptyList();
    @Nonnull
    private final JMethod targetMethod;

    public CloneStatementVisitor(@Nonnull TransformationRequest trRequest, @Nonnull JMethod targetMethod) {
        this.trRequest = trRequest;
        this.targetMethod = targetMethod;
    }

    @Nonnull
    public JMethod getTargetMethod() {
        return this.targetMethod;
    }

    public List<Marker> getClonedMarkers() {
        return this.clonedMarkers;
    }

    @Nonnull
    public <T extends JStatement> T cloneStatement(@Nonnull T stmt) {
        this.clonedLabeledStmts = new HashMap<JLabeledStatement, JLabeledStatement>();
        this.clonedLocals = new HashMap<JLocal, JLocal>();
        this.clonedGotos = new ArrayList<JGoto>();
        this.clonedStmts = new HashMap<JStatement, JStatement>();
        this.clonedMarkers = new ArrayList<Marker>();
        this.clonedCatchBlocks = new HashMap<JCatchBlock, JCatchBlock>();
        T statement = this.internalCloneStatement(stmt);
        this.fixGotos();
        this.fixMarkers();
        return statement;
    }

    protected void fixMarkers() {
        for (Marker m : this.clonedMarkers) {
            InlinedFinallyMarker newMarker;
            JStatement newStmt;
            if (!(m instanceof InlinedFinallyMarker) || (newStmt = this.clonedStmts.get((newMarker = (InlinedFinallyMarker)m).getTryStmt())) == null) continue;
            newMarker.setTryStmt((JTryStatement)newStmt);
        }
    }

    private void fixGotos() {
        for (JGoto clonedGoto : this.clonedGotos) {
            JLabeledStatement target = clonedGoto.getTargetBlock();
            JLabeledStatement clonedTarget = this.clonedLabeledStmts.get(target);
            if (clonedTarget == null) continue;
            clonedGoto.replace(target, clonedTarget);
        }
    }

    @Nonnull
    protected <T extends JStatement> T internalCloneStatement(@Nonnull T stmt) {
        JStatement alreadyCloned = this.clonedStmts.get(stmt);
        if (alreadyCloned != null) {
            return (T)alreadyCloned;
        }
        this.statement = null;
        this.accept(stmt);
        JStatement clonedStatement = this.statement;
        if (clonedStatement == null) {
            throw new AssertionError((Object)("Unable to clone statement " + stmt.toString()));
        }
        for (Marker m : stmt.getAllMarkers()) {
            Marker newMarker = m.cloneIfNeeded();
            this.clonedMarkers.add(newMarker);
            clonedStatement.addMarker(newMarker);
        }
        this.clonedStmts.put(stmt, this.statement);
        return (T)clonedStatement;
    }

    @Override
    public boolean visit(@Nonnull JAssertStatement assertStatement) {
        JExpression arg = assertStatement.getArg();
        JExpression clonedArg = arg != null ? this.cloneExpression(arg) : null;
        JExpression clonedTestExpr = this.cloneExpression(assertStatement.getTestExpr());
        this.statement = this.updateCatchBlockList(new JAssertStatement(assertStatement.getSourceInfo(), clonedTestExpr, clonedArg), assertStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JCatchBlock catchBlock) {
        this.statement = this.updateCatchBlockList(this.cloneCatchBlock(catchBlock), catchBlock);
        return false;
    }

    @Nonnull
    private JCatchBlock cloneCatchBlock(@Nonnull JCatchBlock catchBlock) {
        JCatchBlock newBlock = this.clonedCatchBlocks.get(catchBlock);
        if (newBlock == null) {
            JLocal clonedLocal = this.clonedLocals.get(catchBlock.getCatchVar());
            if (clonedLocal == null) {
                clonedLocal = this.cloneLocal(catchBlock.getCatchVar());
            }
            newBlock = new JCatchBlock(catchBlock.getSourceInfo(), catchBlock.getCatchTypes(), clonedLocal);
            this.clonedCatchBlocks.put(catchBlock, newBlock);
            for (JStatement stmt : catchBlock.getStatements()) {
                newBlock.addStmt(this.internalCloneStatement(stmt));
            }
        }
        return newBlock;
    }

    @Override
    public boolean visit(@Nonnull JBlock block) {
        JBlock newBlock = new JBlock(block.getSourceInfo());
        for (JStatement stmt : block.getStatements()) {
            newBlock.addStmt(this.internalCloneStatement(stmt));
        }
        this.statement = this.updateCatchBlockList(newBlock, block);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JBreakStatement breakStatement) {
        assert (false) : "Not supported";
        return false;
    }

    @Override
    public boolean visit(@Nonnull JCaseStatement caseStatement) {
        JLiteral caseExpr = caseStatement.getExpr();
        JLiteral clonedCaseExpr = caseExpr != null ? this.cloneExpression(caseExpr) : null;
        this.statement = this.updateCatchBlockList(new JCaseStatement(caseStatement.getSourceInfo(), clonedCaseExpr), caseStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JContinueStatement continueStatement) {
        assert (false) : "Not supported";
        return false;
    }

    @Override
    public boolean visit(@Nonnull JFieldInitializer init) {
        throw new AssertionError();
    }

    @Nonnull
    private JLocal cloneLocal(@Nonnull JLocal var) {
        JMethodBody methodBody = (JMethodBody)this.targetMethod.getBody();
        assert (methodBody != null);
        if (methodBody.getLocals().contains(var)) {
            return var;
        }
        String varName = var.getName();
        JLocal clonedVar = new JLocal(var.getSourceInfo(), varName == null ? null : this.cloneLocalName(varName), var.getType(), var.getModifier(), methodBody);
        if (!(var.getParent() instanceof JCatchBlock)) {
            this.trRequest.append(new AddJLocalInMethodBody(clonedVar, methodBody));
        }
        this.clonedLocals.put(var, clonedVar);
        return clonedVar;
    }

    @Nonnull
    protected String cloneLocalName(@Nonnull String orgName) {
        return orgName;
    }

    @Override
    public boolean visit(@Nonnull JDoStatement doStatement) {
        assert (false) : "Not supported";
        return false;
    }

    @Override
    public boolean visit(@Nonnull JExpressionStatement expressionStatement) {
        this.statement = this.updateCatchBlockList(this.cloneExpression(expressionStatement.getExpr()).makeStatement(), expressionStatement);
        return false;
    }

    @Nonnull
    protected JStatement updateCatchBlockList(@Nonnull JStatement clonedStmt, @Nonnull JStatement orignalStmt) {
        for (JCatchBlock catchBlocks : orignalStmt.getJCatchBlocks()) {
            clonedStmt.appendCatchBlock(this.cloneCatchBlock(catchBlocks));
        }
        return clonedStmt;
    }

    @Override
    public boolean visit(@Nonnull JForStatement forStatement) {
        assert (false) : "Not supported";
        return false;
    }

    @Override
    public boolean visit(@Nonnull JGoto gotoStatement) {
        JGoto newGoto = new JGoto(gotoStatement.getSourceInfo(), gotoStatement.getTargetBlock());
        this.clonedGotos.add(newGoto);
        this.statement = this.updateCatchBlockList(newGoto, gotoStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JIfStatement ifStatement) {
        JExpression clonedCond = this.cloneExpression(ifStatement.getIfExpr());
        JStatement clonedThen = this.internalCloneStatement(ifStatement.getThenStmt());
        JStatement elseStmt = ifStatement.getElseStmt();
        JStatement clonedElse = null;
        if (elseStmt != null) {
            clonedElse = this.internalCloneStatement(elseStmt);
        }
        this.statement = this.updateCatchBlockList(new JIfStatement(ifStatement.getSourceInfo(), clonedCond, clonedThen, clonedElse), ifStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLabeledStatement labeledStatement) {
        JStatement clonedBody = this.internalCloneStatement(labeledStatement.getBody());
        JLabel label = labeledStatement.getLabel();
        JLabel newLabel = new JLabel(label.getSourceInfo(), label.getName());
        JLabeledStatement newLabeledStatement = new JLabeledStatement(labeledStatement.getSourceInfo(), newLabel, clonedBody);
        this.clonedLabeledStmts.put(labeledStatement, newLabeledStatement);
        this.statement = this.updateCatchBlockList(newLabeledStatement, labeledStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLock lockStatement) {
        JExpression clonedExpr = this.cloneExpression(lockStatement.getLockExpr());
        this.statement = this.updateCatchBlockList(new JLock(lockStatement.getSourceInfo(), clonedExpr), lockStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JUnlock unlockStatement) {
        JExpression clonedExpr = this.cloneExpression(unlockStatement.getLockExpr());
        this.statement = this.updateCatchBlockList(new JUnlock(unlockStatement.getSourceInfo(), clonedExpr), unlockStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JReturnStatement returnStatement) {
        JExpression clonedExpr = null;
        JExpression expr = returnStatement.getExpr();
        if (expr != null) {
            clonedExpr = this.cloneExpression(expr);
        }
        this.statement = this.updateCatchBlockList(new JReturnStatement(returnStatement.getSourceInfo(), clonedExpr), returnStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JSwitchStatement switchStatement) {
        JExpression clonedExpr = this.cloneExpression(switchStatement.getExpr());
        JBlock clonedBody = this.internalCloneStatement(switchStatement.getBody());
        List<JCaseStatement> cases = switchStatement.getCases();
        ArrayList<JCaseStatement> clonedCases = new ArrayList<JCaseStatement>();
        for (JCaseStatement currentCase : cases) {
            clonedCases.add(this.internalCloneStatement(currentCase));
        }
        JCaseStatement clonedDefaultCase = null;
        JCaseStatement defaultCase = switchStatement.getDefaultCase();
        if (defaultCase != null) {
            clonedDefaultCase = this.internalCloneStatement(defaultCase);
        }
        this.statement = this.updateCatchBlockList(new JSwitchStatement(switchStatement.getSourceInfo(), clonedExpr, clonedBody, clonedCases, clonedDefaultCase), switchStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JThrowStatement throwStatement) {
        JExpression clonedExpr = this.cloneExpression(throwStatement.getExpr());
        this.statement = this.updateCatchBlockList(new JThrowStatement(throwStatement.getSourceInfo(), clonedExpr), throwStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JTryStatement tryStatement) {
        JBlock clonedTryBlock = this.internalCloneStatement(tryStatement.getTryBlock());
        assert (clonedTryBlock != null);
        List<JCatchBlock> catchBlocks = tryStatement.getCatchBlocks();
        ArrayList<JCatchBlock> clonedCatchBlocks = new ArrayList<JCatchBlock>(catchBlocks.size());
        for (JCatchBlock catchBlock : catchBlocks) {
            clonedCatchBlocks.add(this.internalCloneStatement(catchBlock));
        }
        JBlock clonedFinallyBlock = null;
        JBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            clonedFinallyBlock = this.internalCloneStatement(finallyBlock);
        }
        List<JStatement> resourcesDeclarations = tryStatement.getResourcesDeclarations();
        ArrayList<JStatement> clonedResourcesDeclarations = new ArrayList<JStatement>(resourcesDeclarations.size());
        for (JStatement stmt : resourcesDeclarations) {
            clonedResourcesDeclarations.add(this.internalCloneStatement(stmt));
        }
        this.statement = this.updateCatchBlockList(new JTryStatement(tryStatement.getSourceInfo(), clonedResourcesDeclarations, clonedTryBlock, clonedCatchBlocks, clonedFinallyBlock), tryStatement);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JWhileStatement whileStatement) {
        assert (false) : "Not supported";
        return false;
    }

    @Override
    public boolean visit(@Nonnull JThisRef jThisRef) {
        JThis jThis = this.targetMethod.getThis();
        assert (jThis != null);
        assert (jThis.getType().isSameType(jThisRef.getType()));
        this.expression = jThis.makeRef(jThisRef.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JLocalRef localRef) {
        JLocal clonedLocal = this.clonedLocals.get(localRef.getLocal());
        if (clonedLocal == null) {
            clonedLocal = this.cloneLocal(localRef.getLocal());
        }
        this.expression = clonedLocal.makeRef(localRef.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(@Nonnull JParameterRef parameterRef) {
        JParameter parameter = parameterRef.getParameter();
        assert (parameter.getEnclosingMethod() == this.targetMethod);
        this.expression = parameter.makeRef(parameterRef.getSourceInfo());
        return false;
    }
}

