/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.selection;

import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.SelectionStrategy;
import com.android.jack.uncommons.watchmaker.framework.selection.StochasticUniversalSampling;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class RankSelection
implements SelectionStrategy<Object> {
    private final SelectionStrategy<Object> delegate;

    public RankSelection() {
        this(new StochasticUniversalSampling());
    }

    public RankSelection(SelectionStrategy<Object> delegate) {
        this.delegate = delegate;
    }

    @Override
    public <S> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
        ArrayList rankedPopulation = new ArrayList(population.size());
        Iterator<EvaluatedCandidate<S>> iterator = population.iterator();
        int index = -1;
        while (iterator.hasNext()) {
            S candidate = iterator.next().getCandidate();
            rankedPopulation.add(new EvaluatedCandidate<S>(candidate, this.mapRankToScore(++index, population.size())));
        }
        return this.delegate.select(rankedPopulation, true, selectionSize, rng);
    }

    protected double mapRankToScore(int rank, int populationSize) {
        return populationSize - rank;
    }

    public String toString() {
        return "Rank Selection";
    }
}

