/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.enums;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JArrayLength;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JEnumField;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNeqOperation;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.enums.EnumMappingMarker;
import com.android.jack.transformations.request.AppendField;
import com.android.jack.transformations.request.AppendMethod;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.category.Private;
import com.android.sched.util.config.id.BooleanPropertyId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Add support for partial recompilation for enum used into switches.")
@Name(value="SwitchEnumSupport")
@Synchronized
@Constraint(need={JSwitchStatement.class, JEnumField.class, JEnumLiteral.class, UsedEnumField.class, OriginalNames.class})
@Transform(modify={JSwitchStatement.class}, add={EnumMappingMarker.class, JNewArray.class, JAsgOperation.NonReusedAsg.class, JMethodCall.class, JArrayRef.class, JArrayLength.class, JLocalRef.class, JField.class, JMethod.class, JMethodBody.class, JFieldRef.class, JNullLiteral.class, JLocal.class, JIfStatement.class, JReturnStatement.class, JBlock.class, JTryStatement.class, JIntLiteral.class, JExpressionStatement.class, JNeqOperation.class}, remove={JSwitchStatement.SwitchWithEnum.class, ThreeAddressCodeForm.class})
@Use(value={LocalVarCreator.class})
@HasKeyId
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
@ExclusiveAccess(value=JSession.class)
public class SwitchEnumSupport
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final BooleanPropertyId SORT_ENUM_FIELD = ((BooleanPropertyId)BooleanPropertyId.create("jack.internal.switch-enumfield.sort", "Generate determinist code to initialize constant array indexed by ordinal value of enum field").addDefaultValue(Boolean.TRUE).addCategory(Private.class)).addCategory(DumpInLibrary.class);
    private final JType noSuchFieldErrorType = Jack.getSession().getPhantomLookup().getType("Ljava/lang/NoSuchFieldError;");
    private final boolean sortEnumField = ThreadConfig.get(SORT_ENUM_FIELD);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        JDefinedClassOrInterface enclosingType = method.getEnclosingType();
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(enclosingType);
        Visitor visitor = new Visitor(tr, enclosingType);
        visitor.accept(method);
        tr.commit();
    }

    private class Visitor
    extends JVisitor {
        private static final String ORDINAL = "ordinal";
        @Nonnull
        private final TransformationRequest tr;
        @Nonnull
        private final JDefinedClassOrInterface currentClOrI;
        @CheckForNull
        private Set<JFieldId> usedEnumFields;

        public Visitor(@Nonnull TransformationRequest tr, JDefinedClassOrInterface clOrI) {
            this.tr = tr;
            this.currentClOrI = clOrI;
        }

        @Override
        public boolean visit(@Nonnull JMethod method) {
            UsedEnumField uef = method.getEnclosingType().getMarker(UsedEnumField.class);
            assert (uef != null);
            this.usedEnumFields = uef.getEnumFields();
            return super.visit(method);
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            JExpression expr = switchStmt.getExpr();
            JType exprType = expr.getType();
            if (exprType instanceof JDefinedEnum) {
                JDefinedEnum enumType = (JDefinedEnum)exprType;
                JMethod getEnumSwitchValues = this.getSwitchValuesMethod(enumType);
                JMethodId methodId = getEnumSwitchValues.getMethodId();
                JMethodCall callSwitchValues = new JMethodCall(switchStmt.getSourceInfo(), null, getEnumSwitchValues.getEnclosingType(), methodId, methodId.getMethodIdWide().canBeVirtual());
                JMethodId ordinalMethodId = enumType.getOrCreateMethodId(ORDINAL, Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
                this.tr.append(new Replace(expr, new JArrayRef(SourceInfo.UNKNOWN, callSwitchValues, new JMethodCall(SourceInfo.UNKNOWN, expr, enumType, ordinalMethodId, ordinalMethodId.getMethodIdWide().canBeVirtual()))));
            }
            return super.visit(switchStmt);
        }

        @Override
        public boolean visit(@Nonnull JCaseStatement caseStmt) {
            JLiteral caseExpr = caseStmt.getExpr();
            if (caseExpr != null && caseExpr instanceof JEnumLiteral) {
                JEnumLiteral literal = (JEnumLiteral)caseExpr;
                JMethod getEnumSwitchValues = this.getSwitchValuesMethod((JDefinedEnum)literal.getType());
                EnumMappingMarker emm = getEnumSwitchValues.getMarker(EnumMappingMarker.class);
                assert (emm != null);
                Integer enumSwitchValue = emm.getMapping().get(literal.getFieldId());
                assert (enumSwitchValue != null);
                this.tr.append(new Replace(caseExpr, new JIntLiteral(caseStmt.getSourceInfo(), enumSwitchValue)));
            }
            return super.visit(caseStmt);
        }

        @Nonnull
        private JMethod getSwitchValuesMethod(@Nonnull JDefinedEnum enumType) {
            JMethod getEnumSwitchValues;
            SourceInfo dbgInfo = SourceInfo.UNKNOWN;
            String enumName = BinaryQualifiedNameFormatter.getFormatter().getName(enumType);
            String methodName = NamingTools.getStrictNonSourceConflictingName("get" + enumName + "SwitchesValues");
            String fieldName = NamingTools.getStrictNonSourceConflictingName(enumName + "SwitchesValues");
            JArrayType switchValuesArrayType = JPrimitiveType.JPrimitiveTypeEnum.INT.getType().getArray();
            JArrayType enumArrayType = enumType.getArray();
            try {
                getEnumSwitchValues = this.currentClOrI.getMethod(methodName, (JType)switchValuesArrayType, new JType[0]);
            }
            catch (JMethodLookupException e) {
                JMethod valuesMethod;
                TransformationRequest localTr = new TransformationRequest(this.currentClOrI);
                JField enumSwitchValues = new JField(dbgInfo, fieldName, this.currentClOrI, switchValuesArrayType, (this.currentClOrI instanceof JDefinedInterface ? 1 : 2) | 0x10 | 8 | 0x1000);
                localTr.append(new AppendField(this.currentClOrI, enumSwitchValues));
                getEnumSwitchValues = new JMethod(dbgInfo, new JMethodId(new JMethodIdWide(methodName, MethodKind.STATIC), switchValuesArrayType), this.currentClOrI, 4106);
                localTr.append(new AppendMethod(this.currentClOrI, getEnumSwitchValues));
                JBlock bodyBlock = new JBlock(dbgInfo);
                JMethodBody body = new JMethodBody(dbgInfo, bodyBlock);
                getEnumSwitchValues.setBody(body);
                LocalVarCreator lvc = new LocalVarCreator(getEnumSwitchValues, "es");
                JFieldId enumSwitchValuesId = enumSwitchValues.getId();
                JBinaryOperation checkNull = JBinaryOperation.create(dbgInfo, JBinaryOperator.NEQ, new JFieldRef(dbgInfo, null, enumSwitchValuesId, this.currentClOrI), new JNullLiteral(dbgInfo));
                JBlock thenBlock = new JBlock(dbgInfo);
                thenBlock.addStmt(new JReturnStatement(dbgInfo, new JFieldRef(dbgInfo, null, enumSwitchValuesId, this.currentClOrI)));
                bodyBlock.addStmt(new JIfStatement(dbgInfo, checkNull, thenBlock, null));
                JLocal arrayVar = lvc.createTempLocal(switchValuesArrayType, dbgInfo, localTr);
                try {
                    valuesMethod = enumType.getMethod("values", (JType)enumArrayType, new JType[0]);
                }
                catch (JMethodLookupException e1) {
                    throw new AssertionError((Object)e1);
                }
                JMethodId valuesId = valuesMethod.getMethodId();
                JArrayLength valuesLength = new JArrayLength(dbgInfo, new JMethodCall(dbgInfo, null, enumType, valuesId, valuesId.getMethodIdWide().canBeVirtual()));
                ArrayList<JExpression> dimensions = new ArrayList<JExpression>();
                dimensions.add(valuesLength);
                bodyBlock.addStmt(new JAsgOperation(dbgInfo, arrayVar.makeRef(dbgInfo), JNewArray.createWithDims(dbgInfo, switchValuesArrayType, dimensions)).makeStatement());
                int usedEnumFieldCstValue = 1;
                assert (this.usedEnumFields != null);
                int unusedEnumFieldCstValue = this.usedEnumFields.size() + 1;
                EnumMappingMarker emm = new EnumMappingMarker();
                List<JField> enumFields = enumType.getFields();
                if (SwitchEnumSupport.this.sortEnumField) {
                    Collections.sort(enumFields, new Comparator<JField>(){

                        @Override
                        public int compare(JField o1, JField o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                }
                for (JField enumField : enumFields) {
                    if (!(enumField instanceof JEnumField)) continue;
                    JBlock tryBlock = new JBlock(dbgInfo);
                    JLocal exVar = new JLocal(dbgInfo, "ex", SwitchEnumSupport.this.noSuchFieldErrorType, 4096, body);
                    ArrayList<JCatchBlock> catchBlock = new ArrayList<JCatchBlock>(1);
                    catchBlock.add(new JCatchBlock(dbgInfo, Collections.singletonList((JClass)SwitchEnumSupport.this.noSuchFieldErrorType), exVar));
                    bodyBlock.addStmt(new JTryStatement(dbgInfo, Collections.emptyList(), tryBlock, catchBlock, null));
                    JFieldId enumFieldId = enumField.getId();
                    JFieldRef enumFieldAccess = new JFieldRef(dbgInfo, null, enumFieldId, enumType);
                    JMethodId ordinalMethodId = enumType.getOrCreateMethodId(ORDINAL, Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
                    JMethodCall callOrdinal = new JMethodCall(dbgInfo, enumFieldAccess, enumType, ordinalMethodId, ordinalMethodId.getMethodIdWide().canBeVirtual());
                    assert (this.usedEnumFields != null);
                    int constant = this.usedEnumFields.contains(enumFieldId) ? usedEnumFieldCstValue++ : unusedEnumFieldCstValue++;
                    tryBlock.addStmt(new JAsgOperation(dbgInfo, new JArrayRef(dbgInfo, arrayVar.makeRef(dbgInfo), callOrdinal), new JIntLiteral(dbgInfo, constant)).makeStatement());
                    emm.addMapping(enumFieldId, constant);
                }
                getEnumSwitchValues.addMarker(emm);
                bodyBlock.addStmt(new JAsgOperation(dbgInfo, new JFieldRef(dbgInfo, null, enumSwitchValuesId, this.currentClOrI), arrayVar.makeRef(dbgInfo)).makeStatement());
                bodyBlock.addStmt(new JReturnStatement(dbgInfo, arrayVar.makeRef(dbgInfo)));
                localTr.commit();
            }
            return getEnumSwitchValues;
        }
    }

    @Description(value="Enum fields used into switch")
    @ValidOn(value={JDefinedClass.class, JDefinedInterface.class})
    public static class UsedEnumField
    implements Marker {
        @Nonnull
        private final Set<JFieldId> enumFields;

        public UsedEnumField(@Nonnull Set<JFieldId> enumFields) {
            this.enumFields = enumFields;
        }

        @Nonnull
        public Set<JFieldId> getEnumFields() {
            return this.enumFields;
        }

        @Override
        public Marker cloneIfNeeded() {
            return this;
        }
    }
}

