/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.cast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.cast.SourceCast;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Removes useless casts.")
@Name(value="UselessCastRemover")
@Constraint(need={JDynamicCastOperation.class}, no={JCastOperation.WithIntersectionType.class})
@Transform(remove={SourceCast.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
@Access(value=JSession.class)
public class UselessCastRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(UselessCastRemover.class, method)) {
            return;
        }
        TransformationRequest request = new TransformationRequest(method);
        Visitor visitor = new Visitor(request);
        visitor.accept(method);
        request.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest request;

        public Visitor(@Nonnull TransformationRequest request) {
            this.request = request;
        }

        @Override
        public void endVisit(@Nonnull JCastOperation cast) {
            JType destType = cast.getType();
            JExpression castedExpr = cast.getExpr();
            JType srcType = castedExpr.getType();
            if (!(castedExpr instanceof JNullLiteral) && srcType instanceof JReferenceType && destType instanceof JReferenceType && ((JReferenceType)srcType).canBeSafelyUpcast((JReferenceType)destType)) {
                this.request.append(new Replace(cast, castedExpr));
            }
            super.endVisit(cast);
        }
    }
}

