/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string.parameterrefiners;

import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldNameLiteral;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.reflection.MemberFinder;
import com.android.jack.reflection.MultipleFieldsFoundException;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.string.parameterrefiners.CommonStringParameterRefiner;
import com.android.jack.transformations.ast.string.parameterrefiners.StringParameterRefiner;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Transform;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(need={OriginalNames.class})
@Transform(add={JFieldNameLiteral.class})
public class GetFieldParameterRefiner
extends CommonStringParameterRefiner
implements StringParameterRefiner {
    @Nonnull
    private static final String GETFIELD_METHOD_NAME = "getField";
    @Nonnull
    private final JMethodIdWide getFieldMethodId;

    public GetFieldParameterRefiner() {
        this.getFieldMethodId = this.javaLangClass.getMethodIdWide(GETFIELD_METHOD_NAME, Collections.singletonList(this.javaLangString), MethodKind.INSTANCE_VIRTUAL);
    }

    @Override
    public boolean isApplicable(@Nonnull JMethodCall call) throws JMethodLookupException {
        if (call.getReceiverType().isSameType(this.javaLangClass) && call.getMethodIdWide().equals(this.getFieldMethodId)) {
            assert (formatter.getName(call.getType()).equals("Ljava/lang/reflect/Field;"));
            return true;
        }
        return false;
    }

    @Override
    @CheckForNull
    public JStringLiteral getExpressionToRefine(@Nonnull JMethodCall call) {
        assert (call.getArgs().size() == 1);
        return this.getExpressionToRefine(call, 0);
    }

    @Override
    @CheckForNull
    public JAbstractStringLiteral getRefinedExpression(@Nonnull JMethodCall call, @Nonnull JStringLiteral paramToRefine) {
        String fieldName;
        JField field;
        JFieldNameLiteral strFieldLiteral = null;
        JDefinedClassOrInterface type = this.getTypeFromClassLiteralExpression(call.getInstance());
        if (type != null && (field = this.lookupField(type, fieldName = paramToRefine.getValue())) != null) {
            strFieldLiteral = new JFieldNameLiteral(paramToRefine.getSourceInfo(), field);
            assert (fieldName.equals(strFieldLiteral.getValue()));
        }
        return strFieldLiteral;
    }

    @CheckForNull
    protected JField lookupField(@Nonnull JDefinedClassOrInterface type, @Nonnull String fieldName) {
        JField foundField = null;
        try {
            foundField = MemberFinder.getField(type, fieldName);
        }
        catch (MultipleFieldsFoundException multipleFieldsFoundException) {
            // empty catch block
        }
        return foundField;
    }
}

