/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string.parameterrefiners;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.reflection.MemberFinder;
import com.android.jack.reflection.MultipleFieldsFoundException;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.string.parameterrefiners.GetFieldParameterRefiner;
import com.android.sched.schedulable.Constraint;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(need={OriginalNames.class})
public class GetDeclaredFieldsParameterRefiner
extends GetFieldParameterRefiner {
    @Nonnull
    private static final String GETDECLAREDFIELD_METHOD_NAME = "getDeclaredField";
    @Nonnull
    private final JMethodIdWide getFieldMethodId;

    public GetDeclaredFieldsParameterRefiner() {
        this.getFieldMethodId = this.javaLangClass.getMethodIdWide(GETDECLAREDFIELD_METHOD_NAME, Collections.singletonList(this.javaLangString), MethodKind.INSTANCE_VIRTUAL);
    }

    @Override
    public boolean isApplicable(@Nonnull JMethodCall call) throws JMethodLookupException {
        if (call.getReceiverType().isSameType(this.javaLangClass) && call.getMethodIdWide().equals(this.getFieldMethodId)) {
            assert (formatter.getName(call.getType()).equals("Ljava/lang/reflect/Field;"));
            return true;
        }
        return false;
    }

    @Override
    @CheckForNull
    protected JField lookupField(@Nonnull JDefinedClassOrInterface type, @Nonnull String fieldName) {
        JField foundField = null;
        try {
            foundField = MemberFinder.getDirectField(type, fieldName);
        }
        catch (MultipleFieldsFoundException multipleFieldsFoundException) {
            // empty catch block
        }
        return foundField;
    }
}

