/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string.parameterrefiners;

import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeStringLiteral;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.naming.TypeName;
import com.android.jack.lookup.JLookupException;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.string.parameterrefiners.CommonStringParameterRefiner;
import com.android.jack.transformations.ast.string.parameterrefiners.StringParameterRefiner;
import com.android.jack.util.NamingTools;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Transform;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(need={OriginalNames.class})
@Transform(add={JTypeStringLiteral.class})
public class ForNameParameterRefiner
extends CommonStringParameterRefiner
implements StringParameterRefiner {
    @Nonnull
    private static final String FORNAME_METHOD_NAME = "forName";
    @Nonnull
    private final JMethodIdWide forNameMethodId;

    public ForNameParameterRefiner() {
        this.forNameMethodId = this.javaLangClass.getMethodIdWide(FORNAME_METHOD_NAME, Collections.singletonList(this.javaLangString), MethodKind.STATIC);
    }

    @Override
    public boolean isApplicable(@Nonnull JMethodCall call) throws JMethodLookupException {
        if (call.getReceiverType().isSameType(this.javaLangClass) && call.getMethodIdWide().equals(this.forNameMethodId)) {
            assert (call.getType().isSameType(this.javaLangClass));
            return true;
        }
        return false;
    }

    @Override
    @CheckForNull
    public JStringLiteral getExpressionToRefine(@Nonnull JMethodCall call) {
        assert (call.getArgs().size() == 1);
        return this.getExpressionToRefine(call, 0);
    }

    @Override
    @CheckForNull
    public JAbstractStringLiteral getRefinedExpression(@Nonnull JMethodCall call, @Nonnull JStringLiteral paramToRefine) {
        String typeName = paramToRefine.getValue();
        JTypeStringLiteral strTypeLiteral = null;
        if (typeName.indexOf(47) != -1) {
            return null;
        }
        String typeSignature = typeName.charAt(0) == '[' ? NamingTools.getBinaryName(typeName) : NamingTools.getTypeSignatureName(typeName);
        if (NamingTools.isTypeDescriptor(typeSignature)) {
            try {
                JType type = this.lookup.getType(typeSignature);
                strTypeLiteral = new JTypeStringLiteral(paramToRefine.getSourceInfo(), type instanceof JArrayType ? TypeName.Kind.SRC_SIGNATURE : TypeName.Kind.SRC_QN, type);
                assert (typeName.equals(strTypeLiteral.getValue()));
            }
            catch (JLookupException jLookupException) {
                // empty catch block
            }
        }
        return strTypeLiteral;
    }
}

