/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.SideEffectOperation;
import com.android.jack.ir.ast.JAbsentArrayDimension;
import com.android.jack.ir.ast.JArrayRef;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnaryOperation;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.types.JIntegralType32;
import com.android.jack.ir.types.JNumericType;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.ImplicitBoxingAndUnboxing;
import com.android.jack.transformations.ast.ImplicitCast;
import com.android.jack.transformations.ast.InitInNewArray;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.collect.Lists;
import com.android.sched.util.config.ThreadConfig;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Make implicit casting, boxing and unboxing become explicit.")
@Name(value="TypeLegalizer")
@Constraint(no={SideEffectOperation.class, InitInNewArray.class, JSwitchStatement.SwitchWithEnum.class, JCastOperation.WithIntersectionType.class, JSwitchStatement.SwitchWithString.class})
@Transform(add={JMethodCall.class, JDynamicCastOperation.class}, remove={ImplicitCast.class, ImplicitBoxingAndUnboxing.class, ThreeAddressCodeForm.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
@Access(value=JSession.class)
public class TypeLegalizer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        TypeLegalizerVisitor rca = new TypeLegalizerVisitor(tr);
        rca.accept(method);
        tr.commit();
    }

    @Nonnull
    public static JExpression box(@Nonnull JExpression exprToBox, @Nonnull JClassOrInterface expectedType) {
        assert (exprToBox.getType() instanceof JPrimitiveType);
        JMethodCall boxMethodCall = TypeLegalizer.getBoxingCall(exprToBox, expectedType, (JPrimitiveType)exprToBox.getType());
        return boxMethodCall;
    }

    @Nonnull
    public static JExpression unbox(@Nonnull JExpression exprToUnbox, @Nonnull JClassOrInterface typeToUnbox) {
        JPrimitiveType returnType;
        String methodName;
        JPhantomLookup lookup = Jack.getSession().getPhantomLookup();
        if (typeToUnbox.isSameType(lookup.getType(CommonTypes.JAVA_LANG_BOOLEAN))) {
            methodName = "booleanValue";
            returnType = JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType();
        } else if (typeToUnbox.isSameType(lookup.getType(CommonTypes.JAVA_LANG_BYTE))) {
            methodName = "byteValue";
            returnType = JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType();
        } else if (typeToUnbox.isSameType(lookup.getType(CommonTypes.JAVA_LANG_CHAR))) {
            methodName = "charValue";
            returnType = JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType();
        } else if (typeToUnbox.isSameType(lookup.getType(CommonTypes.JAVA_LANG_SHORT))) {
            methodName = "shortValue";
            returnType = JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType();
        } else if (typeToUnbox.isSameType(lookup.getType(CommonTypes.JAVA_LANG_INTEGER))) {
            methodName = "intValue";
            returnType = JPrimitiveType.JPrimitiveTypeEnum.INT.getType();
        } else if (typeToUnbox.isSameType(lookup.getType(CommonTypes.JAVA_LANG_FLOAT))) {
            methodName = "floatValue";
            returnType = JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType();
        } else if (typeToUnbox.isSameType(lookup.getType(CommonTypes.JAVA_LANG_DOUBLE))) {
            methodName = "doubleValue";
            returnType = JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType();
        } else if (typeToUnbox.isSameType(lookup.getType(CommonTypes.JAVA_LANG_LONG))) {
            methodName = "longValue";
            returnType = JPrimitiveType.JPrimitiveTypeEnum.LONG.getType();
        } else {
            throw new AssertionError();
        }
        JMethodId unboxMethod = typeToUnbox.getOrCreateMethodId(methodName, Lists.create(), MethodKind.INSTANCE_VIRTUAL, returnType);
        assert (exprToUnbox.getType() == JNullType.INSTANCE || exprToUnbox.getType().isSameType(typeToUnbox));
        JMethodCall unboxMethodCall = new JMethodCall(exprToUnbox.getSourceInfo(), exprToUnbox, typeToUnbox, unboxMethod, unboxMethod.getMethodIdWide().canBeVirtual());
        return unboxMethodCall;
    }

    @Nonnull
    private static JExpression unbox(@Nonnull JExpression exprToUnbox) {
        JType typeToUnbox = exprToUnbox.getType();
        assert (!(typeToUnbox instanceof JPrimitiveType));
        assert (typeToUnbox instanceof JClassOrInterface);
        return TypeLegalizer.unbox(exprToUnbox, (JClassOrInterface)typeToUnbox);
    }

    @Nonnull
    private static JMethodCall getBoxingCall(@Nonnull JExpression exprToBox, @Nonnull JClassOrInterface type, @Nonnull JPrimitiveType pType) {
        JExpression arg;
        JPrimitiveType argType;
        JClassOrInterface wrapperType = type;
        JPhantomLookup lookup = Jack.getSession().getPhantomLookup();
        if (wrapperType.isSameType(lookup.getType(CommonTypes.JAVA_LANG_BOOLEAN))) {
            argType = JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType();
        } else if (wrapperType.isSameType(lookup.getType(CommonTypes.JAVA_LANG_BYTE))) {
            argType = JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType();
        } else if (wrapperType.isSameType(lookup.getType(CommonTypes.JAVA_LANG_CHAR))) {
            argType = JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType();
        } else if (wrapperType.isSameType(lookup.getType(CommonTypes.JAVA_LANG_SHORT))) {
            argType = JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType();
        } else if (wrapperType.isSameType(lookup.getType(CommonTypes.JAVA_LANG_INTEGER))) {
            argType = JPrimitiveType.JPrimitiveTypeEnum.INT.getType();
        } else if (wrapperType.isSameType(lookup.getType(CommonTypes.JAVA_LANG_FLOAT))) {
            argType = JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType();
        } else if (wrapperType.isSameType(lookup.getType(CommonTypes.JAVA_LANG_DOUBLE))) {
            argType = JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType();
        } else if (wrapperType.isSameType(lookup.getType(CommonTypes.JAVA_LANG_LONG))) {
            argType = JPrimitiveType.JPrimitiveTypeEnum.LONG.getType();
        } else {
            argType = pType;
            switch (pType.getPrimitiveTypeEnum()) {
                case BOOLEAN: {
                    wrapperType = lookup.getClass(CommonTypes.JAVA_LANG_BOOLEAN);
                    break;
                }
                case BYTE: {
                    wrapperType = lookup.getClass(CommonTypes.JAVA_LANG_BYTE);
                    break;
                }
                case CHAR: {
                    wrapperType = lookup.getClass(CommonTypes.JAVA_LANG_CHAR);
                    break;
                }
                case SHORT: {
                    wrapperType = lookup.getClass(CommonTypes.JAVA_LANG_SHORT);
                    break;
                }
                case INT: {
                    wrapperType = lookup.getClass(CommonTypes.JAVA_LANG_INTEGER);
                    break;
                }
                case FLOAT: {
                    wrapperType = lookup.getClass(CommonTypes.JAVA_LANG_FLOAT);
                    break;
                }
                case DOUBLE: {
                    wrapperType = lookup.getClass(CommonTypes.JAVA_LANG_DOUBLE);
                    break;
                }
                case LONG: {
                    wrapperType = lookup.getClass(CommonTypes.JAVA_LANG_LONG);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        JMethodId methodId = wrapperType.getOrCreateMethodId("valueOf", Lists.create(argType), MethodKind.STATIC, wrapperType);
        JMethodCall boxMethodCall = new JMethodCall(exprToBox.getSourceInfo(), null, wrapperType, methodId, methodId.getMethodIdWide().canBeVirtual());
        List<JType> paramTypes = methodId.getMethodIdWide().getParamTypes();
        assert (paramTypes.size() == 1);
        JType paramType = paramTypes.get(0);
        JType exprToBoxType = exprToBox.getType();
        if (exprToBoxType instanceof JNumericType && !paramType.isSameType(exprToBoxType)) {
            assert (paramType instanceof JNumericType);
            arg = new JDynamicCastOperation(exprToBox.getSourceInfo(), exprToBox, paramType);
        } else {
            arg = exprToBox;
        }
        boxMethodCall.addArg(arg);
        return boxMethodCall;
    }

    static class TypeLegalizerVisitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        TypeLegalizerVisitor(@Nonnull TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public void endVisit(@Nonnull JReturnStatement returnStatement) {
            JExpression returnExpr = returnStatement.getExpr();
            if (returnExpr != null) {
                JType expectedType = returnStatement.getParent(JMethod.class).getType();
                this.castIfNeeded(this.maybeBoxOrUnbox(returnExpr, expectedType), expectedType);
            }
            super.endVisit(returnStatement);
        }

        @Override
        public void endVisit(@Nonnull JForStatement forStmt) {
            this.maybeUnbox(forStmt.getTestExpr());
            super.endVisit(forStmt);
        }

        @Override
        public void endVisit(@Nonnull JWhileStatement whileStmt) {
            this.maybeUnbox(whileStmt.getTestExpr());
            super.endVisit(whileStmt);
        }

        @Override
        public void endVisit(@Nonnull JDoStatement doStmt) {
            this.maybeUnbox(doStmt.getTestExpr());
            super.endVisit(doStmt);
        }

        @Override
        public void endVisit(@Nonnull JConditionalExpression conditional) {
            this.maybeUnbox(conditional.getIfTest());
            JType conditionalType = conditional.getType();
            this.castIfNeeded(this.maybeBoxOrUnbox(conditional.getThenExpr(), conditionalType), conditionalType);
            this.castIfNeeded(this.maybeBoxOrUnbox(conditional.getElseExpr(), conditionalType), conditionalType);
            super.endVisit(conditional);
        }

        @Override
        public void endVisit(@Nonnull JIfStatement ifStmt) {
            this.maybeUnbox(ifStmt.getIfExpr());
            super.endVisit(ifStmt);
        }

        @Override
        public void endVisit(@Nonnull JSwitchStatement switchStmt) {
            this.maybeUnbox(switchStmt.getExpr());
            super.endVisit(switchStmt);
        }

        @Override
        public void endVisit(@Nonnull JDynamicCastOperation cast) {
            JExpression expr = cast.getExpr();
            if (this.needNarrowing(cast.getExpr().getType()) && cast.getType() instanceof JPrimitiveType) {
                assert (cast.getType() != JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
                JDynamicCastOperation castToWrapperType = new JDynamicCastOperation(expr.getSourceInfo(), expr, ((JPrimitiveType)cast.getType()).getWrapperType());
                this.tr.append(new Replace(expr, castToWrapperType));
                expr = castToWrapperType;
            }
            this.maybeBoxOrUnbox(expr, cast.getType());
            super.endVisit(cast);
        }

        private boolean needNarrowing(@Nonnull JType type) {
            return type instanceof JReferenceType && !type.isSameType(JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType().getWrapperType()) && !type.isSameType(JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType().getWrapperType()) && !type.isSameType(JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType().getWrapperType()) && !type.isSameType(JPrimitiveType.JPrimitiveTypeEnum.DOUBLE.getType().getWrapperType()) && !type.isSameType(JPrimitiveType.JPrimitiveTypeEnum.FLOAT.getType().getWrapperType()) && !type.isSameType(JPrimitiveType.JPrimitiveTypeEnum.INT.getType().getWrapperType()) && !type.isSameType(JPrimitiveType.JPrimitiveTypeEnum.LONG.getType().getWrapperType()) && !type.isSameType(JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType().getWrapperType());
        }

        @Override
        public void endVisit(@Nonnull JBinaryOperation binary) {
            JExpression rhs = binary.getRhs();
            JType rhsType = rhs.getType();
            JExpression lhs = binary.getLhs();
            JType lhsType = lhs.getType();
            switch (binary.getOp()) {
                case CONCAT: 
                case ASG_CONCAT: 
                case ASG_ADD: 
                case ASG_DIV: 
                case ASG_MOD: 
                case ASG_MUL: 
                case ASG_SUB: 
                case ASG_BIT_AND: 
                case ASG_BIT_OR: 
                case ASG_BIT_XOR: 
                case ASG_SHL: 
                case ASG_SHR: 
                case ASG_SHRU: {
                    break;
                }
                case ASG: {
                    JExpression castTo = this.maybeBoxOrUnbox(rhs, lhsType);
                    if (!(lhsType instanceof JNumericType)) break;
                    this.castIfNeeded(castTo, lhsType);
                    break;
                }
                case SHL: 
                case SHR: 
                case SHRU: {
                    this.castIfNeeded(this.maybeUnbox(lhs), binary.getType());
                    this.castIfNeeded(this.maybeUnbox(rhs), JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
                    break;
                }
                case BIT_AND: 
                case BIT_OR: 
                case BIT_XOR: 
                case AND: 
                case OR: 
                case ADD: 
                case DIV: 
                case MOD: 
                case MUL: 
                case SUB: {
                    JType expectedType = binary.getType();
                    this.castIfNeeded(this.maybeUnbox(lhs), expectedType);
                    this.castIfNeeded(this.maybeUnbox(rhs), expectedType);
                    break;
                }
                case GT: 
                case GTE: 
                case LT: 
                case LTE: {
                    JType expectedType = JPrimitiveType.getBinaryPromotionType(lhsType, rhsType);
                    this.castIfNeeded(this.maybeUnbox(lhs), expectedType);
                    this.castIfNeeded(this.maybeUnbox(rhs), expectedType);
                    break;
                }
                case EQ: 
                case NEQ: {
                    if (lhsType instanceof JNumericType || rhsType instanceof JNumericType) {
                        JType expectedType = JPrimitiveType.getBinaryPromotionType(lhsType, rhsType);
                        this.castIfNeeded(this.maybeUnbox(lhs), expectedType);
                        this.castIfNeeded(this.maybeUnbox(rhs), expectedType);
                        break;
                    }
                    if (rhsType != JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType() && lhsType != JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType()) break;
                    this.maybeUnbox(lhs);
                    this.maybeUnbox(rhs);
                }
            }
            super.endVisit(binary);
        }

        @Override
        public void endVisit(@Nonnull JFieldInitializer init) {
            JExpression initializer = init.getInitializer();
            JType expectedType = init.getFieldRef().getType();
            this.castIfNeeded(this.maybeBoxOrUnbox(initializer, expectedType), expectedType);
            super.endVisit(init);
        }

        @Override
        public void endVisit(@Nonnull JPolymorphicMethodCall polymorphicMethodCall) {
        }

        @Override
        public void endVisit(@Nonnull JMethodCall call) {
            List<JExpression> args = call.getArgs();
            List<JType> parameterTypes = call.getMethodIdWide().getParamTypes();
            assert (args.size() == parameterTypes.size());
            Iterator<JType> paramTypeIterator = parameterTypes.iterator();
            for (JExpression jExpression : args) {
                JType expectedType = paramTypeIterator.next();
                this.castIfNeeded(this.maybeBoxOrUnbox(jExpression, expectedType), expectedType);
            }
            super.endVisit(call);
        }

        @Override
        public void endVisit(@Nonnull JNewArray newArray) {
            for (JExpression dimension : newArray.getDims()) {
                if (dimension instanceof JAbsentArrayDimension) continue;
                JExpression newDimension = dimension;
                if (!(dimension.getType() instanceof JPrimitiveType)) {
                    newDimension = TypeLegalizer.unbox(dimension);
                    this.tr.append(new Replace(dimension, newDimension));
                    assert (newDimension.getType() instanceof JIntegralType32);
                }
                this.castIfNeeded(newDimension, JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
            }
            assert (newArray.getInitializers().isEmpty() || newArray.hasConstantInitializer());
            super.endVisit(newArray);
        }

        @Override
        public void endVisit(@Nonnull JArrayRef arrayRef) {
            JExpression indexExpr = arrayRef.getIndexExpr();
            JExpression unboxedExpr = this.maybeUnbox(indexExpr);
            assert (unboxedExpr.getType() instanceof JIntegralType32);
            this.castIfNeeded(unboxedExpr, JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
            super.endVisit(arrayRef);
        }

        @Override
        public void endVisit(@Nonnull JUnaryOperation unary) {
            switch (unary.getOp()) {
                case DEC: 
                case INC: 
                case NOT: 
                case BIT_NOT: 
                case NEG: {
                    this.castIfNeeded(this.maybeUnbox(unary.getArg()), unary.getType());
                }
            }
            super.endVisit(unary);
        }

        @Nonnull
        private JExpression maybeUnbox(@Nonnull JExpression expr) {
            JExpression unboxedExpr = expr;
            if (!(expr.getType() instanceof JPrimitiveType)) {
                unboxedExpr = TypeLegalizer.unbox(expr);
                this.tr.append(new Replace(expr, unboxedExpr));
            }
            return unboxedExpr;
        }

        @Nonnull
        private JExpression maybeBoxOrUnbox(@Nonnull JExpression expr, @Nonnull JType expectedType) {
            JExpression boxUnboxExpr = expr;
            JType type = expr.getType();
            if (!(expectedType instanceof JPrimitiveType) && type instanceof JPrimitiveType) {
                assert (expectedType instanceof JClassOrInterface);
                boxUnboxExpr = TypeLegalizer.box(expr, (JClassOrInterface)expectedType);
                this.tr.append(new Replace(expr, boxUnboxExpr));
            } else if (expectedType instanceof JPrimitiveType && !(type instanceof JPrimitiveType)) {
                boxUnboxExpr = TypeLegalizer.unbox(expr);
                this.tr.append(new Replace(expr, boxUnboxExpr));
            }
            return boxUnboxExpr;
        }

        private void castIfNeeded(@Nonnull JExpression exprToCast, @Nonnull JType expectedType) {
            if (expectedType instanceof JNumericType && !exprToCast.getType().isSameType(expectedType)) {
                this.tr.append(new Replace(exprToCast, new JDynamicCastOperation(exprToCast.getSourceInfo(), exprToCast, expectedType)));
            }
        }
    }
}

