/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.Options;
import com.android.jack.config.id.JavaVersionPropertyId;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JEqOperation;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JNeqOperation;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThrowStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfoFactory;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.reporting.Reporter;
import com.android.jack.scheduling.feature.SourceVersion7;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.TransformationException;
import com.android.jack.transformations.ast.MissingJavaSupportException;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import java.util.Collections;
import javax.annotation.Nonnull;

@Description(value="Generates the code that will handle auto-closeable resources in try-with-resourcesstatements.")
@Name(value="TryWithResourcesTransformer")
@Constraint(need={JTryStatement.class, JTryStatement.TryWithResourcesForm.class})
@Transform(add={JTryStatement.class, JCatchBlock.class, JBlock.class, JLocalRef.class, JAsgOperation.NonReusedAsg.class, JNullLiteral.class, JExpressionStatement.class, JEqOperation.class, JNeqOperation.class, JMethodCall.class, JIfStatement.class, JThrowStatement.class}, remove={JTryStatement.TryWithResourcesForm.class})
@Use(value={LocalVarCreator.class, SourceInfoFactory.class})
@Support(value={SourceVersion7.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
@ExclusiveAccess(value=JSession.class)
public class TryWithResourcesTransformer
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final SourceInfoFactory sourceInfoFactory = Jack.getSession().getSourceInfoFactory();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest request = new TransformationRequest(method);
        new Visitor(method, new LocalVarCreator(method, "$twr"), request).accept(method);
        request.commit();
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethodBody currentMethodBody;
        @Nonnull
        private final LocalVarCreator localVarCreator;
        @Nonnull
        private final TransformationRequest request;
        @Nonnull
        private static final String AUTO_CLOSEABLE_SIGNATURE = "Ljava/lang/AutoCloseable;";
        @Nonnull
        private static final String CLOSE_METHOD_NAME = "close";
        @Nonnull
        private static final String THROWABLE_SIGNATURE = "Ljava/lang/Throwable;";
        @Nonnull
        private static final String ADD_SUPPRESSED_METHOD_NAME = "addSuppressed";

        public Visitor(@Nonnull JMethod method, @Nonnull LocalVarCreator localVarCreator, TransformationRequest request) {
            JMethodBody body = (JMethodBody)method.getBody();
            assert (body != null);
            this.currentMethodBody = body;
            this.localVarCreator = localVarCreator;
            this.request = request;
        }

        @Override
        public void endVisit(@Nonnull JTryStatement x) {
            if (x.getResourcesDeclarations().size() > 0) {
                JMethodId addSuppressedMethodId;
                JMethodId closeMethodId;
                SourceInfo trySourceInfo = x.getSourceInfo();
                SourceInfo endOfTrySourceInfos = TryWithResourcesTransformer.this.sourceInfoFactory.create(trySourceInfo.getEndLine(), trySourceInfo.getEndLine(), trySourceInfo);
                SourceInfo firstLineSourceInfos = TryWithResourcesTransformer.this.sourceInfoFactory.create(trySourceInfo.getStartLine(), trySourceInfo.getStartLine(), trySourceInfo);
                JBlock finalTryBlock = new JBlock(trySourceInfo);
                JClass throwableClass = Jack.getSession().getPhantomLookup().getClass(THROWABLE_SIGNATURE);
                JLocal exceptionToThrow = this.localVarCreator.createTempLocal(throwableClass, firstLineSourceInfos, this.request);
                JAsgOperation assign = new JAsgOperation(firstLineSourceInfos, exceptionToThrow.makeRef(firstLineSourceInfos), new JNullLiteral(firstLineSourceInfos));
                finalTryBlock.addStmt(new JExpressionStatement(firstLineSourceInfos, assign));
                for (JStatement resInit : x.getResourcesDeclarations()) {
                    JAsgOperation asgOp = (JAsgOperation)((JExpressionStatement)resInit).getExpr();
                    JLocal resourceLocal = ((JLocalRef)asgOp.getLhs()).getLocal();
                    assign = new JAsgOperation(firstLineSourceInfos, resourceLocal.makeRef(firstLineSourceInfos), new JNullLiteral(firstLineSourceInfos));
                    finalTryBlock.addStmt(new JExpressionStatement(firstLineSourceInfos, assign));
                }
                JBlock tryBlock = x.getTryBlock();
                JBlock finallyBlock = new JBlock(endOfTrySourceInfos);
                for (int i = x.getResourcesDeclarations().size() - 1; i >= 0; --i) {
                    tryBlock.addStmt(0, x.getResourcesDeclarations().get(i));
                }
                JLocal tryException = new JLocal(endOfTrySourceInfos, NamingTools.getNonSourceConflictingName("twrExceptionInTry"), throwableClass, 4096, this.currentMethodBody);
                JCatchBlock catchBlock = new JCatchBlock(endOfTrySourceInfos, Collections.singletonList(throwableClass), tryException);
                JAsgOperation save = new JAsgOperation(endOfTrySourceInfos, exceptionToThrow.makeRef(endOfTrySourceInfos), tryException.makeRef(endOfTrySourceInfos));
                catchBlock.addStmt(new JExpressionStatement(endOfTrySourceInfos, save));
                catchBlock.addStmt(new JThrowStatement(endOfTrySourceInfos, exceptionToThrow.makeRef(endOfTrySourceInfos)));
                JTryStatement innerTry = new JTryStatement(endOfTrySourceInfos, Collections.emptyList(), tryBlock, Collections.singletonList(catchBlock), finallyBlock);
                try {
                    JInterface autoCloseableInterface = Jack.getSession().getPhantomLookup().getInterface(AUTO_CLOSEABLE_SIGNATURE);
                    closeMethodId = autoCloseableInterface.getMethodId(CLOSE_METHOD_NAME, Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
                    addSuppressedMethodId = throwableClass.getMethodId(ADD_SUPPRESSED_METHOD_NAME, Collections.singletonList(throwableClass), MethodKind.INSTANCE_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
                }
                catch (JMethodLookupException e) {
                    TransformationException transformationException = new TransformationException(new MissingJavaSupportException(JavaVersionPropertyId.JavaVersion.JAVA_7, e));
                    Jack.getSession().getReporter().report(Reporter.Severity.FATAL, transformationException);
                    throw new JackAbortException(transformationException);
                }
                for (int i = x.getResourcesDeclarations().size() - 1; i >= 0; --i) {
                    JStatement resInit = x.getResourcesDeclarations().get(i);
                    JAsgOperation asgOp = (JAsgOperation)((JExpressionStatement)resInit).getExpr();
                    JLocal resourceLocal = ((JLocalRef)asgOp.getLhs()).getLocal();
                    JNeqOperation isNotNull = new JNeqOperation(endOfTrySourceInfos, resourceLocal.makeRef(endOfTrySourceInfos), new JNullLiteral(endOfTrySourceInfos));
                    JMethodCall closeCall = new JMethodCall(endOfTrySourceInfos, resourceLocal.makeRef(endOfTrySourceInfos), (JClassOrInterface)resourceLocal.getType(), closeMethodId, true);
                    JBlock thenBlock = new JBlock(endOfTrySourceInfos);
                    thenBlock.addStmt(new JExpressionStatement(endOfTrySourceInfos, closeCall));
                    JIfStatement ifStmt = new JIfStatement(endOfTrySourceInfos, isNotNull, thenBlock, null);
                    JBlock tryBlockAroundClose = new JBlock(endOfTrySourceInfos);
                    JLocal exceptionThrownByClose = new JLocal(endOfTrySourceInfos, NamingTools.getNonSourceConflictingName("twrExceptionThrownByClose_" + i), throwableClass, 4096, this.currentMethodBody);
                    catchBlock = new JCatchBlock(endOfTrySourceInfos, Collections.singletonList(throwableClass), exceptionThrownByClose);
                    tryBlockAroundClose.addStmt(ifStmt);
                    JTryStatement tryClose = new JTryStatement(endOfTrySourceInfos, Collections.emptyList(), tryBlockAroundClose, Collections.singletonList(catchBlock), null);
                    finallyBlock.addStmt(tryClose);
                    JEqOperation isNull = new JEqOperation(endOfTrySourceInfos, exceptionToThrow.makeRef(endOfTrySourceInfos), new JNullLiteral(endOfTrySourceInfos));
                    thenBlock = new JBlock(endOfTrySourceInfos);
                    asgOp = new JAsgOperation(endOfTrySourceInfos, exceptionToThrow.makeRef(endOfTrySourceInfos), exceptionThrownByClose.makeRef(endOfTrySourceInfos));
                    thenBlock.addStmt(new JExpressionStatement(endOfTrySourceInfos, asgOp));
                    JBlock callSuppressBlock = new JBlock(endOfTrySourceInfos);
                    JNeqOperation ifExceptionsDiffer = new JNeqOperation(endOfTrySourceInfos, exceptionToThrow.makeRef(endOfTrySourceInfos), exceptionThrownByClose.makeRef(endOfTrySourceInfos));
                    JIfStatement elseIf = new JIfStatement(endOfTrySourceInfos, ifExceptionsDiffer, callSuppressBlock, null);
                    JMethodCall addSuppressCall = new JMethodCall(endOfTrySourceInfos, exceptionToThrow.makeRef(endOfTrySourceInfos), throwableClass, addSuppressedMethodId, closeMethodId.getMethodIdWide().canBeVirtual());
                    addSuppressCall.addArg(exceptionThrownByClose.makeRef(endOfTrySourceInfos));
                    callSuppressBlock.addStmt(new JExpressionStatement(endOfTrySourceInfos, addSuppressCall));
                    ifStmt = new JIfStatement(endOfTrySourceInfos, isNull, thenBlock, elseIf);
                    catchBlock.addStmt(ifStmt);
                }
                JThrowStatement throwStmt = new JThrowStatement(endOfTrySourceInfos, exceptionToThrow.makeRef(endOfTrySourceInfos));
                JNeqOperation ifNotNull = new JNeqOperation(endOfTrySourceInfos, exceptionToThrow.makeRef(endOfTrySourceInfos), new JNullLiteral(endOfTrySourceInfos));
                JIfStatement ifExceptionToThrow = new JIfStatement(endOfTrySourceInfos, ifNotNull, throwStmt, null);
                finallyBlock.addStmt(ifExceptionToThrow);
                finalTryBlock.addStmt(innerTry);
                this.request.append(new Replace(x.getTryBlock(), finalTryBlock));
            }
            x.setResourcesDeclarations(Collections.emptyList());
        }
    }
}

