/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JDoStatement;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Add implicit block to avoid specific management of stand alone statement.")
@Name(value="ImplicitBlocks")
@Transform(add={JBlock.class, NoImplicitBlock.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class ImplicitBlocks
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        ImplicitBlocksVisitor ibv = new ImplicitBlocksVisitor(tr);
        ibv.accept(method);
        tr.commit();
    }

    private static class ImplicitBlocksVisitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        public ImplicitBlocksVisitor(@Nonnull TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public boolean visit(@Nonnull JIfStatement ifStmt) {
            JStatement elseStmt;
            JStatement thenStmt = ifStmt.getThenStmt();
            if (!(thenStmt instanceof JBlock)) {
                this.moveIntoBLock(thenStmt);
            }
            if ((elseStmt = ifStmt.getElseStmt()) != null && !(elseStmt instanceof JBlock)) {
                this.moveIntoBLock(elseStmt);
            }
            return super.visit(ifStmt);
        }

        @Override
        public boolean visit(@Nonnull JLabeledStatement labeledStmt) {
            JStatement labelStmtBody = labeledStmt.getBody();
            if (!(labelStmtBody instanceof JBlock)) {
                this.moveIntoBLock(labelStmtBody);
            }
            return super.visit(labeledStmt);
        }

        @Override
        public boolean visit(@Nonnull JForStatement forStmt) {
            JBlock parentBlock;
            JNode parent;
            JStatement forBody = forStmt.getBody();
            if (!(forBody instanceof JBlock)) {
                this.moveIntoBLock(forBody);
            }
            if ((parent = forStmt.getParent()) instanceof JBlock && (parentBlock = (JBlock)parent).getStatements().size() != 1) {
                this.moveIntoBLock(forStmt);
            }
            return super.visit(forStmt);
        }

        @Override
        public boolean visit(@Nonnull JWhileStatement whileStmt) {
            JStatement whileBody = whileStmt.getBody();
            if (!(whileBody instanceof JBlock)) {
                this.moveIntoBLock(whileBody);
            }
            return super.visit(whileStmt);
        }

        @Override
        public boolean visit(@Nonnull JDoStatement doStmt) {
            JStatement doBody = doStmt.getBody();
            if (!(doBody instanceof JBlock)) {
                this.moveIntoBLock(doBody);
            }
            return super.visit(doStmt);
        }

        private void moveIntoBLock(@Nonnull JStatement stmt) {
            JBlock newBlock = new JBlock(stmt.getSourceInfo());
            newBlock.addStmt(stmt);
            this.tr.append(new Replace(stmt, newBlock));
        }
    }
}

