/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JAsgConcatOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JConcatOperation;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.collect.Lists;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Replace JConcatOperation by new StringBuilder.append([lhs]).append([rhs]).")
@Constraint(no={JAsgConcatOperation.class}, need={OriginalNames.class})
@Transform(remove={JConcatOperation.class, ThreeAddressCodeForm.class, NewInstanceRemoved.class}, add={JNewInstance.class, JMethodCall.class, JDynamicCastOperation.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class ConcatRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private static final String APPEND_METHOD_NAME = "append";
    @Nonnull
    private static final String STRING_BUILDER_SIGNATURE = "Ljava/lang/StringBuilder;";
    @Nonnull
    private static final String CHAR_SEQUENCE_SIGNATURE = "Ljava/lang/CharSequence;";
    @Nonnull
    private static final String STRING_BUILDER_CONSTRUCTOR_NAME = "<init>";
    @Nonnull
    private static final String TO_STRING = "toString";
    @Nonnull
    private final JClass jlo = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);
    @Nonnull
    private final JClass jls = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_STRING);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @CheckForNull
    private final JSession session = Jack.getSession();
    @CheckForNull
    private JClassOrInterface stringBuilder;
    @CheckForNull
    private JClassOrInterface charSequence;

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        Visitor visitor = new Visitor(method);
        visitor.accept(method);
    }

    @Nonnull
    private JClassOrInterface getStringBuilder() {
        if (this.stringBuilder == null) {
            assert (this.session != null);
            this.stringBuilder = (JClassOrInterface)this.session.getPhantomLookup().getType(STRING_BUILDER_SIGNATURE);
        }
        assert (this.stringBuilder != null);
        return this.stringBuilder;
    }

    @Nonnull
    private JClassOrInterface getCharSequence() {
        if (this.charSequence == null) {
            assert (this.session != null);
            this.charSequence = (JClassOrInterface)this.session.getPhantomLookup().getType(CHAR_SEQUENCE_SIGNATURE);
        }
        assert (this.charSequence != null);
        return this.charSequence;
    }

    @Nonnull
    private JMethodCall getCallToAppend(@Nonnull SourceInfo sourceInfo, @Nonnull JExpression stringBuilderInstance, @Nonnull JExpression toAppend) {
        JType elementType;
        JType appendArgType = elementType = toAppend.getType();
        assert (this.session != null);
        if (elementType instanceof JPrimitiveType) {
            JPrimitiveType.JPrimitiveTypeEnum primitiveType = ((JPrimitiveType)elementType).getPrimitiveTypeEnum();
            switch (primitiveType) {
                case BOOLEAN: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    break;
                }
                case BYTE: 
                case SHORT: {
                    toAppend = new JDynamicCastOperation(sourceInfo, toAppend, JPrimitiveType.JPrimitiveTypeEnum.INT.getType());
                    appendArgType = JPrimitiveType.JPrimitiveTypeEnum.INT.getType();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        } else if (elementType.isSameType(this.jls)) {
            appendArgType = this.jls;
        } else {
            JClassOrInterface charSequence = this.getCharSequence();
            assert (this.session != null);
            appendArgType = elementType == charSequence ? charSequence : this.jlo;
        }
        JClassOrInterface stringBuilder = this.getStringBuilder();
        JMethodId stringBuilderAppend = stringBuilder.getOrCreateMethodId(APPEND_METHOD_NAME, Lists.create(appendArgType), MethodKind.INSTANCE_VIRTUAL, stringBuilder);
        JMethodCall call = new JMethodCall(sourceInfo, stringBuilderInstance, stringBuilder, stringBuilderAppend, true);
        call.addArg(toAppend);
        return call;
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod method;

        public Visitor(JMethod method) {
            this.method = method;
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binary) {
            if (binary instanceof JConcatOperation) {
                TransformationRequest tr = new TransformationRequest(this.method);
                SourceInfo sourceInfo = binary.getSourceInfo();
                JNode binaryParent = binary.getParent();
                assert (binaryParent != null);
                if (this.isReplaceableAppend(binaryParent)) {
                    JMethodCall toReplace = (JMethodCall)binaryParent;
                    JExpression instance = toReplace.getInstance();
                    assert (instance != null);
                    JMethodCall appendLhs = ConcatRemover.this.getCallToAppend(sourceInfo, instance, binary.getLhs());
                    JMethodCall appendRhs = ConcatRemover.this.getCallToAppend(sourceInfo, appendLhs, binary.getRhs());
                    tr.append(new Replace(toReplace, appendRhs));
                } else {
                    JClassOrInterface stringBuilder = ConcatRemover.this.getStringBuilder();
                    JNewInstance instance = new JNewInstance(sourceInfo, stringBuilder, stringBuilder.getOrCreateMethodId(ConcatRemover.STRING_BUILDER_CONSTRUCTOR_NAME, Lists.create(), MethodKind.INSTANCE_NON_VIRTUAL, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()));
                    JMethodCall appendLhs = ConcatRemover.this.getCallToAppend(sourceInfo, instance, binary.getLhs());
                    JMethodCall appendRhs = ConcatRemover.this.getCallToAppend(sourceInfo, appendLhs, binary.getRhs());
                    JMethodId stringBuilderToString = stringBuilder.getOrCreateMethodId(ConcatRemover.TO_STRING, Lists.create(), MethodKind.INSTANCE_VIRTUAL, ConcatRemover.this.jls);
                    assert (ConcatRemover.this.session != null);
                    JMethodCall toString = new JMethodCall(sourceInfo, appendRhs, stringBuilder, stringBuilderToString, stringBuilderToString.getMethodIdWide().canBeVirtual());
                    tr.append(new Replace(binary, toString));
                }
                tr.commit();
            }
            return super.visit(binary);
        }

        private boolean isReplaceableAppend(@Nonnull JNode node) {
            if (node instanceof JMethodCall) {
                JMethodCall call = (JMethodCall)node;
                return call.getMethodName().equals(ConcatRemover.APPEND_METHOD_NAME) && call.getType().isSameType(ConcatRemover.this.getStringBuilder()) && call.getReceiverType().isSameType(ConcatRemover.this.getStringBuilder());
            }
            return false;
        }
    }
}

