/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.CompoundAssignment;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAddOperation;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JBinaryOperator;
import com.android.jack.ir.ast.JBitAndOperation;
import com.android.jack.ir.ast.JBitOrOperation;
import com.android.jack.ir.ast.JBitXorOperation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JConcatOperation;
import com.android.jack.ir.ast.JDivOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JModOperation;
import com.android.jack.ir.ast.JMulOperation;
import com.android.jack.ir.ast.JShlOperation;
import com.android.jack.ir.ast.JShrOperation;
import com.android.jack.ir.ast.JShruOperation;
import com.android.jack.ir.ast.JSubOperation;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.SideEffectExtractor;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Remove compound assignment operator.")
@Name(value="CompoundAssignmentRemover")
@Transform(add={JAddOperation.class, JBitAndOperation.class, JBitOrOperation.class, JBitXorOperation.class, JDivOperation.class, JMulOperation.class, JModOperation.class, JShlOperation.class, JShrOperation.class, JShruOperation.class, JSubOperation.class, JConcatOperation.class, JAsgOperation.class}, remove={CompoundAssignment.class, ThreeAddressCodeForm.class})
@Constraint(need={OriginalNames.class})
@Use(value={SideEffectExtractor.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class CompoundAssignmentRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private final JPhantomLookup phantomLookup = Jack.getSession().getPhantomLookup();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        JClass javaLangString = this.phantomLookup.getClass(CommonTypes.JAVA_LANG_STRING);
        TransformationRequest tr = new TransformationRequest(method);
        RemoveComplexAssignVisitor rca = new RemoveComplexAssignVisitor(tr, javaLangString);
        rca.accept(method);
        tr.commit();
    }

    private static class RemoveComplexAssignVisitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;
        @CheckForNull
        private SideEffectExtractor extractor;
        @Nonnull
        private final JClass javaLangString;

        private RemoveComplexAssignVisitor(@Nonnull TransformationRequest tr, @Nonnull JClass javaLangString) {
            this.tr = tr;
            this.javaLangString = javaLangString;
        }

        @Override
        public boolean visit(@Nonnull JMethod method) {
            JAbstractMethodBody body = method.getBody();
            if (body != null && body instanceof JMethodBody) {
                this.extractor = new SideEffectExtractor(new LocalVarCreator(method, "car"));
            }
            return super.visit(method);
        }

        @Override
        public void endVisit(@Nonnull JMethod x) {
            this.extractor = null;
            super.endVisit(x);
        }

        @Override
        public boolean visit(@Nonnull JBinaryOperation binary) {
            if (binary.isCompoundAssignment()) {
                SourceInfo binarySourceInfo = binary.getSourceInfo();
                JExpression binaryLhs = binary.getLhs();
                assert (this.extractor != null);
                JExpression binaryLhsCopy = this.extractor.copyWithoutSideEffects(binaryLhs, this.tr);
                JBinaryOperation newBinary = null;
                switch (binary.getOp()) {
                    case ASG_ADD: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.ADD, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_BIT_AND: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.BIT_AND, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_BIT_OR: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.BIT_OR, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_BIT_XOR: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.BIT_XOR, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_DIV: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.DIV, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_MOD: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.MOD, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_MUL: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.MUL, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_SHL: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.SHL, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_SHR: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.SHR, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_SHRU: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.SHRU, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_SUB: {
                        newBinary = JBinaryOperation.create(binarySourceInfo, JBinaryOperator.SUB, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    case ASG_CONCAT: {
                        newBinary = new JConcatOperation(binarySourceInfo, this.javaLangString, binaryLhsCopy, binary.getRhs());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.tr.append(new Replace(binary, new JAsgOperation(binarySourceInfo, binaryLhs, newBinary)));
            }
            return super.visit(binary);
        }
    }
}

