/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JLock;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JSynchronizedBlock;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JUnlock;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.JNodeLookup;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.ReportableException;
import com.android.jack.reporting.Reporter;
import com.android.jack.transformations.BoostLockedRegionPriorityFeature;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.PrependStatement;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.MethodNameCodec;
import com.android.jack.util.NamingTools;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Raise locked region priority for certain types of locks.")
@Constraint(need={JLock.class, JUnlock.class}, no={JSynchronizedBlock.class})
@Transform(add={JExpressionStatement.class, JMethodCall.class})
public class BoostLockedRegionPriority
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final JClass[] lockClass;
    @Nonnull
    private final JClass[] requestClass;
    @Nonnull
    private final JClass[] resetClass;
    @Nonnull
    private final JMethodId[] requestMethodId;
    @Nonnull
    private final JMethodId[] resetMethodId;
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    public BoostLockedRegionPriority() {
        List<String> classNames = ThreadConfig.get(BoostLockedRegionPriorityFeature.BOOST_LOCK_CLASSNAME);
        List<MethodNameCodec.MethodNameValue> requestMethodNameValues = ThreadConfig.get(BoostLockedRegionPriorityFeature.BOOST_LOCK_REQUEST_METHOD);
        List<MethodNameCodec.MethodNameValue> resetMethodNameValues = ThreadConfig.get(BoostLockedRegionPriorityFeature.BOOST_LOCK_RESET_METHOD);
        int totalLocks = classNames.size();
        if (totalLocks != requestMethodNameValues.size()) {
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new BadBoostLockedRegionPriorityMethods(BoostLockedRegionPriorityFeature.BOOST_LOCK_REQUEST_METHOD.getName(), totalLocks, requestMethodNameValues.size()));
        }
        if (totalLocks != resetMethodNameValues.size()) {
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new BadBoostLockedRegionPriorityMethods(BoostLockedRegionPriorityFeature.BOOST_LOCK_RESET_METHOD.getName(), totalLocks, resetMethodNameValues.size()));
        }
        this.lockClass = new JClass[totalLocks];
        this.resetClass = new JClass[totalLocks];
        this.requestClass = new JClass[totalLocks];
        this.requestMethodId = new JMethodId[totalLocks];
        this.resetMethodId = new JMethodId[totalLocks];
        JNodeLookup lookup = Jack.getSession().getLookup();
        for (int i = 0; i < totalLocks; ++i) {
            this.lockClass[i] = BoostLockedRegionPriority.getClassOrReportFailure(lookup, NamingTools.getTypeSignatureName(classNames.get(i)), BoostLockedRegionPriorityFeature.BOOST_LOCK_CLASSNAME.getName());
            this.requestClass[i] = BoostLockedRegionPriority.getClassOrReportFailure(lookup, NamingTools.getTypeSignatureName(requestMethodNameValues.get(i).getClassName()), BoostLockedRegionPriorityFeature.BOOST_LOCK_REQUEST_METHOD.getName());
            this.resetClass[i] = BoostLockedRegionPriority.getClassOrReportFailure(lookup, NamingTools.getTypeSignatureName(resetMethodNameValues.get(i).getClassName()), BoostLockedRegionPriorityFeature.BOOST_LOCK_RESET_METHOD.getName());
            this.requestMethodId[i] = BoostLockedRegionPriority.getStaticMethodOrReportFailure(this.requestClass[i], requestMethodNameValues.get(i).getMethodName(), BoostLockedRegionPriorityFeature.BOOST_LOCK_REQUEST_METHOD.getName());
            this.resetMethodId[i] = BoostLockedRegionPriority.getStaticMethodOrReportFailure(this.resetClass[i], resetMethodNameValues.get(i).getMethodName(), BoostLockedRegionPriorityFeature.BOOST_LOCK_RESET_METHOD.getName());
        }
    }

    private static JClass getClassOrReportFailure(JNodeLookup lookup, String name, String prop) {
        try {
            return lookup.getClass(name);
        }
        catch (Throwable e) {
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new BadBoostLockedRegionPriorityConfigurationException(prop, e));
            Jack.getSession().abortEventually();
            return null;
        }
    }

    private static JMethodId getStaticMethodOrReportFailure(JClass cls, String name, String prop) {
        try {
            return cls.getMethodId(name, Collections.emptyList(), MethodKind.STATIC, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
        }
        catch (Throwable e) {
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new BadBoostLockedRegionPriorityConfigurationException(prop, e));
            Jack.getSession().abortEventually();
            return null;
        }
    }

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        if (this.lockClass.length == 0) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(method, tr);
        visitor.accept(method);
        tr.commit();
    }

    private static void abortPass() {
        Jack.getSession().getReporter().report(Reporter.Severity.FATAL, new BadBoostLockedRegionPriorityState());
        Jack.getSession().abortEventually();
    }

    private static class BadBoostLockedRegionPriorityMethods
    implements Reportable {
        @Nonnull
        private final String methodName;
        @Nonnegative
        private final int numLocks;
        @Nonnegative
        private final int numMethods;

        public BadBoostLockedRegionPriorityMethods(String methodName, int numLocks, int numMethods) {
            this.methodName = methodName;
            this.numLocks = numLocks;
            this.numMethods = numMethods;
        }

        @Override
        public String getMessage() {
            return "Number of methods in " + this.methodName + " is " + this.numMethods + " but number of locks is " + this.numLocks;
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }
    }

    private static class BadBoostLockedRegionPriorityState
    implements Reportable {
        private BadBoostLockedRegionPriorityState() {
        }

        @Override
        public String getMessage() {
            return "Cannot perform BoostLockedRegionPriority. This is likely due to a library coming from a Jar, which is not supported.";
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }
    }

    private static class BadBoostLockedRegionPriorityConfigurationException
    extends ReportableException {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final String prop;

        public BadBoostLockedRegionPriorityConfigurationException(@Nonnull String prop, @Nonnull Throwable cause) {
            super(cause);
            this.prop = prop;
        }

        @Override
        public String getMessage() {
            return this.getCause().getMessage() + " needed by property " + this.prop;
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.ERROR;
        }
    }

    private class Visitor
    extends JVisitor {
        @Nonnull
        private final JMethod method;
        @Nonnull
        private final TransformationRequest tr;

        public Visitor(@Nonnull JMethod method, TransformationRequest tr) {
            this.method = method;
            this.tr = tr;
        }

        @Override
        public void endVisit(@Nonnull JLock jLock) {
            JStatement next;
            assert (BoostLockedRegionPriority.this.lockClass != null);
            int lockIndex = -1;
            for (int i = 0; i < BoostLockedRegionPriority.this.lockClass.length; ++i) {
                if (!jLock.getLockExpr().getType().isSameType(BoostLockedRegionPriority.this.lockClass[i])) continue;
                lockIndex = i;
                break;
            }
            if (lockIndex == -1) {
                return;
            }
            JStatementList list = (JStatementList)jLock.getParent();
            assert (list != null);
            int index = list.getStatements().indexOf(jLock) + 1;
            if (index >= list.getStatements().size()) {
                BoostLockedRegionPriority.abortPass();
            }
            if (!((next = list.getStatements().get(index)) instanceof JTryStatement)) {
                BoostLockedRegionPriority.abortPass();
                return;
            }
            JTryStatement jTry = (JTryStatement)next;
            JBlock finallyBlock = jTry.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            this.tr.append(new PrependStatement(jTry.getTryBlock(), this.makeRequestCall(lockIndex, jLock.getSourceInfo())));
            this.tr.append(new AppendStatement(finallyBlock, this.makeResetCall(lockIndex, jLock.getSourceInfo())));
        }

        @Nonnull
        private JExpressionStatement makeRequestCall(int lockIndex, SourceInfo info) {
            assert (BoostLockedRegionPriority.this.lockClass[lockIndex] != null && BoostLockedRegionPriority.this.requestClass[lockIndex] != null && BoostLockedRegionPriority.this.requestMethodId[lockIndex] != null);
            return new JExpressionStatement(info, new JMethodCall(info, null, BoostLockedRegionPriority.this.requestClass[lockIndex], BoostLockedRegionPriority.this.requestMethodId[lockIndex], false));
        }

        @Nonnull
        private JExpressionStatement makeResetCall(int lockIndex, SourceInfo info) {
            assert (BoostLockedRegionPriority.this.lockClass[lockIndex] != null && BoostLockedRegionPriority.this.requestClass[lockIndex] != null && BoostLockedRegionPriority.this.requestMethodId[lockIndex] != null);
            return new JExpressionStatement(info, new JMethodCall(info, null, BoostLockedRegionPriority.this.resetClass[lockIndex], BoostLockedRegionPriority.this.resetMethodId[lockIndex], false));
        }
    }
}

