/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations;

import com.android.jack.Options;
import com.android.jack.api.v01.impl.Api01Feature;
import com.android.jack.api.v02.impl.Api02Feature;
import com.android.jack.api.v03.impl.Api03Feature;
import com.android.jack.backend.dex.EnsureAndroidCompatibility;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.InvalidDefaultBridgeInInterfaceRemoved;
import com.android.jack.transformations.lambda.DefaultBridgeIntoInterface;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.AndroidApiLevel;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Remove bridges from interfaces based on the value of the minumun Android API level")
@Support(value={EnsureAndroidCompatibility.class})
@Constraint(need={DefaultBridgeIntoInterface.class})
@Transform(add={InvalidDefaultBridgeInInterfaceRemoved.class})
@Synchronized
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
@Filter(value={TypeWithoutPrebuiltFilter.class}, unlessOne={Api01Feature.class, Api02Feature.class, Api03Feature.class})
public class BridgeInInterfaceRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final AndroidApiLevel androidMinApiLevel = ThreadConfig.get(Options.ANDROID_MIN_API_LEVEL);

    @Override
    public void run(@Nonnull JMethod method) {
        if (this.androidMinApiLevel.getReleasedLevel() < AndroidApiLevel.ReleasedLevel.N.getLevel() && method.getEnclosingType() instanceof JInterface && method.isBridge()) {
            TransformationRequest tr = new TransformationRequest(method.getEnclosingType());
            tr.append(new Remove(method));
            tr.commit();
        }
    }
}

