/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.merger;

import com.android.jack.dx.dex.file.ValueEncoder;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.io.EncodedValueCodec;
import com.android.jack.dx.io.EncodedValueReader;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstBoolean;
import com.android.jack.dx.rop.cst.CstByte;
import com.android.jack.dx.rop.cst.CstChar;
import com.android.jack.dx.rop.cst.CstDouble;
import com.android.jack.dx.rop.cst.CstFloat;
import com.android.jack.dx.rop.cst.CstInteger;
import com.android.jack.dx.rop.cst.CstKnownNull;
import com.android.jack.dx.rop.cst.CstLiteralBits;
import com.android.jack.dx.rop.cst.CstLong;
import com.android.jack.dx.rop.cst.CstShort;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.util.ByteInput;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class MergerTools {
    @Nonnull
    public static Constant createConstant(@Nonnull ByteInput in, @Nonnegative int type, int arg) {
        CstLiteralBits cst;
        switch (ValueEncoder.ValueType.getValueType(type)) {
            case VALUE_BYTE: {
                cst = CstByte.make((byte)EncodedValueCodec.readSignedInt(in, arg));
                break;
            }
            case VALUE_CHAR: {
                cst = CstChar.make((char)EncodedValueCodec.readUnsignedInt(in, arg, false));
                break;
            }
            case VALUE_SHORT: {
                cst = CstShort.make((short)EncodedValueCodec.readSignedInt(in, arg));
                break;
            }
            case VALUE_INT: {
                cst = CstInteger.make(EncodedValueCodec.readSignedInt(in, arg));
                break;
            }
            case VALUE_LONG: {
                cst = CstLong.make(EncodedValueCodec.readSignedLong(in, arg));
                break;
            }
            case VALUE_FLOAT: {
                cst = CstFloat.make(EncodedValueCodec.readUnsignedInt(in, arg, true));
                break;
            }
            case VALUE_DOUBLE: {
                cst = CstDouble.make(EncodedValueCodec.readUnsignedLong(in, arg, true));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return cst;
    }

    protected static final class ConstantValueArrayBuilder
    extends EncodedValueReader {
        @Nonnegative
        private int cstIndex = 0;
        @CheckForNull
        private Constant[] constantValues;

        public ConstantValueArrayBuilder(@Nonnull DexBuffer dex, @Nonnull ByteInput in) {
            super(dex, in);
        }

        @Nonnegative
        public int getCstSize() {
            assert (this.constantValues != null);
            return this.constantValues.length;
        }

        @Nonnull
        public Constant getCstValueAtIdx(@Nonnegative int idx) {
            assert (this.constantValues != null);
            assert (this.constantValues[idx] != null);
            return this.constantValues[idx];
        }

        @Override
        protected void visitArray(int size) {
            this.constantValues = new Constant[size];
        }

        @Override
        protected void visitEncodedBoolean(int argAndType) {
            int arg = (argAndType & 0xE0) >> 5;
            this.addConstant(CstBoolean.make(arg));
        }

        @Override
        protected void visitString(int index) {
            this.addConstant(new CstString(this.dexBuffer.strings().get(index)));
        }

        @Override
        protected void visitEncodedNull(int argAndType) {
            this.addConstant(CstKnownNull.THE_ONE);
        }

        @Override
        protected void visitAnnotation(int typeIndex, int size) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitAnnotationName(int nameIndex) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitAnnotationValue(int argAndType) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitArrayValue(int argAndType) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitField(int type, int index) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitMethod(int index) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitType(int index) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitMethodType(int index) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitPrimitive(int type, int arg, int size) {
            this.addConstant(MergerTools.createConstant(this.in, type, arg));
        }

        private void addConstant(@Nonnull Constant cst) {
            assert (this.constantValues != null);
            this.constantValues[this.cstIndex++] = cst;
        }
    }
}

