/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.merger;

import com.android.jack.dx.dex.file.AnnotationItem;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.dex.file.ValueEncoder;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.io.EncodedValueReader;
import com.android.jack.dx.io.FieldId;
import com.android.jack.dx.rop.annotation.Annotation;
import com.android.jack.dx.rop.annotation.AnnotationVisibility;
import com.android.jack.dx.rop.annotation.Annotations;
import com.android.jack.dx.rop.annotation.AnnotationsList;
import com.android.jack.dx.rop.annotation.NameValuePair;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstAnnotation;
import com.android.jack.dx.rop.cst.CstArray;
import com.android.jack.dx.rop.cst.CstBoolean;
import com.android.jack.dx.rop.cst.CstEnumRef;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstIndexMap;
import com.android.jack.dx.rop.cst.CstKnownNull;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.dx.util.ByteInput;
import com.android.jack.dx.util.Leb128Utils;
import com.android.jack.tools.merger.MergerTools;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class AnnotationMerger
extends MergerTools {
    @CheckForNull
    private CstIndexMap cstIndexMap;

    public void mergeAnnotationDirectory(@Nonnull DexBuffer dex, @Nonnegative int annotationDirectoryOffset, @Nonnull ClassDefItem newClassDef, @Nonnull CstIndexMap cstIndexMap) {
        CstMethodRef cstMethodRef;
        int i;
        this.cstIndexMap = cstIndexMap;
        DexBuffer.Section directoryIn = dex.open(annotationDirectoryOffset);
        int classAnnotationSetOffset = directoryIn.readInt();
        if (classAnnotationSetOffset != 0) {
            newClassDef.setClassAnnotations(this.readAnnotationSet(dex, classAnnotationSetOffset));
        }
        int fieldsSize = directoryIn.readInt();
        int methodsSize = directoryIn.readInt();
        int parameterListSize = directoryIn.readInt();
        for (i = 0; i < fieldsSize; ++i) {
            CstFieldRef cstFieldRef = cstIndexMap.getCstFieldRef(directoryIn.readInt());
            newClassDef.addFieldAnnotations(cstFieldRef, this.readAnnotationSet(dex, directoryIn.readInt()));
        }
        for (i = 0; i < methodsSize; ++i) {
            cstMethodRef = cstIndexMap.getCstMethodRef(directoryIn.readInt());
            newClassDef.addMethodAnnotations(cstMethodRef, this.readAnnotationSet(dex, directoryIn.readInt()));
        }
        for (i = 0; i < parameterListSize; ++i) {
            cstMethodRef = cstIndexMap.getCstMethodRef(directoryIn.readInt());
            newClassDef.addParameterAnnotations(cstMethodRef, this.readAnnotationSetRefList(dex, directoryIn.readInt()));
        }
    }

    @Nonnull
    private AnnotationsList readAnnotationSetRefList(@Nonnull DexBuffer dex, @Nonnegative int annotationSetRefListOffset) {
        DexBuffer.Section annotationSetRefListIn = dex.open(annotationSetRefListOffset);
        int parameterCount = annotationSetRefListIn.readInt();
        AnnotationsList parameterAnnotationList = new AnnotationsList(parameterCount);
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            Annotations annotations = this.readAnnotationSet(dex, annotationSetRefListIn.readInt());
            annotations.setImmutable();
            parameterAnnotationList.set(paramIdx, annotations);
        }
        return parameterAnnotationList;
    }

    @Nonnull
    private Annotations readAnnotationSet(@Nonnull DexBuffer dex, @Nonnegative int annotationSetOffset) {
        DexBuffer.Section annotationSetIn = dex.open(annotationSetOffset);
        int size = annotationSetIn.readInt();
        Annotations annotations = new Annotations();
        for (int j = 0; j < size; ++j) {
            annotations.add(this.readAnnotationItem(dex, annotationSetIn.readInt()));
        }
        return annotations;
    }

    @Nonnull
    private Annotation readAnnotationItem(@Nonnull DexBuffer dex, @Nonnegative int annotationItemOffset) {
        DexBuffer.Section annotationItemIn = dex.open(annotationItemOffset);
        com.android.jack.dx.io.Annotation ioAnnotation = annotationItemIn.readAnnotation();
        assert (this.cstIndexMap != null);
        Type annotationType = this.cstIndexMap.getType(ioAnnotation.getTypeIndex());
        Annotation a = new Annotation(annotationType, AnnotationItem.getAnnotationVisibility(ioAnnotation.getVisibility()));
        for (int i = 0; i < ioAnnotation.getValues().length; ++i) {
            AnnotationValueReader avr = new AnnotationValueReader(dex, ioAnnotation.getValues()[i].asByteInput());
            avr.readValue();
            assert (this.cstIndexMap != null);
            a.add(new NameValuePair(this.cstIndexMap.getCstString(ioAnnotation.getNames()[i]), avr.getCstValue()));
        }
        return a;
    }

    private final class AnnotationValueReader
    extends EncodedValueReader {
        @CheckForNull
        private Constant constantValue;

        public AnnotationValueReader(@Nonnull DexBuffer dex, ByteInput in) {
            super(dex, in);
        }

        @Nonnull
        public Constant getCstValue() {
            assert (this.constantValue != null);
            return this.constantValue;
        }

        @Override
        protected void visitEncodedBoolean(int argAndType) {
            int arg = (argAndType & 0xE0) >> 5;
            this.constantValue = CstBoolean.make(arg);
        }

        @Override
        protected void visitString(int index) {
            assert (AnnotationMerger.this.cstIndexMap != null);
            this.constantValue = AnnotationMerger.this.cstIndexMap.getCstString(index);
        }

        @Override
        protected void visitEncodedNull(int argAndType) {
            this.constantValue = CstKnownNull.THE_ONE;
        }

        @Override
        public final void readAnnotation() {
            int typeIndex = Leb128Utils.readUnsignedLeb128(this.in);
            int size = Leb128Utils.readUnsignedLeb128(this.in);
            assert (AnnotationMerger.this.cstIndexMap != null);
            Annotation embeddedAnnotation = new Annotation(AnnotationMerger.this.cstIndexMap.getType(typeIndex), AnnotationVisibility.EMBEDDED);
            for (int i = 0; i < size; ++i) {
                assert (AnnotationMerger.this.cstIndexMap != null);
                CstString pairName = AnnotationMerger.this.cstIndexMap.getCstString(Leb128Utils.readUnsignedLeb128(this.in));
                this.readValue();
                assert (this.constantValue != null);
                embeddedAnnotation.add(new NameValuePair(pairName, this.constantValue));
                this.constantValue = null;
            }
            embeddedAnnotation.setImmutable();
            this.constantValue = new CstAnnotation(embeddedAnnotation);
        }

        @Override
        protected void visitAnnotation(int typeIndex, int size) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitAnnotationName(int nameIndex) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitMethodType(int index) {
            throw new AssertionError((Object)"Unsupported encoded value.");
        }

        @Override
        protected void visitAnnotationValue(int argAndType) {
        }

        @Override
        public void readArray() {
            int size = Leb128Utils.readUnsignedLeb128(this.in);
            CstArray.List constants = new CstArray.List(size);
            for (int i = 0; i < size; ++i) {
                this.readValue();
                constants.set(i, this.constantValue);
                this.constantValue = null;
            }
            constants.setImmutable();
            this.constantValue = new CstArray(constants);
        }

        @Override
        protected void visitArrayValue(int argAndType) {
        }

        @Override
        protected void visitField(int type, int index) {
            assert (AnnotationMerger.this.cstIndexMap != null);
            if (type == ValueEncoder.ValueType.VALUE_FIELD.getValue()) {
                this.constantValue = AnnotationMerger.this.cstIndexMap.getCstFieldRef(index);
            } else {
                assert (type == ValueEncoder.ValueType.VALUE_ENUM.getValue());
                FieldId fieldId = this.dexBuffer.fieldIds().get(index);
                this.constantValue = new CstEnumRef(AnnotationMerger.this.cstIndexMap.getCstString(fieldId.getNameIndex()), AnnotationMerger.this.cstIndexMap.getType(fieldId.getTypeIndex()));
            }
        }

        @Override
        protected void visitMethod(int index) {
            assert (AnnotationMerger.this.cstIndexMap != null);
            this.constantValue = AnnotationMerger.this.cstIndexMap.getCstMethodRef(index);
        }

        @Override
        protected void visitType(int index) {
            assert (AnnotationMerger.this.cstIndexMap != null);
            this.constantValue = AnnotationMerger.this.cstIndexMap.getType(index);
        }

        @Override
        protected void visitPrimitive(int type, int arg, int size) {
            this.constantValue = MergerTools.createConstant(this.in, type, arg);
        }
    }
}

