/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.statistics;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JForStatement;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.JWhileStatement;
import com.android.jack.statistics.BlockCountMarker;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Compute the number of block and extra block created to manage stand alone statement.")
@Name(value="BlockStatistics")
@Constraint(need={JMethodBody.class})
@Transform(add={BlockCountMarker.class})
@Synchronized
public class BlockStatistics
implements RunnableSchedulable<JMethod> {
    @Override
    public synchronized void run(@Nonnull JMethod method) {
        BlockCountMarker newbcm;
        if (method.isNative() || method.isAbstract()) {
            return;
        }
        JSession session = Jack.getSession();
        BlockCountMarker bcm = session.getMarker(BlockCountMarker.class);
        if (bcm == null && (bcm = session.addMarker(newbcm = new BlockCountMarker())) == null) {
            bcm = newbcm;
        }
        BlockStatisticsVisitor statistics = new BlockStatisticsVisitor(bcm);
        statistics.accept(method);
    }

    private static class BlockStatisticsVisitor
    extends JVisitor {
        @Nonnull
        private final BlockCountMarker bcm;

        public BlockStatisticsVisitor(@Nonnull BlockCountMarker bcm) {
            this.bcm = bcm;
        }

        @Override
        public boolean visit(@Nonnull JBlock block) {
            this.bcm.addExistingBlockCount(1);
            return super.visit(block);
        }

        @Override
        public boolean visit(@Nonnull JCatchBlock catchBlock) {
            this.bcm.addExistingBlockCount(1);
            return super.visit(catchBlock);
        }

        @Override
        public boolean visit(@Nonnull JIfStatement ifStmt) {
            if (!(ifStmt.getThenStmt() instanceof JBlock)) {
                this.bcm.addExtraIfThenBlockCount(1);
            }
            if (!(ifStmt.getElseStmt() instanceof JBlock)) {
                this.bcm.addExtraIfElseBlockCount(1);
            }
            return super.visit(ifStmt);
        }

        @Override
        public boolean visit(@Nonnull JLabeledStatement labeledStmt) {
            if (!(labeledStmt.getBody() instanceof JBlock)) {
                this.bcm.addExtraLabeledStatementBlockCount(1);
            }
            return super.visit(labeledStmt);
        }

        @Override
        public boolean visit(@Nonnull JForStatement forStmt) {
            JBlock parentBlock;
            JNode parent;
            if (!(forStmt.getBody() instanceof JBlock)) {
                this.bcm.addExtraForBodyBlockCount(1);
            }
            if ((parent = forStmt.getParent()) instanceof JBlock && (parentBlock = (JBlock)parent).getStatements().size() != 1) {
                this.bcm.addExtraImplicitForBlockCount(1);
            }
            return super.visit(forStmt);
        }

        @Override
        public boolean visit(@Nonnull JWhileStatement whileStmt) {
            if (!(whileStmt.getBody() instanceof JBlock)) {
                this.bcm.addExtraWhileBlockCount(1);
            }
            return super.visit(whileStmt);
        }
    }
}

