/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.nameprovider;

import com.android.jack.JackIOException;
import com.android.jack.shrob.obfuscation.key.Key;
import com.android.jack.shrob.obfuscation.nameprovider.NameProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class DictionaryNameProvider
implements NameProvider {
    @Nonnull
    private final NameProvider defaultNameProvider;
    @CheckForNull
    private BufferedReader br;

    public DictionaryNameProvider(@Nonnull File dictionary, @Nonnull NameProvider defaultNameProvider) throws JackIOException {
        this.defaultNameProvider = defaultNameProvider;
        try {
            this.br = new BufferedReader(new FileReader(dictionary));
        }
        catch (FileNotFoundException e) {
            throw new JackIOException("Dictionary " + dictionary.getPath() + " not found", e);
        }
    }

    @Override
    @Nonnull
    public String getNewName(@Nonnull Key key) {
        String nameFromDict;
        if (this.br != null && !(nameFromDict = this.getNameFromDictionary()).isEmpty()) {
            return nameFromDict;
        }
        return this.defaultNameProvider.getNewName(key);
    }

    @Nonnull
    private String getNameFromDictionary() {
        assert (this.br != null);
        StringBuilder name = new StringBuilder();
        try {
            int readCharAsInt;
            while ((readCharAsInt = this.br.read()) != -1) {
                char readChar = (char)readCharAsInt;
                if (name.length() != 0 && Character.isJavaIdentifierPart(readChar) || name.length() == 0 && Character.isJavaIdentifierStart(readChar)) {
                    name.append(readChar);
                    continue;
                }
                if (readChar == '#') {
                    this.br.readLine();
                }
                if (name.length() == 0) continue;
                return name.toString();
            }
        }
        catch (IOException e) {
            this.closeDictionary();
            throw new JackIOException("Failed to read obfuscation dictionary", e);
        }
        this.closeDictionary();
        return name.toString();
    }

    private void closeDictionary() {
        assert (this.br != null);
        try {
            this.br.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.br = null;
        }
    }

    @Override
    public boolean hasAlternativeName(@Nonnull Key oldKey) {
        return this.br != null && this.defaultNameProvider.hasAlternativeName(oldKey);
    }
}

