/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.annotation;

import com.android.jack.debug.DebugVariableInfoMarker;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.shrob.obfuscation.annotation.RemoveVariableGenericSignature;
import com.android.sched.item.Description;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import javax.annotation.Nonnull;

@Description(value="Removes signatures from variables")
@Support(value={RemoveVariableGenericSignature.class})
public class VariableGenericSignatureRemover
implements RunnableSchedulable<JMethod> {
    @Override
    public void run(@Nonnull JMethod method) {
        Visitor visitor = new Visitor();
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JVariableRef x) {
            DebugVariableInfoMarker debugInfo = x.getMarker(DebugVariableInfoMarker.class);
            if (debugInfo != null) {
                debugInfo.setGenericSignature(null);
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JVariable var) {
            var.removeMarker(GenericSignature.class);
            return false;
        }
    }
}

