/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.annotation;

import com.android.jack.debug.DebugVariableInfoMarker;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Removes parameters names")
@Constraint(need={JParameter.class, DebugVariableInfoMarker.class})
@Transform(modify={JParameter.class})
public class ParameterNameRemover
implements RunnableSchedulable<JMethod> {
    @Override
    public void run(@Nonnull JMethod t) {
        new Visitor().accept(t);
    }

    private static class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JParameterRef parameterRef) {
            DebugVariableInfoMarker marker = parameterRef.getMarker(DebugVariableInfoMarker.class);
            if (marker != null) {
                marker.setName(null);
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JParameter node) {
            node.setName(null);
            return false;
        }
    }
}

