/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.annotation;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfoFactory;
import com.android.jack.shrob.obfuscation.annotation.RemoveParameterLineNumber;
import com.android.sched.item.Description;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import javax.annotation.Nonnull;

@Description(value="Removes line numbers of parameters")
@Support(value={RemoveParameterLineNumber.class})
public class ParameterLineNumberRemover
implements RunnableSchedulable<JMethod> {
    @Override
    public void run(@Nonnull JMethod method) {
        Visitor visitor = new Visitor(Jack.getSession().getSourceInfoFactory());
        visitor.accept(method);
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final SourceInfoFactory sourceInfoFactory;

        public Visitor(@Nonnull SourceInfoFactory sourceInfoFactory) {
            this.sourceInfoFactory = sourceInfoFactory;
        }

        @Override
        public boolean visit(@Nonnull JParameter node) {
            SourceInfo info = node.getSourceInfo();
            if (info != SourceInfo.UNKNOWN) {
                node.setSourceInfo(info.getFileSourceInfo());
            }
            return true;
        }
    }
}

