/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.Jack;
import com.android.jack.frontend.MethodIdDuplicateRemover;
import com.android.jack.ir.ast.CanBeRenamed;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.jack.shrob.obfuscation.CollectingMappingApplier;
import com.android.jack.shrob.obfuscation.FieldInHierarchyFinderVisitor;
import com.android.jack.shrob.obfuscation.FinalNames;
import com.android.jack.shrob.obfuscation.KeepNameMarker;
import com.android.jack.shrob.obfuscation.MappingApplier;
import com.android.jack.shrob.obfuscation.MaskedHierarchy;
import com.android.jack.shrob.obfuscation.MethodInHierarchyFinder;
import com.android.jack.shrob.obfuscation.NameProviderFactory;
import com.android.jack.shrob.obfuscation.ObfuscationContextInfo;
import com.android.jack.shrob.obfuscation.OriginalNameMarker;
import com.android.jack.shrob.obfuscation.OriginalNameTools;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.shrob.obfuscation.OriginalPackageMarker;
import com.android.jack.shrob.obfuscation.key.FieldKey;
import com.android.jack.shrob.obfuscation.key.Key;
import com.android.jack.shrob.obfuscation.key.MethodKey;
import com.android.jack.shrob.obfuscation.nameprovider.NameProvider;
import com.android.jack.transformations.request.ChangeEnclosingPackage;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.jack.util.PackageCodec;
import com.android.sched.item.Description;
import com.android.sched.marker.MarkerManager;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.codec.PathCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.FileLocation;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="Visitor that renames JNodes")
@Constraint(need={KeepNameMarker.class, OriginalNames.class, MethodIdDuplicateRemover.UniqMethodIds.class}, no={FinalNames.class})
@Transform(remove={OriginalNames.class}, add={OriginalNameMarker.class, OriginalPackageMarker.class, FinalNames.class})
@Use(value={MappingApplier.class})
public class Renamer
implements RunnableSchedulable<JSession> {
    @Nonnull
    public static final BooleanPropertyId USE_PACKAGE_OBFUSCATION_DICTIONARY = BooleanPropertyId.create("jack.obfuscation.packagedictionary", "Use obfuscation dictionary for packages").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final PropertyId<File> PACKAGE_OBFUSCATION_DICTIONARY = PropertyId.create("jack.obfuscation.packagedictionary.file", "Obfuscation dictionary for packages", new PathCodec()).requiredIf(USE_PACKAGE_OBFUSCATION_DICTIONARY.getValue().isTrue());
    @Nonnull
    public static final BooleanPropertyId USE_CLASS_OBFUSCATION_DICTIONARY = BooleanPropertyId.create("jack.obfuscation.classdictionary", "Use obfuscation dictionary for classes").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final PropertyId<File> CLASS_OBFUSCATION_DICTIONARY = PropertyId.create("jack.obfuscation.classdictionary.file", "Obfuscation dictionary for classes", new PathCodec()).requiredIf(USE_CLASS_OBFUSCATION_DICTIONARY.getValue().isTrue());
    @Nonnull
    public static final BooleanPropertyId USE_OBFUSCATION_DICTIONARY = BooleanPropertyId.create("jack.obfuscation.dictionary", "Use obfuscation dictionary for members").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final PropertyId<File> OBFUSCATION_DICTIONARY = PropertyId.create("jack.obfuscation.dictionary.file", "Obfuscation dictionary for members", new PathCodec()).requiredIf(USE_OBFUSCATION_DICTIONARY.getValue().isTrue());
    @Nonnull
    public static final BooleanPropertyId USE_MAPPING = BooleanPropertyId.create("jack.obfuscation.mapping", "Use mapping for types and members").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final PropertyId<File> MAPPING_FILE = PropertyId.create("jack.obfuscation.mapping.file", "File containing the mapping of all types and members", new PathCodec()).addDefaultValue((File)((Object)"mapping.txt"));
    @Nonnull
    public static final BooleanPropertyId REPACKAGE_CLASSES = BooleanPropertyId.create("jack.obfuscation.repackageclasses", "Change package for all renamed classes").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final PropertyId<String> PACKAGE_FOR_RENAMED_CLASSES = ((PropertyId)PropertyId.create("jack.obfuscation.repackageclasses.package", "Enclosing package for all renamed classes", new PackageCodec()).requiredIf(REPACKAGE_CLASSES.getValue().isTrue())).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId FLATTEN_PACKAGE = BooleanPropertyId.create("jack.obfuscation.flattenpackage", "Change package for all renamed packages").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final PropertyId<String> PACKAGE_FOR_RENAMED_PACKAGES = ((PropertyId)PropertyId.create("jack.obfuscation.flattenpackage.package", "Enclosing package for all renamed packages", new PackageCodec()).requiredIf(FLATTEN_PACKAGE.getValue().isTrue())).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId USE_UNIQUE_CLASSMEMBERNAMES = BooleanPropertyId.create("jack.obfuscation.uniqueclassmembernames", "All members with the same name must have the same obfuscated name").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    private final NameProviderFactory nameProviderFactory;
    @CheckForNull
    private Collection<JDefinedClassOrInterface> allTypes;

    public static boolean mustBeRenamed(@Nonnull MarkerManager node) {
        return !node.containsMarker(KeepNameMarker.class) && !node.containsMarker(OriginalNameMarker.class);
    }

    private static void rename(@Nonnull CanBeRenamed node, @Nonnull NameProvider nameProvider) {
        if (Renamer.mustBeRenamed((MarkerManager)((Object)node))) {
            String newName = nameProvider.getNewName(Key.getKey(node));
            ((MarkerManager)((Object)node)).addMarker(new OriginalNameMarker(node.getName()));
            node.setName(newName);
        }
    }

    @Nonnull
    static String getFieldKey(@Nonnull JFieldId fieldId) {
        assert (!fieldId.containsMarker(OriginalNameMarker.class));
        StringBuilder sb = new StringBuilder();
        sb.append(fieldId.getName());
        sb.append(':');
        OriginalNameTools.appendOriginalQualifiedName(sb, fieldId.getType());
        return sb.toString();
    }

    @Nonnull
    static String getMethodKey(@Nonnull JMethodIdWide methodId) {
        assert (!methodId.containsMarker(OriginalNameMarker.class));
        StringBuilder sb = new StringBuilder();
        sb.append(methodId.getName());
        sb.append('(');
        Iterator<JType> iterator = methodId.getParamTypes().iterator();
        while (iterator.hasNext()) {
            JType paramType = iterator.next();
            OriginalNameTools.appendOriginalQualifiedName(sb, paramType);
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    @Nonnull
    static String getKey(@Nonnull HasName namedElement) {
        if (namedElement instanceof JFieldId) {
            return Renamer.getFieldKey((JFieldId)namedElement);
        }
        if (namedElement instanceof JMethodIdWide) {
            return Renamer.getMethodKey((JMethodIdWide)namedElement);
        }
        assert (!(namedElement instanceof JMethod || namedElement instanceof JMethodId || namedElement instanceof JField));
        return namedElement.getName();
    }

    private static void rename(@Nonnull CanBeRenamed node, @Nonnull String newName) {
        if (Renamer.mustBeRenamed((MarkerManager)((Object)node))) {
            ((MarkerManager)((Object)node)).addMarker(new OriginalNameMarker(node.getName()));
            node.setName(newName);
        }
    }

    public Renamer() {
        File dictionary = null;
        if (ThreadConfig.get(USE_OBFUSCATION_DICTIONARY).booleanValue()) {
            dictionary = ThreadConfig.get(OBFUSCATION_DICTIONARY);
        }
        File classDictionary = null;
        if (ThreadConfig.get(USE_CLASS_OBFUSCATION_DICTIONARY).booleanValue()) {
            classDictionary = ThreadConfig.get(CLASS_OBFUSCATION_DICTIONARY);
        }
        File packageDictionary = null;
        if (ThreadConfig.get(USE_PACKAGE_OBFUSCATION_DICTIONARY).booleanValue()) {
            packageDictionary = ThreadConfig.get(PACKAGE_OBFUSCATION_DICTIONARY);
        }
        this.nameProviderFactory = new NameProviderFactory(dictionary, classDictionary, packageDictionary);
    }

    @Override
    public void run(@Nonnull JSession session) {
        Visitor visitor;
        TransformationRequest request;
        this.allTypes = session.getTypesToEmit();
        HashMap<FieldKey, String> fieldNames = new HashMap();
        HashMap<MethodKey, String> methodNames = new HashMap();
        boolean useUniqueClassMemberNames = ThreadConfig.get(USE_UNIQUE_CLASSMEMBERNAMES);
        if (ThreadConfig.get(USE_MAPPING).booleanValue()) {
            MappingApplier mappingApplier;
            request = new TransformationRequest(session);
            if (useUniqueClassMemberNames) {
                mappingApplier = new CollectingMappingApplier(request);
                fieldNames = ((CollectingMappingApplier)mappingApplier).getFieldNames();
                methodNames = ((CollectingMappingApplier)mappingApplier).getMethodNames();
            } else {
                mappingApplier = new MappingApplier(request);
            }
            mappingApplier.applyMapping(ThreadConfig.get(MAPPING_FILE), session);
            request.commit();
        }
        if (useUniqueClassMemberNames) {
            HashSet<JFieldId> allFieldIds = new HashSet<JFieldId>();
            HashSet<JMethodIdWide> allMethodIds = new HashSet<JMethodIdWide>();
            for (JDefinedClassOrInterface type : this.allTypes) {
                for (JField field : type.getFields()) {
                    allFieldIds.add(field.getId());
                }
                for (JMethod method : type.getMethods()) {
                    allMethodIds.add(method.getMethodIdWide());
                }
            }
            this.nameProviderFactory.createGlobalFieldNameProvider(fieldNames, allFieldIds);
            this.nameProviderFactory.createGlobalMethodNameProvider(methodNames, allMethodIds);
        }
        if (ThreadConfig.get(REPACKAGE_CLASSES).booleanValue()) {
            request = new TransformationRequest(session);
            visitor = new RepackagerVisitor(request);
            visitor.accept(session);
            request.commit();
        } else if (ThreadConfig.get(FLATTEN_PACKAGE).booleanValue()) {
            request = new TransformationRequest(session);
            visitor = new FlattenerVisitor(request);
            visitor.accept(session);
            request.commit();
        } else {
            Visitor visitor2 = new Visitor();
            visitor2.accept(session);
        }
    }

    private class FlattenerVisitor
    extends Visitor {
        @Nonnull
        private final TransformationRequest request;
        @Nonnull
        private final String packageNameForRenamedPackages;
        @Nonnull
        private final JPackage packageForRenamedPackages;
        @Nonnull
        private final NameProvider packageNameProvider;

        private FlattenerVisitor(TransformationRequest request) {
            this.packageNameForRenamedPackages = NamingTools.getBinaryName(ThreadConfig.get(PACKAGE_FOR_RENAMED_PACKAGES));
            this.packageForRenamedPackages = Jack.getSession().getLookup().getOrCreatePackage(this.packageNameForRenamedPackages);
            this.packageNameProvider = Renamer.this.nameProviderFactory.getPackageNameProvider(this.packageForRenamedPackages.getSubPackages());
            this.request = request;
        }

        @Override
        public boolean visit(@Nonnull JPackage pack) {
            List<JPackage> subPackages = pack.getSubPackages();
            for (JPackage subPack : subPackages) {
                if (!Renamer.mustBeRenamed(subPack) || subPack.equals(this.packageForRenamedPackages)) continue;
                this.request.append(new ChangeEnclosingPackage(subPack, this.packageForRenamedPackages));
                subPack.addMarker(new OriginalPackageMarker(pack));
                Renamer.rename(subPack, this.packageNameProvider);
            }
            List<JDefinedClassOrInterface> types = pack.getTypes();
            NameProvider classNameProvider = Renamer.this.nameProviderFactory.getClassNameProvider(types);
            for (JClassOrInterface jClassOrInterface : types) {
                if (!(jClassOrInterface instanceof JDefinedClassOrInterface)) continue;
                Renamer.rename((JDefinedClassOrInterface)jClassOrInterface, classNameProvider);
            }
            return true;
        }
    }

    private class RepackagerVisitor
    extends Visitor {
        @Nonnull
        private final TransformationRequest request;
        @Nonnull
        private final String packageNameForRenamedClasses;
        @Nonnull
        private final JPackage packageForRenamedClasses;
        @Nonnull
        private final NameProvider classNameProvider;

        private RepackagerVisitor(TransformationRequest request) {
            this.packageNameForRenamedClasses = NamingTools.getBinaryName(ThreadConfig.get(PACKAGE_FOR_RENAMED_CLASSES));
            this.packageForRenamedClasses = Jack.getSession().getLookup().getOrCreatePackage(this.packageNameForRenamedClasses);
            this.classNameProvider = Renamer.this.nameProviderFactory.getClassNameProvider(this.packageForRenamedClasses.getTypes());
            this.request = request;
        }

        @Override
        public boolean visit(@Nonnull JPackage pack) {
            for (JClassOrInterface jClassOrInterface : pack.getTypes()) {
                if (!Renamer.mustBeRenamed((MarkerManager)((Object)jClassOrInterface))) continue;
                JPackage oldEnclosingPackage = jClassOrInterface.getEnclosingPackage();
                assert (oldEnclosingPackage != null);
                ((MarkerManager)((Object)jClassOrInterface)).addMarker(new OriginalPackageMarker(oldEnclosingPackage));
                this.request.append(new ChangeEnclosingPackage(jClassOrInterface, this.packageForRenamedClasses));
                Renamer.rename((JDefinedClassOrInterface)jClassOrInterface, this.classNameProvider);
            }
            return super.visit(pack);
        }
    }

    private class Visitor
    extends JVisitor {
        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JPackage pack) {
            List<JPackage> subPackages = pack.getSubPackages();
            NameProvider packageNameProvider = Renamer.this.nameProviderFactory.getPackageNameProvider(subPackages);
            for (JPackage subPack : subPackages) {
                Renamer.rename(subPack, packageNameProvider);
            }
            List<JDefinedClassOrInterface> types = pack.getTypes();
            NameProvider classNameProvider = Renamer.this.nameProviderFactory.getClassNameProvider(types);
            for (JClassOrInterface jClassOrInterface : types) {
                if (!(jClassOrInterface instanceof JDefinedClassOrInterface)) continue;
                Renamer.rename((JDefinedClassOrInterface)jClassOrInterface, classNameProvider);
            }
            return super.visit(pack);
        }

        @Override
        public boolean visit(@Nonnull JDefinedClassOrInterface type) {
            if (type.isToEmit()) {
                NameProvider fieldNameProvider = Renamer.this.nameProviderFactory.getFieldNameProvider();
                for (JField field : type.getFields()) {
                    JFieldId fieldId = field.getId();
                    if (!Renamer.mustBeRenamed(fieldId)) continue;
                    String name = null;
                    try {
                        boolean foundName;
                        do {
                            FieldKey oldFieldKey;
                            if (!(foundName = FieldInHierarchyFinderVisitor.containsFieldKey(new FieldKey(name = fieldNameProvider.getNewName(oldFieldKey = new FieldKey(fieldId)), field.getType()), field)) || fieldNameProvider.hasAlternativeName(oldFieldKey)) continue;
                            throw new MaskedHierarchy(field.getName(), type, name);
                        } while (foundName);
                    }
                    catch (MaskedHierarchy e) {
                        SourceInfo sourceInfo = field.getSourceInfo();
                        Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new ObfuscationContextInfo(new ColumnAndLineLocation(new FileLocation(sourceInfo.getFileName()), sourceInfo.getStartLine()), Reportable.ProblemLevel.INFO, e));
                    }
                    Renamer.rename(fieldId, name);
                }
                NameProvider methodNameProvider = Renamer.this.nameProviderFactory.getMethodNameProvider();
                for (JMethod method : type.getMethods()) {
                    JMethodIdWide methodId = method.getMethodId().getMethodIdWide();
                    if (!Renamer.mustBeRenamed(methodId)) continue;
                    String name = null;
                    try {
                        boolean foundName;
                        do {
                            MethodKey oldMethodKey;
                            if (!(foundName = MethodInHierarchyFinder.containsMethodKey(new MethodKey(name = methodNameProvider.getNewName(oldMethodKey = new MethodKey(methodId)), methodId.getParamTypes()), methodId)) || methodNameProvider.hasAlternativeName(oldMethodKey)) continue;
                            throw new MaskedHierarchy(methodId.getName(), type, name);
                        } while (foundName);
                    }
                    catch (MaskedHierarchy e) {
                        SourceInfo sourceInfo = method.getSourceInfo();
                        Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new ObfuscationContextInfo(new ColumnAndLineLocation(new FileLocation(sourceInfo.getFileName()), sourceInfo.getStartLine()), Reportable.ProblemLevel.INFO, e));
                    }
                    Renamer.rename(methodId, name);
                }
            }
            return false;
        }
    }
}

