/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.google.common.base.Strings;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JType;
import com.android.jack.shrob.obfuscation.OriginalNameMarker;
import com.android.jack.shrob.obfuscation.OriginalPackageMarker;
import com.android.sched.marker.LocalMarkerManager;
import javax.annotation.Nonnull;

public class OriginalNameTools {
    private static final char PACKAGE_SEPARATOR = '.';

    public static void appendOriginalQualifiedName(@Nonnull StringBuilder nameBuilder, @Nonnull JPackage pack) {
        OriginalPackageMarker marker = pack.getMarker(OriginalPackageMarker.class);
        JPackage enclosingPackage = marker != null ? marker.getOriginalEnclosingPackage() : pack.getEnclosingPackage();
        if (enclosingPackage != null && !enclosingPackage.isTopLevelPackage()) {
            OriginalNameTools.appendOriginalQualifiedName(nameBuilder, enclosingPackage);
            nameBuilder.append('.');
        }
        OriginalNameTools.appendOriginalName(nameBuilder, pack);
    }

    public static void appendOriginalQualifiedName(@Nonnull StringBuilder nameBuilder, @Nonnull JClassOrInterface type) {
        OriginalPackageMarker marker = ((JNode)((Object)type)).getMarker(OriginalPackageMarker.class);
        JPackage enclosingPackage = marker != null ? marker.getOriginalEnclosingPackage() : type.getEnclosingPackage();
        assert (enclosingPackage != null);
        OriginalNameTools.appendOriginalQualifiedName(nameBuilder, enclosingPackage);
        if (!enclosingPackage.isTopLevelPackage()) {
            nameBuilder.append('.');
        }
        OriginalNameTools.appendOriginalName(nameBuilder, type);
    }

    public static void appendOriginalName(@Nonnull StringBuilder nameBuilder, @Nonnull HasName node) {
        OriginalNameMarker marker = ((LocalMarkerManager)((Object)node)).getMarker(OriginalNameMarker.class);
        if (marker != null) {
            nameBuilder.append(marker.getOriginalName());
        } else {
            nameBuilder.append(node.getName());
        }
    }

    public static void appendOriginalQualifiedName(@Nonnull StringBuilder nameBuilder, @Nonnull HasName node) {
        if (node instanceof JArrayType) {
            JArrayType arrayType = (JArrayType)node;
            OriginalNameTools.appendOriginalQualifiedName(nameBuilder, arrayType.getLeafType());
            nameBuilder.append(Strings.repeat("[]", arrayType.getDims()));
        } else if (node instanceof JDefinedClassOrInterface) {
            OriginalNameTools.appendOriginalQualifiedName(nameBuilder, (JClassOrInterface)node);
        } else if (node instanceof JType) {
            nameBuilder.append(node.getName());
        } else {
            OriginalNameTools.appendOriginalName(nameBuilder, node);
        }
    }
}

