/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.shrob.obfuscation.NewFieldKeyMarker;
import com.android.jack.shrob.obfuscation.OneTimeHierarchyVisitor;
import com.android.jack.shrob.obfuscation.Renamer;
import com.android.jack.shrob.obfuscation.key.FieldKey;
import javax.annotation.Nonnull;

public class FieldInHierarchyFinderVisitor
extends OneTimeHierarchyVisitor {
    @Nonnull
    private final FieldKey fieldKey;
    private boolean hasFoundField = false;

    private FieldInHierarchyFinderVisitor(@Nonnull FieldKey fieldKey) {
        this.fieldKey = fieldKey;
    }

    public void startVisit(@Nonnull JDefinedClassOrInterface type) {
        for (JField field : type.getFields()) {
            JFieldId id = field.getId();
            if (!field.isPrivate() || Renamer.mustBeRenamed(id) || !new FieldKey(id).equals(this.fieldKey)) continue;
            this.hasFoundField = true;
            return;
        }
        this.visitSuperTypes(type);
        this.visitSubTypes(type);
    }

    @Override
    public boolean doAction(@Nonnull JDefinedClassOrInterface type) {
        NewFieldKeyMarker marker = type.getMarker(NewFieldKeyMarker.class);
        if (marker != null && marker.getNewKeys().contains(this.fieldKey)) {
            this.hasFoundField = true;
            return false;
        }
        for (JField field : type.getFields()) {
            JFieldId id = field.getId();
            if (field.isPrivate() || Renamer.mustBeRenamed(id) || !new FieldKey(id).equals(this.fieldKey)) continue;
            this.hasFoundField = true;
            return false;
        }
        return true;
    }

    public static boolean containsFieldKey(@Nonnull FieldKey key, @Nonnull JField field) {
        FieldInHierarchyFinderVisitor visitor = new FieldInHierarchyFinderVisitor(key);
        visitor.startVisit(field.getEnclosingType());
        return visitor.hasFoundField;
    }
}

