/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.resource;

import com.android.jack.resource.ResourceImportConflictException;
import com.android.jack.resource.ResourceOrMeta;
import com.android.jack.resource.ResourceReadingException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.InputVDir;
import com.android.sched.vfs.InputVElement;
import com.android.sched.vfs.InputVFS;
import com.android.sched.vfs.InputVFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class ResourceOrMetaImporter {
    protected static final char VPATH_SEPARATOR = '/';
    @Nonnull
    private final List<InputVFS> resourceDirs;

    public ResourceOrMetaImporter(@Nonnull List<InputVFS> resourceDirs) {
        this.resourceDirs = resourceDirs;
    }

    @Nonnull
    public List<? extends ResourceOrMeta> getImports() throws ResourceReadingException {
        ArrayList<ResourceOrMeta> resultList = new ArrayList<ResourceOrMeta>();
        try {
            for (InputVFS resourceDir : this.resourceDirs) {
                this.importResourceDirElement(resourceDir.getRootDir().list(), "", resourceDir.getLocation(), resultList);
            }
        }
        catch (ResourceImportConflictException e) {
            throw new ResourceReadingException(e);
        }
        return resultList;
    }

    private void importResourceDirElement(@Nonnull Collection<? extends InputVElement> elements, @Nonnull String currentPath, @Nonnull Location resourceDirLocation, @Nonnull List<ResourceOrMeta> resultList) throws ResourceImportConflictException {
        for (InputVElement inputVElement : elements) {
            String path = currentPath + inputVElement.getName();
            if (inputVElement.isVDir()) {
                this.importResourceDirElement(((InputVDir)inputVElement).list(), path + '/', resourceDirLocation, resultList);
                continue;
            }
            InputVFile file = (InputVFile)inputVElement;
            this.addImportedResource(file, path, resourceDirLocation, resultList);
        }
    }

    protected abstract void addImportedResource(@Nonnull InputVFile var1, @Nonnull String var2, @Nonnull Location var3, @Nonnull List<ResourceOrMeta> var4) throws ResourceImportConflictException;
}

