/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.wofr;

import com.android.jack.Jack;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JThisRef;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.optimizations.common.JlsNullabilityChecker;
import com.android.jack.optimizations.wofr.FieldReadWriteCountsMarker;
import com.android.jack.optimizations.wofr.WofrSchedulable;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.PrependAfter;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Write-only field removal, field writes removal")
@Constraint(need={ControlFlowGraph.class, JFieldRef.class, FieldReadWriteCountsMarker.class})
@Transform(modify={FieldReadWriteCountsMarker.class}, add={JExpressionStatement.class})
@Name(value="WriteOnlyFieldRemoval: RemoveFieldWrites")
@Use(value={JlsNullabilityChecker.class, LocalVarCreator.class})
public class WofrRemoveFieldWrites
extends WofrSchedulable
implements RunnableSchedulable<JMethod> {
    private final boolean preserveObjectLifetime = ThreadConfig.get(Optimizations.WriteOnlyFieldRemoval.PRESERVE_OBJECT_LIFETIME);
    private final boolean ensureTypeInitializers = ThreadConfig.get(Optimizations.WriteOnlyFieldRemoval.ENSURE_TYPE_INITIALIZERS);
    public final boolean preserveNullChecks = ThreadConfig.get(Optimizations.WriteOnlyFieldRemoval.PRESERVE_NULL_CHECKS);
    @Nonnull
    private final JPhantomLookup phantomLookup = Jack.getSession().getPhantomLookup();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    private Action classify(@Nonnull JMethod method, @Nonnull JFieldRef ref) {
        JField field = ref.getFieldId().getField();
        if (field == null || !field.getAnnotations(this.disablingAnnotationType).isEmpty() || !field.getEnclosingType().getAnnotations(this.disablingAnnotationType).isEmpty()) {
            return Action.None;
        }
        if (field.isVolatile()) {
            return Action.None;
        }
        if (FieldReadWriteCountsMarker.hasReads(field)) {
            return Action.None;
        }
        JDefinedClassOrInterface fieldOwningType = field.getEnclosingType();
        if (!fieldOwningType.isToEmit()) {
            return Action.None;
        }
        if (this.preserveObjectLifetime && !(field.getType() instanceof JPrimitiveType) && FieldReadWriteCountsMarker.hasNonLiteralWrites(field)) {
            return Action.None;
        }
        if (this.ensureTypeInitializers && field.isStatic() && !fieldOwningType.isSameType(method.getEnclosingType())) {
            return Action.None;
        }
        if (field.isStatic() || ref.getInstance() instanceof JThisRef) {
            return Action.Expression;
        }
        assert (!field.isStatic());
        return this.preserveNullChecks ? Action.ReceiverExpressionAndNullCheck : Action.ReceiverAndExpression;
    }

    @Override
    public void run(final @Nonnull JMethod method) {
        if (method.isAbstract() || method.isNative()) {
            return;
        }
        final TransformationRequest request = new TransformationRequest(method);
        final LocalVarCreator varCreator = new LocalVarCreator(method, "wofr");
        final JlsNullabilityChecker nullChecker = new JlsNullabilityChecker(varCreator, this.phantomLookup);
        class Processor {
            Processor() {
            }

            private void handleExprStmt(@Nonnull JExpressionStatement stmt) {
                JAsgOperation asg;
                JExpression lhs;
                JExpression expr = stmt.getExpr();
                if (expr instanceof JAsgOperation && (lhs = (asg = (JAsgOperation)expr).getLhs()) instanceof JFieldRef) {
                    JFieldRef ref = (JFieldRef)lhs;
                    switch (WofrRemoveFieldWrites.this.classify(method, ref)) {
                        case None: {
                            return;
                        }
                        case ReceiverExpressionAndNullCheck: {
                            JLocal local = this.handleFieldReceiver(asg, true);
                            assert (local != null);
                            this.handleAssignmentRhs(asg);
                            JStatement nullCheck = nullChecker.createNullCheck(local.makeRef(local.getSourceInfo()), request);
                            request.append(new PrependAfter(stmt, nullCheck));
                            break;
                        }
                        case ReceiverAndExpression: {
                            this.handleFieldReceiver(asg, false);
                            this.handleAssignmentRhs(asg);
                            break;
                        }
                        case Expression: {
                            this.handleAssignmentRhs(asg);
                        }
                    }
                    JField field = ref.getFieldId().getField();
                    assert (field != null);
                    FieldReadWriteCountsMarker.unmarkWrite(field);
                    WofrRemoveFieldWrites.this.tracer.getStatistic(WofrSchedulable.FIELD_WRITES_REMOVED).incValue();
                }
            }

            private void handleAssignmentRhs(@Nonnull JAsgOperation asg) {
                JExpression rhs = asg.getRhs();
                if (rhs instanceof JMethodCall) {
                    request.append(new Replace(asg, rhs));
                } else {
                    JExpression lhs = asg.getLhs();
                    JLocal local = varCreator.createTempLocal(lhs.getType(), lhs.getSourceInfo(), request);
                    request.append(new Replace(lhs, local.makeRef(local.getSourceInfo())));
                }
            }

            @CheckForNull
            private JLocal handleFieldReceiver(@Nonnull JAsgOperation asg, boolean forceLocal) {
                JExpression receiver = ((JFieldRef)asg.getLhs()).getInstance();
                assert (receiver != null);
                JLocal local = null;
                if (!(receiver instanceof JMethodCall) || forceLocal) {
                    local = varCreator.createTempLocal(receiver.getType(), receiver.getSourceInfo(), request);
                    receiver = new JAsgOperation(receiver.getSourceInfo(), local.makeRef(receiver.getSourceInfo()), receiver);
                }
                JExpressionStatement stmt = new JExpressionStatement(asg.getSourceInfo(), receiver);
                JNode parent = asg.getParent();
                assert (parent != null);
                request.append(new AppendBefore(parent, stmt));
                return local;
            }
        }
        Processor processor = new Processor();
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        for (BasicBlock bb : cfg.getNodes()) {
            for (JStatement stmt : bb.getStatements()) {
                if (!(stmt instanceof JExpressionStatement)) continue;
                processor.handleExprStmt((JExpressionStatement)stmt);
            }
        }
        request.commit();
    }

    private static enum Action {
        None,
        Expression,
        ReceiverAndExpression,
        ReceiverExpressionAndNullCheck;

    }
}

